/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.tests.navigator;

import fuego.jdev.test.BaseTestCase;
import fuego.jdev.test.UiRunnable;
import fuego.jdev.test.tests.BaseProjectTest;
import fuego.jdev.test.toolkit.ProjectObjects;
import junit.framework.Assert;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.tree.TreeNode;

public class NavigatorNodeTest
extends BaseProjectTest {
    private ProjectObjects.ProjectObjectHandle<ProjectObject> handle;

    public NavigatorNodeTest(Project project, ProjectObjects.ProjectObjectHandle<ProjectObject> handle) {
        super("navigatorNode-" + handle);
        this.handle = handle;
    }

    protected void runTest() throws Throwable {
        final ProjectObject object = this.handle.create();
        this.handle.addToModel(object);
        final TreeNode node = (TreeNode)this.waitUntilNotNull(new BaseTestCase.Expression(){

            @Override
            public Object evaluate() {
                return NavigatorNodeTest.this.workbench().findNodeInNavigator(object);
            }
        }, "Could not find node for object '" + object + "' in project navigator");
        this.runInUi(new UiRunnable(){

            @Override
            public Object run() throws Throwable {
                Image icon = node.getIcon();
                Assert.assertNotNull((String)("Node doesn't have icon: " + node), (Object)icon);
                return null;
            }
        });
        this.runInUi(new UiRunnable(){

            @Override
            public Object run() throws Throwable {
                Object userObject = node.getUserObject();
                Assert.assertNotNull((String)"Null user object", (Object)userObject);
                return null;
            }
        });
        ActionGroup actions = (ActionGroup)this.runInUi(new UiRunnable(){

            @Override
            public Object run() throws Throwable {
                return node.createActions();
            }
        });
        NavigatorNodeTest.assertNotNull((String)("Node without actions: " + node), (Object)actions);
        for (BaseAction action : actions.getActions()) {
            if (action == BaseAction.SEPARATOR) continue;
            NavigatorNodeTest.assertNotNull((String)("Action without message" + action), (Object)action.getMsg());
        }
        this.handle.removeFromModel(object);
    }
}

