/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.tests.editors;

import fuego.jdev.test.tests.BaseProjectTest;
import fuego.jdev.test.toolkit.ProjectObjects;
import java.net.URL;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.ide.net.URLFileSystem;

public class EditorTest
extends BaseProjectTest {
    public void testOpenAndClose() throws Throwable {
        Project project = this.getProject();
        ProjectObjects.ProjectObjectHandle<ProjectObject>[] handles = ProjectObjects.createHandles(project);
        URL projectUrl = EditorTest.adaptTo(project, URL.class);
        for (ProjectObjects.ProjectObjectHandle<ProjectObject> handle : handles) {
            if (!handle.hasEditor()) continue;
            ProjectObject object = handle.create();
            handle.addToModel(object);
            this.workbench().openEditorForObject(object);
            StudioEditor editor = this.workbench().findEditorByObject(object);
            EditorTest.assertFalse((String)("Editor is dirty after opening: " + editor.getClass()), (boolean)editor.isDirty());
            EditorTest.assertNotNull((String)("Editor doesn't have title: " + editor.getClass()), (Object)editor.getTitle());
            EditorTest.assertNotNull((String)("Editor doesn't have icon: " + editor.getClass()), (Object)editor.getIcon());
            EditorTest.assertNotNull((String)"Editor without input", (Object)editor.getInput());
            if (handle.isAdaptableToUrl()) {
                URL url = EditorTest.adaptTo(object, URL.class);
                EditorTest.assertNotNull((String)("Editor project object cannot be adapted to URL for " + editor.getClass()), (Object)url);
                EditorTest.assertTrue((String)("Editor project object URL must be based on Project URL for " + editor.getClass()), (boolean)URLFileSystem.isBaseURLFor((URL)projectUrl, (URL)url));
            }
            if (!handle.isUpdatable()) continue;
            handle.updateData(object);
            EditorTest.assertTrue((String)("Editor is not dirty after changes: " + editor.getClass()), (boolean)editor.isDirty());
        }
    }
}

