/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.tests;

import fuego.jdev.test.BaseTestCase;
import fuego.jdev.test.I18n;
import java.net.URL;
import java.util.ArrayList;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.ide.model.Project;

public class ProjectTest
extends BaseTestCase {
    private static final int NRO_PROJECTS = 5;
    private static final String PROJECT_NAME = I18n.msg("ProjectTest");

    public void testCreateDeleteProjects() throws ProjectException {
        int nProjectsCreated = ProjectTest.getProjectRepository().getAllProjects().size();
        ArrayList<oracle.bpm.project.model.Project> projects = new ArrayList<oracle.bpm.project.model.Project>();
        for (int i = 0; i < 5; ++i) {
            oracle.bpm.project.model.Project project = ProjectTest.createProject(PROJECT_NAME + i);
            ProjectTest.verifyAdapters(project);
            this.verifyProjectInNavigator(project);
            projects.add(project);
        }
        int size = ProjectTest.getProjectRepository().getAllProjects().size();
        ProjectTest.assertEquals((String)("Nro. BPM Projects in Project Repository should be " + ProjectTest.Q(nProjectsCreated + 5)), (int)size, (int)(nProjectsCreated + 5));
        ProjectTest.assertEquals((String)"Error creating 5 BPM Projects", (int)5, (int)projects.size());
        for (int i = 0; i < 5; ++i) {
            oracle.bpm.project.model.Project project = (oracle.bpm.project.model.Project)projects.get(i);
            ProjectTest.deleteProject(project);
            this.verifyProjectNotInNavigator(project);
        }
        size = ProjectTest.getProjectRepository().getAllProjects().size();
        ProjectTest.assertEquals((String)("Nro. BPM Projects in Project Repository should be " + ProjectTest.Q(nProjectsCreated)), (int)size, (int)nProjectsCreated);
    }

    private static void verifyAdapters(oracle.bpm.project.model.Project project) {
        Project jdevProject = ProjectTest.adaptTo(project, Project.class);
        assert (jdevProject != null) : "Could not adapt BPM Project to Jdev Project";
        URL url = ProjectTest.adaptTo(project, URL.class);
        assert (url != null) : "Could not adapt BPM Project to URL";
    }

    private void verifyProjectInNavigator(final oracle.bpm.project.model.Project project) {
        BaseTestCase.Expression expresion = new BaseTestCase.Expression(){

            @Override
            public Object evaluate() {
                return ProjectTest.this.workbench().findNodeInNavigator(project);
            }
        };
        this.waitUntilNotNull(expresion, "Could not find node for BPM Project " + ProjectTest.Q(project) + " in Project Navigator");
    }

    private void verifyProjectNotInNavigator(final oracle.bpm.project.model.Project project) {
        BaseTestCase.Expression expression = new BaseTestCase.Expression(){

            @Override
            public Object evaluate() {
                return ProjectTest.this.workbench().findNodeInNavigator(project) == null;
            }
        };
        ProjectTest.waitUntil(expression, "BPM Project " + ProjectTest.Q(project) + " was not removed from Project Navigator");
    }
}

