/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.tests;

import fuego.jdev.test.I18n;
import fuego.jdev.test.tests.BaseProjectTest;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;

public class ProjectDataObjectTest
extends BaseProjectTest {
    private static final DataObjectTemplate STRING_DATA_OBJECT = DataObjectTemplate.create(I18n.msg("MyString"), CatalogType.Default.getString());
    private static final DataObjectTemplate BOOLEAN_DATA_OBJECT = DataObjectTemplate.create(I18n.msg("MyBoolean"), CatalogType.Default.getBool());
    private static final DataObjectTemplate INT_DATA_OBJECT = DataObjectTemplate.create(I18n.msg("MyInt"), CatalogType.Default.getInt());
    private static final DataObjectTemplate DECIMAL_DATA_OBJECT = DataObjectTemplate.create(I18n.msg("MyDecimal"), CatalogType.Default.getDecimal());
    private static final DataObjectTemplate[] DATA_OBJECTS = new DataObjectTemplate[]{STRING_DATA_OBJECT, BOOLEAN_DATA_OBJECT, INT_DATA_OBJECT, DECIMAL_DATA_OBJECT};

    public void testProjectDataObjects() throws Exception {
        ProjectDataObject dataObject;
        Project project = this.getProject();
        for (DataObjectTemplate template : DATA_OBJECTS) {
            dataObject = project.createDeclaration(template.getName(), template.getType());
            project.addDeclaration((DataDeclaration)dataObject);
        }
        ProjectDataObjectTest.assertEquals((String)"Project DataObjects", (int)DATA_OBJECTS.length, (int)project.getProjectDataObjects().toArray().length);
        for (DataObjectTemplate template : DATA_OBJECTS) {
            dataObject = project.findDataObject(template.getName());
            project.removeDeclaration((DataDeclaration)dataObject);
        }
        ProjectDataObjectTest.assertEquals((String)"Project DataObjects should be 0", (int)0, (int)project.getProjectDataObjects().toArray().length);
    }

    private static class DataObjectTemplate {
        private String name;
        private CatalogType type;

        private DataObjectTemplate(String name, CatalogType type) {
            this.name = name;
            this.type = type;
        }

        public static DataObjectTemplate create(String name, CatalogType type) {
            return new DataObjectTemplate(name, type);
        }

        public String getName() {
            return this.name;
        }

        public CatalogType getType() {
            return this.type;
        }
    }
}

