/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.tests;

import fuego.jdev.test.I18n;
import fuego.jdev.test.UiRunnable;
import fuego.jdev.test.tests.process.BaseProcessTest;
import java.net.URL;
import java.util.ArrayList;
import junit.framework.Assert;
import oracle.bpm.command.Command;
import oracle.bpm.fusion.soa.humantask.HumanTaskInfo;
import oracle.bpm.fusion.soa.humantask.HumanTaskUtils;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.design.AddActivityCommand;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.command.design.ChangeActivityTypeCommand;
import oracle.bpm.project.command.design.ChangeTriggerTypeCommand;
import oracle.bpm.project.command.design.SwitchLaneCommand;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.UserTask;
import oracle.tip.tools.ide.workflow.editor.data.WFEditorData;
import oracle.tip.tools.ide.workflow.projectwizard.WizardData;

public class HumanTaskTest
extends BaseProcessTest {
    private static final String PROCESS_NAME = I18n.msg("HumanTaskTestProcess");
    private static final String ROLE_NAME = I18n.msg("UserRole");
    private static final HumanTaskTemplate INITIATOR_TASK_NAME = HumanTaskTemplate.create("InitiatorHumanTask", I18n.msg("InitiatorUserTask"), BpmnType.USER_TASK, HumanTaskType.INITIATOR);
    private static final HumanTaskTemplate SIMPLE_TASK_NAME = HumanTaskTemplate.create("SimpleHumanTask", I18n.msg("SimpleUserTask"), BpmnType.USER_TASK, HumanTaskType.SIMPLE);
    private static final HumanTaskTemplate FYI_TASK_NAME = HumanTaskTemplate.create("FyiHumanTask", I18n.msg("FyiUserTask"), BpmnType.USER_TASK, HumanTaskType.FYI);
    private static final HumanTaskTemplate COMPLEX_TASK_NAME = HumanTaskTemplate.create("ComplexHumanTask", I18n.msg("ComplexUserTask"), BpmnType.USER_TASK, HumanTaskType.COMPLEX);
    private static final HumanTaskTemplate GROUP_TASK_NAME = HumanTaskTemplate.create("GroupHumanTask", I18n.msg("GroupUserTask"), BpmnType.USER_TASK, HumanTaskType.GROUP);
    private static final HumanTaskTemplate MANAGEMENT_TASK_NAME = HumanTaskTemplate.create("ManagementHumanTask", I18n.msg("ManagementUserTask"), BpmnType.USER_TASK, HumanTaskType.MANAGEMENT);
    private static final HumanTaskTemplate[] ACTIVITIES = new HumanTaskTemplate[]{INITIATOR_TASK_NAME, SIMPLE_TASK_NAME, FYI_TASK_NAME, COMPLEX_TASK_NAME, GROUP_TASK_NAME, MANAGEMENT_TASK_NAME};

    public void testNewHumanTask() throws Exception {
        final Project project = this.getProject();
        final URL url = HumanTaskTest.adaptTo(project, URL.class);
        final ArrayList humanTasks = new ArrayList(ACTIVITIES.length);
        this.runInUi(new UiRunnable(){

            @Override
            public Object run() {
                try {
                    for (HumanTaskTemplate template : ACTIVITIES) {
                        String name = template.getHumanTaskName();
                        WizardData data = HumanTaskTest.createDefaultWizardData(url, name);
                        WFEditorData editorData = HumanTaskTest.createDefaultWFEditorData(project.getId());
                        HumanTaskInfo humanTaskInfo = new HumanTaskInfo();
                        humanTaskInfo.setHumanTaskType(template.getHumanTaskType());
                        HumanTask humanTask = HumanTaskUtils.createHumanTask((Project)project, (WizardData)data, (WFEditorData)editorData, (HumanTaskInfo)humanTaskInfo);
                        Assert.assertNotNull((String)("Error creating HumanTask " + HumanTaskTest.Q(name) + ". Human Task is null"), (Object)humanTask);
                        humanTasks.add(humanTask);
                    }
                }
                catch (ProjectException e) {
                    Assert.fail((String)e.getMessage());
                }
                return null;
            }
        });
        Organization organization = this.getProject().getOrganization();
        Role role = organization.createRole(ROLE_NAME, ROLE_NAME);
        organization.addChild((ProjectObject)role);
        Process process = this.createProcess(PROCESS_NAME);
        this.workbench().openEditorForObject(process);
        StartEvent startEvent = HumanTaskTest.getStartEvent(process);
        HumanTaskTest.run((Command)new ChangeTriggerTypeCommand((Event)startEvent, EventTriggerType.NONE));
        HumanTaskTest.run((Command)((Object)BaseProcessTest.RemoveStarEndSequenceFlowCommand.create(process)));
        HumanTaskTest.run((Command)new SwitchLaneCommand(startEvent.getLane(), ROLE_NAME, -1));
        HumanTaskTest.runLayout(process);
        StartEvent previous = HumanTaskTest.getStartEvent(process);
        int i = 0;
        for (HumanTaskTemplate template : ACTIVITIES) {
            Activity activity = process.createActivity();
            activity.setDefaultLabel(template.getTaskName());
            ChangeActivityTypeCommand.change((Activity)activity, (BpmnType)template.getType());
            UserTask userTask = (UserTask)activity.asAnyNode(UserTask.class);
            userTask.setHumanTask((HumanTask)humanTasks.get(i++));
            HumanTaskTest.run((Command)new AddActivityCommand((FlowNode)userTask, new Point(10, 10)));
            HumanTaskTest.run((Command)new AddTransitionCommand((NodeContainer)process, (FlowNode)previous, (FlowNode)activity));
            HumanTaskTest.runLayout(process);
            previous = activity;
        }
        EndEvent endEvent = HumanTaskTest.getEndEvent(process);
        HumanTaskTest.run((Command)new AddTransitionCommand((NodeContainer)process, (FlowNode)previous, (FlowNode)endEvent));
        HumanTaskTest.runLayout(process);
        HumanTaskTest.assertEquals((String)"Activities in Process.", (int)ACTIVITIES.length, (int)process.getActivities().toArray().length);
        HumanTaskTest.assertEquals((String)"Events in Process.", (int)2, (int)process.getEvents().toArray().length);
        HumanTaskTest.assertEquals((String)"Sequence Flows in Process.", (int)(ACTIVITIES.length + 1), (int)process.getSequenceFlows().toArray().length);
        HumanTaskTest.assertTrue((String)("Process Node should be dirty after changes: " + process), (boolean)HumanTaskTest.isResourceObjectDirty((ResourceObject)process));
    }

    private static WizardData createDefaultWizardData(URL url, String taskName) {
        WizardData data = new WizardData();
        data.setProjectName(taskName);
        data.setWorkflowName(taskName);
        data.setProjectDirectory(url);
        data.setNamespace("HumanTaskTestNameSpace");
        return data;
    }

    private static WFEditorData createDefaultWFEditorData(String name) {
        WFEditorData data = HumanTaskUtils.createDefaultWFEditorData((String)name);
        data.setPriority(3);
        return data;
    }

    private static class HumanTaskTemplate
    extends BaseProcessTest.ActivityTemplate {
        private String humanTaskName;
        private HumanTaskType humanTaskType;

        private HumanTaskTemplate(String humanTaskName, String taskName, BpmnType type, HumanTaskType humanTaskType) {
            super(taskName, type);
            this.humanTaskName = humanTaskName;
            this.humanTaskType = humanTaskType;
        }

        public static HumanTaskTemplate create(String humanTaskName, String taskName, BpmnType type, HumanTaskType humanTaskType) {
            return new HumanTaskTemplate(humanTaskName, taskName, type, humanTaskType);
        }

        public String getHumanTaskName() {
            return this.humanTaskName;
        }

        public HumanTaskType getHumanTaskType() {
            return this.humanTaskType;
        }
    }
}

