/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.tests;

import fuego.jdev.test.I18n;
import fuego.jdev.test.tests.BaseProjectTest;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeCatalogException;

public class CatalogTest
extends BaseProjectTest {
    private static final String MODULE_NAME = I18n.msg("MyModule");
    private static final String BPMOBJECT_NAME = I18n.msg("MyBpmObject");
    private static final String ATTRIBUTE_NAME = I18n.msg("MyStringAttribute");

    public void testNewBpmObject() throws TypeCatalogException, ProjectException {
        CatalogModule rootModule = this.getProject().getCatalogRoot();
        CatalogModule catalogModule = rootModule.newModule(MODULE_NAME);
        rootModule.addChild((ProjectObject)catalogModule);
        BpmObject bpmObject = catalogModule.newBpmObject(BPMOBJECT_NAME);
        catalogModule.addChild((ProjectObject)bpmObject);
        this.workbench().openEditorForObject(bpmObject);
        CatalogMember member = bpmObject.createAttribute(ATTRIBUTE_NAME, CatalogType.Default.getString());
        bpmObject.addChild((ProjectObject)member);
        CatalogTest.assertTrue((String)("BpmObject Node should be dirty after changes: " + bpmObject), (boolean)CatalogTest.isResourceObjectDirty((ResourceObject)bpmObject));
    }

    public void testSyncCatalog() {
        try {
            ComponentCatalog catalog = this.getProject().getComponentCatalog();
            catalog.sync();
        }
        catch (Throwable e) {
            CatalogTest.fail((String)e.getMessage());
        }
    }
}

