/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.tests;

import fuego.jdev.test.I18n;
import fuego.jdev.test.UiRunnable;
import fuego.jdev.test.tests.process.BaseProcessTest;
import java.util.ArrayList;
import junit.framework.Assert;
import oracle.bpm.command.Command;
import oracle.bpm.fusion.soa.rules.BusinessRuleUtils;
import oracle.bpm.fusion.soa.rules.ParametersEntry;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.design.AddActivityCommand;
import oracle.bpm.project.command.design.AddDataDeclarationCommand;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.command.design.ChangeActivityTypeCommand;
import oracle.bpm.project.command.design.SwitchLaneCommand;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.tip.tools.ide.rules.dictionarybuilder.RuleType;
import oracle.tip.tools.ide.rules.dictionarybuilder.WizardData;

public class BusinessRuleTest
extends BaseProcessTest {
    private static final String PROCESS_NAME = I18n.msg("BusinessRuleTestProcess");
    private static final String ROLE_NAME = I18n.msg("BusinessRuleRole");
    private static final BusinessRuleTaskTemplate BUSINESS_RULE = BusinessRuleTaskTemplate.create("BusinessRule", I18n.msg("BusinessRuleTask"), BpmnType.BUSINESS_RULE_TASK);
    private static final BusinessRuleTaskTemplate[] ACTIVITIES = new BusinessRuleTaskTemplate[]{BUSINESS_RULE};
    private static final String MODULE_NAME = I18n.msg("MyModule");
    private static final String IN_BPMOBJECT_NAME = I18n.msg("InBpmObject");
    private static final String OUT_BPMOBJECT_NAME = I18n.msg("OutBpmObject");

    public void testNewBusinessRules() throws Exception {
        final Project project = this.getProject();
        CatalogModule rootModule = this.getProject().getCatalogRoot();
        CatalogModule catalogModule = rootModule.newModule(MODULE_NAME);
        rootModule.addChild((ProjectObject)catalogModule);
        BpmObject inBpmObject = catalogModule.newBpmObject(IN_BPMOBJECT_NAME);
        CatalogMember inMember = inBpmObject.createAttribute("inString", CatalogType.Default.getString());
        inBpmObject.addChild((ProjectObject)inMember);
        catalogModule.addChild((ProjectObject)inBpmObject);
        BpmObject outBpmObject = catalogModule.newBpmObject(OUT_BPMOBJECT_NAME);
        CatalogMember outMember = outBpmObject.createAttribute("outString", CatalogType.Default.getString());
        outBpmObject.addChild((ProjectObject)outMember);
        catalogModule.addChild((ProjectObject)outBpmObject);
        Organization organization = this.getProject().getOrganization();
        Role role = organization.createRole(ROLE_NAME, ROLE_NAME);
        organization.addChild((ProjectObject)role);
        Process process = this.createProcess(PROCESS_NAME);
        this.workbench().openEditorForObject(process);
        final DataObject inDataObject = process.createDeclaration("inDataObject", (CatalogType)inBpmObject);
        BusinessRuleTest.run((Command)new AddDataDeclarationCommand((DataDeclarationContainer)process, (DataDeclaration)inDataObject));
        final DataObject outDataObject = process.createDeclaration("outDataObject", (CatalogType)outBpmObject);
        BusinessRuleTest.run((Command)new AddDataDeclarationCommand((DataDeclarationContainer)process, (DataDeclaration)outDataObject));
        BusinessRuleTest.run((Command)((Object)BaseProcessTest.RemoveStarEndSequenceFlowCommand.create(process)));
        BusinessRuleTest.run((Command)new SwitchLaneCommand(BusinessRuleTest.getStartEvent(process).getLane(), ROLE_NAME, -1));
        BusinessRuleTest.runLayout(process);
        final ArrayList businessRules = new ArrayList(ACTIVITIES.length);
        this.runInUi(new UiRunnable(){

            @Override
            public Object run() {
                try {
                    for (BusinessRuleTaskTemplate template : ACTIVITIES) {
                        WizardData data = BusinessRuleTest.createDefaultWizardData(project.getId(), template.getBusinessRuleName(), inDataObject, outDataObject);
                        BusinessRule businessRule = BusinessRuleUtils.createBusinessRule((Project)project, (WizardData)data);
                        Assert.assertNotNull((String)"Error creating Business Rule. Business Rule is null", (Object)businessRule);
                        businessRules.add(businessRule);
                    }
                }
                catch (ProjectException e) {
                    Assert.fail((String)e.getMessage());
                }
                return null;
            }
        });
        StartEvent previous = BusinessRuleTest.getStartEvent(process);
        int i = 0;
        for (BusinessRuleTaskTemplate template : ACTIVITIES) {
            Activity activity = process.createActivity();
            activity.setDefaultLabel(template.getTaskName());
            ChangeActivityTypeCommand.change((Activity)activity, (BpmnType)template.getType());
            BusinessRuleTask userTask = (BusinessRuleTask)activity.asAnyNode(BusinessRuleTask.class);
            userTask.setBusinessRule((BusinessRule)businessRules.get(i++));
            BusinessRuleTest.run((Command)new AddActivityCommand((FlowNode)userTask, new Point(10, 10)));
            BusinessRuleTest.run((Command)new AddTransitionCommand((NodeContainer)process, (FlowNode)previous, (FlowNode)activity));
            BusinessRuleTest.runLayout(process);
            previous = activity;
        }
        EndEvent endEvent = BusinessRuleTest.getEndEvent(process);
        BusinessRuleTest.run((Command)new AddTransitionCommand((NodeContainer)process, (FlowNode)previous, (FlowNode)endEvent));
        BusinessRuleTest.runLayout(process);
        BusinessRuleTest.assertEquals((String)"Activities in Process.", (int)ACTIVITIES.length, (int)process.getActivities().toArray().length);
        BusinessRuleTest.assertEquals((String)"Events in Process.", (int)2, (int)process.getEvents().toArray().length);
        BusinessRuleTest.assertEquals((String)"Sequence Flows in Process.", (int)(ACTIVITIES.length + 1), (int)process.getSequenceFlows().toArray().length);
        BusinessRuleTest.assertTrue((String)("Process Node should be dirty after changes: " + process), (boolean)BusinessRuleTest.isResourceObjectDirty((ResourceObject)process));
    }

    private static WizardData createDefaultWizardData(String projectName, String ruleName, DataObject in, DataObject out) {
        WizardData data = new WizardData();
        data.setName(ruleName);
        ArrayList<ParametersEntry> entries = new ArrayList<ParametersEntry>();
        entries.add(ParametersEntry.create((boolean)true, (String)"InParam", (DataDeclaration)in));
        entries.add(ParametersEntry.create((boolean)false, (String)"OutParam", (DataDeclaration)out));
        BusinessRuleUtils.applyToWizardData(entries, (WizardData)data);
        data.setPackageName(projectName + "_Package");
        data.setServiceName(ruleName + "_DecisionService");
        data.setType(RuleType.RULES);
        return data;
    }

    private static class BusinessRuleTaskTemplate
    extends BaseProcessTest.ActivityTemplate {
        private String businessRuleName;

        private BusinessRuleTaskTemplate(String businessRuleName, String taskName, BpmnType type) {
            super(taskName, type);
            this.businessRuleName = businessRuleName;
        }

        public static BusinessRuleTaskTemplate create(String humanTaskName, String taskName, BpmnType type) {
            return new BusinessRuleTaskTemplate(humanTaskName, taskName, type);
        }

        public String getBusinessRuleName() {
            return this.businessRuleName;
        }
    }
}

