/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test;

import fuego.internal.test.CoreTestUtils;
import fuego.internal.test.FuegoSuiteInfo;
import fuego.internal.test.FuegoTestInfo;
import fuego.internal.test.FuegoTestsConstants;
import fuego.internal.test.SkippedTestException;
import fuego.jdev.test.actions.JdevTestController;
import fuego.jdev.test.tests.DefaultTestSuite;
import fuego.jdev.test.toolkit.WorkbenchToolkit;
import fuego.jdev.test.views.JdevTestDockableFactory;
import java.io.File;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.textui.TestRunner;
import oracle.bpm.fusion.studio.StudioExtensionAddin;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.util.ExceptionFormatter;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockableFactory;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;

public class TestStarter
implements Addin {
    public static File BASE_WORKSPACE_DIR = null;
    public static final String WORKSPACE_NAME = "Workspace1.jws";

    public static boolean mustRunTests() {
        return Boolean.getBoolean("fuego.jdev.test.run") && TestStarter.existeWorkspaceDir();
    }

    public static boolean isRunningFromUiView() {
        return !TestStarter.mustRunTests();
    }

    public static void runTests() {
        try {
            WorkbenchToolkit.getInstance().createWorkspace(WORKSPACE_NAME);
            DefaultTestSuite testSuite = new DefaultTestSuite();
            if (!"".equals(System.getProperty("fuego.version", ""))) {
                FuegoSuiteInfo info = FuegoSuiteInfo.create((String)TestStarter.getVersion(), (String)"studio", (String)"StudioJDevSuite", (String)TestStarter.getDate(), (String)TestStarter.getConfiguration());
                info.buildNumber = Integer.valueOf(System.getProperty("fuego.build.number", "0"));
                System.out.println("buildNumber = " + info.buildNumber);
                TestResult testResult = new TestResult();
                Formatter formatter = TestStarter.createFormatter(info);
                testResult.addListener((TestListener)formatter);
                testSuite.run(testResult);
                formatter.stopSuiteInfo();
            } else {
                TestRunner.run((Test)testSuite);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        TestStarter.shutdown();
    }

    public void initialize() {
        if (TestStarter.mustRunTests()) {
            Ide.addIdeListener((IdeListener)new IdeListener(){

                public void addinsLoaded(IdeEvent event) {
                }

                public void mainWindowOpened(IdeEvent event) {
                    new Thread(){

                        @Override
                        public void run() {
                            TestStarter.waitForStudioStart();
                            TestStarter.runTests();
                        }
                    }.start();
                }

                public void mainWindowClosing(IdeEvent event) {
                }
            });
        } else if (Boolean.getBoolean("fuego.studio.debug=true")) {
            TestStarter.initDefaultWorspaceDir();
            TestStarter.initJdevTestUI();
        }
    }

    private static void initJdevTestUI() {
        JdevTestController.createActions();
        DockStation.getDockStation().registerDockableFactory("BpmJdevTestWindows", (DockableFactory)new JdevTestDockableFactory());
    }

    private static void initDefaultWorspaceDir() {
        URL workDirURL;
        Workspaces workspaces = Ide.getWorkspaces();
        URL uRL = workDirURL = workspaces != null ? workspaces.getWorkDirectory() : null;
        if (workDirURL == null) {
            String dir = Ide.getWorkDirectory();
            workDirURL = URLFactory.newDirURL((String)dir);
        }
        try {
            BASE_WORKSPACE_DIR = new File(workDirURL.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private static boolean existeWorkspaceDir() {
        File file;
        boolean isValid = false;
        String value = System.getProperty("fuego.jdev.test.workspace");
        if (value != null && ((file = new File(value)).exists() || file.mkdirs())) {
            isValid = true;
            BASE_WORKSPACE_DIR = file;
        }
        return isValid;
    }

    private static boolean mustCloseIde() {
        return Boolean.getBoolean("fuego.jdev.test.closeide");
    }

    private static Formatter createFormatter(FuegoSuiteInfo info) {
        Formatter formatter = new Formatter();
        formatter.setSuiteInfo(info);
        formatter.startSuiteInfo();
        return formatter;
    }

    private static String getConfiguration() {
        return System.getProperty("test.machine", "localhost") + "/jdev//";
    }

    private static String getDate() {
        return System.getProperty("fuego.run.date", new Timestamp(System.currentTimeMillis()).toString());
    }

    private static String getVersion() {
        return System.getProperty("fuego.version", "JDEV-STUDIO");
    }

    private static void shutdown() {
        UiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (TestStarter.mustCloseIde()) {
                    try {
                        WorkbenchToolkit.getInstance().saveAll();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Ide.quit();
                }
            }
        });
    }

    private static void waitForStudioStart() {
        AddinManager addinManager = AddinManager.getAddinManager();
        while (addinManager.getAddin(StudioExtensionAddin.class) == null) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Formatter
    implements FuegoTestsConstants,
    TestListener {
        protected FuegoSuiteInfo currentSuiteInfo;
        protected Test currentTest;
        protected String systemOut;
        private Throwable failureThrowable;
        private long lastTestStart = 0L;
        private int status = 1;
        private String systemErr;
        private String testName;

        public void setOutput(OutputStream out) {
        }

        public void setSystemError(String out) {
            this.systemErr = out;
        }

        public void addError(Test test, Throwable t) {
            this.status = -1;
            this.failureThrowable = t;
        }

        public void addFailure(Test test, AssertionFailedError t) {
            this.status = 0;
            this.failureThrowable = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endTest(Test test) {
            try {
                FuegoTestInfo testInfo;
                assert (test == this.currentTest) : "current test differs from end (" + this.currentTest + " vs " + test + ")";
                double duration = System.currentTimeMillis() - this.lastTestStart;
                if (this.failureThrowable instanceof AssertionFailedError) {
                    int i;
                    String message = this.failureThrowable.getMessage();
                    StackTraceElement[] stackTrace = this.failureThrowable.getStackTrace();
                    StringBuilder failStack = new StringBuilder();
                    for (i = 0; i < stackTrace.length && "fail".equals(stackTrace[i].getMethodName()); ++i) {
                    }
                    while (i < stackTrace.length && !stackTrace[i].toString().startsWith("java.lang.reflect.Method.invoke")) {
                        failStack.append("\tat ");
                        failStack.append(stackTrace[i].toString());
                        failStack.append("\n");
                        ++i;
                    }
                    testInfo = FuegoTestInfo.createTest((FuegoSuiteInfo)this.currentSuiteInfo, (String)this.testName, (double)duration, (int)this.status, (String)(message + "\n\nFail Stack:\n" + failStack.toString()));
                } else if (this.failureThrowable instanceof SkippedTestException) {
                    String jiraId = ((SkippedTestException)this.failureThrowable).getJiraId();
                    this.status = -2;
                    testInfo = FuegoTestInfo.createTest((FuegoSuiteInfo)this.currentSuiteInfo, (String)this.testName, (double)duration, (int)this.status, null, (String)jiraId);
                } else {
                    String cause = this.failureThrowable == null ? null : ExceptionFormatter.fullTechLevel(this.failureThrowable);
                    testInfo = FuegoTestInfo.createTest((FuegoSuiteInfo)this.currentSuiteInfo, (String)this.testName, (double)duration, (int)this.status, (String)cause);
                }
                this.submitTest(testInfo);
            }
            finally {
                this.currentTest = null;
            }
        }

        public void startTest(Test test) {
            assert (this.currentTest == null) : "already a current test " + this.currentTest;
            this.currentTest = test;
            this.lastTestStart = System.currentTimeMillis();
            this.testName = test instanceof TestCase ? ((TestCase)test).getName() : test.toString();
            this.status = 1;
            this.failureThrowable = null;
        }

        public void setSuiteInfo(FuegoSuiteInfo info) {
            this.currentSuiteInfo = info;
        }

        public void startSuiteInfo() {
            CoreTestUtils.startSuite((FuegoSuiteInfo)this.currentSuiteInfo);
        }

        public void stopSuiteInfo() {
            CoreTestUtils.submitSuite((FuegoSuiteInfo)this.currentSuiteInfo, (String)this.getSystemOutAndErr());
        }

        protected void submitTest(FuegoTestInfo testInfo) {
            CoreTestUtils.submitTest((FuegoTestInfo)testInfo);
        }

        protected String getSystemOutAndErr() {
            return "System Output: \n" + this.systemOut + "\nSystem Error: \n" + this.systemErr;
        }
    }
}

