/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test;

import fuego.jdev.test.TestStarter;
import fuego.jdev.test.UiRunnable;
import fuego.jdev.test.toolkit.WorkbenchToolkit;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.TestCase;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

public abstract class BaseTestCase
extends TestCase {
    private static final int DEFAULT_MAX_ATTEMPT = 50;
    private static final int DEFAULT_SLEEP_TIME = 200;

    public BaseTestCase() {
    }

    public BaseTestCase(String testName) {
        super(testName);
    }

    public static Project createProject(String name) throws ProjectException {
        String projectName = TestStarter.isRunningFromUiView() ? BaseTestCase.getUniqueName(name) : name;
        return BaseTestCase.getProjectRepository().create(projectName);
    }

    public String toString() {
        return this.getName();
    }

    protected static <T> T adaptTo(Object object, Class<T> cl) {
        return Platform.getAdapterService().adaptTo(object, cl);
    }

    protected static String Q(Object o) {
        return "'" + o.toString() + "'";
    }

    protected static void deleteProject(@NotNull Project project) throws ProjectException {
        BaseTestCase.getProjectRepository().delete(project);
    }

    protected static void waitUntil(Expression condition) {
        BaseTestCase.waitUntil(condition, "Condition not reached");
    }

    protected static void waitUntil(Expression condition, String errorMessage) {
        BaseTestCase.waitUntil(condition, 200, 50, errorMessage);
    }

    protected static void waitUntil(Expression condition, int sleepTime, int maxAttempts, String errorMessage) {
        int count;
        for (count = maxAttempts; !((Boolean)condition.evaluate()).booleanValue() && count > 0; --count) {
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (count == 0) {
            BaseTestCase.fail((String)errorMessage);
        }
    }

    protected static FusionProjectRepository getProjectRepository() {
        RepositoryService service = RepositoryService.getInstance();
        return (FusionProjectRepository)service.getActiveRepository();
    }

    protected WorkbenchToolkit workbench() {
        return WorkbenchToolkit.getInstance();
    }

    protected Object runInUi(UiRunnable runnable) {
        return this.workbench().runInUi(runnable);
    }

    protected Object waitUntilNotNull(Expression expression) {
        return this.waitUntilNotNull(expression, "Condition not reached");
    }

    protected Object waitUntilNotNull(Expression expression, String errorMessage) {
        return this.waitUntilNotNull(expression, 200, 50, errorMessage);
    }

    protected Object waitUntilNotNull(Expression expression, int sleepTime, int maxAttempts, String errorMessage) {
        int count;
        Object result = null;
        for (count = maxAttempts; count > 0 && (result = expression.evaluate()) == null; --count) {
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (count == 0) {
            BaseTestCase.fail((String)errorMessage);
        }
        return result;
    }

    private static String getUniqueName(String name) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String dateTime = dateFormat.format(new Date());
        return name + "_" + dateTime;
    }

    public static interface Expression {
        public Object evaluate();
    }
}

