/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.util;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import oracle.rc.asadapter.websphere.connection.Websphere7Descriptor;

public class WebsphereSOAServer {
    private String _cell;
    private String _cluster;
    private URL _httpsUrl;
    private URL _httpUrl;
    private String _jndiHost;
    private Integer _jndiPort;
    private String _name;
    private String _node;
    private String _state;

    public WebsphereSOAServer(MBeanServerConnection mbsconn, ObjectName serverObjectName, Websphere7Descriptor desc) {
        try {
            String orbQueryStr;
            ObjectName orbQuery;
            Set<ObjectName> orbResult;
            this._name = (String)mbsconn.getAttribute(serverObjectName, "name");
            this._node = (String)mbsconn.getAttribute(serverObjectName, "nodeName");
            this._cell = (String)mbsconn.getAttribute(serverObjectName, "cellName");
            this._state = (String)mbsconn.getAttribute(serverObjectName, "state");
            String fabricQueryStr = String.format("oracle.soa.config:type=FabricRuntime,cell=%s,node=%s,process=%s,*", this._cell, this._node, this._name);
            ObjectName fabricQuery = new ObjectName(fabricQueryStr);
            Set<ObjectName> fabricResult = mbsconn.queryNames(fabricQuery, null);
            Iterator<ObjectName> iter = fabricResult.iterator();
            if (iter.hasNext()) {
                ObjectName fabric = iter.next();
                String url = (String)mbsconn.getAttribute(fabric, "EffectiveHttpServerURL");
                this._httpUrl = new URL(url);
                url = (String)mbsconn.getAttribute(fabric, "EffectiveHttpsServerURL");
                this._httpsUrl = new URL(url);
            }
            if ((iter = (orbResult = mbsconn.queryNames(orbQuery = new ObjectName(orbQueryStr = String.format("WebSphere:type=ORB,cell=%s,node=%s,process=%s,*", this._cell, this._node, this._name)), null)).iterator()).hasNext()) {
                ObjectName orb = iter.next();
                Integer port = (Integer)mbsconn.getAttribute(orb, "bootstrapPort");
                String hostname = this._httpUrl.getHost();
                if (hostname == null) {
                    hostname = desc.getHostname();
                }
                this._jndiHost = hostname;
                this._jndiPort = port;
            }
            this.initCluster(mbsconn);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String get_jndiHost() {
        return this._jndiHost;
    }

    public Integer get_jndiPort() {
        return this._jndiPort;
    }

    public boolean isRunning() {
        return this._state.equals("STARTED");
    }

    public String get_cell() {
        return this._cell;
    }

    public String get_cluster() {
        return this._cluster;
    }

    public URL get_httpsUrl() {
        return this._httpsUrl;
    }

    public URL get_httpUrl() {
        return this._httpUrl;
    }

    public String get_name() {
        return this._name;
    }

    public String get_node() {
        return this._node;
    }

    public String get_state() {
        return this._state;
    }

    public boolean isSSLEnabled() {
        return this._httpsUrl != null;
    }

    private void initCluster(MBeanServerConnection mbsc) throws Exception {
        Set<ObjectName> clusterMgrResult = mbsc.queryNames(new ObjectName("WebSphere:type=ClusterMgr,*"), null);
        Iterator<ObjectName> iter = clusterMgrResult.iterator();
        if (iter.hasNext()) {
            ObjectName clusterMgr = iter.next();
            Object clusterData = mbsc.invoke(clusterMgr, "retrieveClusterByMember", new Object[]{this._name, this._node}, new String[]{String.class.getName(), String.class.getName()});
            if (clusterData != null) {
                for (Field f : clusterData.getClass().getFields()) {
                    if (!f.getName().equals("clusterName")) continue;
                    this._cluster = (String)f.get(clusterData);
                    break;
                }
            }
        }
    }
}

