/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.util;

import java.io.IOException;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import oracle.bpm.pml.service.util.WebsphereSOAServer;

public class ServerInfo {
    private String host;
    private String name;
    private int port;
    private boolean sslEnabled;

    public ServerInfo(String name, String host, int port, boolean sslEnabled) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.sslEnabled = sslEnabled;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public static class ServerInfoFactory {
        public static ServerInfo createFrom(WebsphereSOAServer wasServer) {
            ServerInfo result = null;
            String name = wasServer.get_name();
            String state = wasServer.get_state();
            if ("STARTED".equals(state)) {
                Integer port;
                String host;
                Boolean sslListenPortEnabled = wasServer.isSSLEnabled();
                if (sslListenPortEnabled.booleanValue()) {
                    host = wasServer.get_jndiHost();
                    port = wasServer.get_jndiPort();
                } else {
                    host = wasServer.get_jndiHost();
                    port = wasServer.get_jndiPort();
                }
                int idx = host.indexOf(47);
                if (idx != -1) {
                    host = host.substring(idx + 1).trim();
                }
                result = new ServerInfo(name, host, port, sslListenPortEnabled);
            }
            return result;
        }

        public static ServerInfo createFromWlsConnection(MBeanServerConnection connection, List<String> managedNodes, ObjectName objectName) throws InstanceNotFoundException, IOException, ReflectionException, AttributeNotFoundException, MBeanException {
            ServerInfo result = null;
            String name = (String)connection.getAttribute(objectName, "Name");
            String state = (String)connection.getAttribute(objectName, "State");
            if ("RUNNING".equals(state) && managedNodes.contains(name)) {
                Integer port;
                String host;
                Boolean sslListenPortEnabled = (Boolean)connection.getAttribute(objectName, "SSLListenPortEnabled");
                if (sslListenPortEnabled.booleanValue()) {
                    host = (String)connection.getAttribute(objectName, "SSLListenAddress");
                    port = (Integer)connection.getAttribute(objectName, "SSLListenPort");
                } else {
                    host = (String)connection.getAttribute(objectName, "ListenAddress");
                    port = (Integer)connection.getAttribute(objectName, "ListenPort");
                }
                int idx = host.indexOf(47);
                if (idx != -1) {
                    host = host.substring(idx + 1).trim();
                }
                result = new ServerInfo(name, host, port, sslListenPortEnabled);
            }
            return result;
        }
    }
}

