/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.pml.service.util.ServerInfo;
import oracle.bpm.pml.service.util.WebsphereSOAServer;
import oracle.bpm.pml.service.util.lookup.WasHelper;
import oracle.jdeveloper.rcasadapter.AppServerProvider;
import oracle.rc.asadapter.connection.ConnectionDescriptor;
import oracle.rc.asadapter.weblogic.connection.Weblogic10Descriptor;
import oracle.rc.asadapter.websphere.connection.Websphere7Descriptor;
import oracle.tip.tools.ide.fabric.asbrowser.websphere.WebsphereRMIClientFactory;
import org.jetbrains.annotations.NotNull;

public final class JmxServerHelper {
    private AppServerProvider appServerProvider;
    private MBeanServerConnection connection;
    private JMXConnector connector;

    public void connect(AppServerProvider appServerProvider, String hostname, String portString, String username, String password, boolean userssl) throws IOException, MalformedObjectNameException, MetadataException {
        this.appServerProvider = appServerProvider;
        if (this.isWeblogic10(appServerProvider)) {
            this.connectWLS(hostname, portString, username, password);
        } else if (this.isWebsphere7(appServerProvider)) {
            this.connectWAS();
        }
    }

    public void close() throws IOException {
        if (this.connector != null) {
            this.connector.close();
        }
    }

    public List<ServerInfo> getRunningManagedNodes() throws Exception {
        if (this.isWeblogic10(this.appServerProvider)) {
            return this.getRunningManagedNodesWLS();
        }
        if (this.isWebsphere7(this.appServerProvider)) {
            return this.getRunningManagedNodesWAS();
        }
        return Collections.emptyList();
    }

    private void connectWAS() throws IOException, MetadataException {
        Websphere7Descriptor desc = WasHelper.buildWebsphere7Descriptor(this.appServerProvider);
        this.connector = WebsphereRMIClientFactory.createJMXConnector((ConnectionDescriptor)desc, null);
        this.connector.connect();
        this.connection = this.connector.getMBeanServerConnection();
    }

    private void connectWLS(String hostname, String portString, String username, String password) throws MalformedObjectNameException, IOException {
        String protocol = "t3";
        int port = Integer.valueOf(portString);
        String jndiroot = "/jndi/";
        String mserver = "weblogic.management.mbeanservers.domainruntime";
        JMXServiceURL serviceURL = new JMXServiceURL("t3", hostname, port, "/jndi/weblogic.management.mbeanservers.domainruntime");
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.security.principal", username);
        props.put("java.naming.security.credentials", password);
        props.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        this.connector = JMXConnectorFactory.connect(serviceURL, props);
        this.connection = this.connector.getMBeanServerConnection();
    }

    private boolean isWebsphere7(AppServerProvider appServerProvider) {
        return ConnectionDescriptor.isMatchingType((oracle.rc.asadapter.connection.AppServerProvider)((oracle.rc.asadapter.connection.AppServerProvider)appServerProvider), Websphere7Descriptor.class);
    }

    private boolean isWeblogic10(AppServerProvider appServerProvider) {
        return ConnectionDescriptor.isMatchingType((oracle.rc.asadapter.connection.AppServerProvider)((oracle.rc.asadapter.connection.AppServerProvider)appServerProvider), Weblogic10Descriptor.class);
    }

    private List<ServerInfo> getRunningManagedNodesWLS() throws Exception {
        ObjectName queryNameStr = new ObjectName("*:EMTargetType=oracle_soainfra,*");
        Set<ObjectName> objectNames = this.connection.queryNames(queryNameStr, null);
        return this.createWLSServerInfoList(objectNames);
    }

    private List<ServerInfo> getRunningManagedNodesWAS() throws Exception {
        ObjectName soaInfraQuery = new ObjectName("EMDomain:EMTargetType=oracle_soainfra,*");
        Set<ObjectName> soaInfraResult = this.connection.queryNames(soaInfraQuery, null);
        ArrayList<ServerInfo> serverInfos = new ArrayList<ServerInfo>();
        ArrayList<WebsphereSOAServer> wasServers = new ArrayList<WebsphereSOAServer>();
        Websphere7Descriptor desc = WasHelper.buildWebsphere7Descriptor(this.appServerProvider);
        for (ObjectName soaInfra : soaInfraResult) {
            ObjectName server = (ObjectName)this.connection.getAttribute(soaInfra, "Parent");
            wasServers.add(new WebsphereSOAServer(this.connection, server, desc));
        }
        for (WebsphereSOAServer wasServer : wasServers) {
            ServerInfo serverInfo = ServerInfo.ServerInfoFactory.createFrom(wasServer);
            if (serverInfo == null) continue;
            serverInfos.add(serverInfo);
        }
        return serverInfos;
    }

    private List<ServerInfo> createWLSServerInfoList(@NotNull Set<ObjectName> objectNames) throws Exception {
        ObjectName[] serverRT;
        if (objectNames == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/JmxServerHelper.createWLSServerInfoList must not be null");
        }
        ObjectName service = new ObjectName("com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean");
        ArrayList<String> managedNodes = new ArrayList<String>();
        ArrayList<ServerInfo> serverInfos = new ArrayList<ServerInfo>();
        for (ObjectName objectName : objectNames) {
            String canonicalName = objectName.getCanonicalName();
            int init = canonicalName.indexOf("Location=") + 9;
            String name = canonicalName.substring(init);
            name = name.substring(0, name.indexOf(","));
            managedNodes.add(name);
        }
        for (ObjectName objectName : serverRT = (ObjectName[])this.connection.getAttribute(service, "ServerRuntimes")) {
            ServerInfo serverInfo = ServerInfo.ServerInfoFactory.createFromWlsConnection(this.connection, managedNodes, objectName);
            if (serverInfo == null) continue;
            serverInfos.add(serverInfo);
        }
        return serverInfos;
    }
}

