/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.security;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.pml.security.exception.PmlSecurityException;
import oracle.bpm.pml.security.model.BasicSecuredProject;
import oracle.bpm.pml.security.model.PmlPrincipal;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.security.model.SecuredProject;
import oracle.bpm.pml.security.service.PmlSecurityService;
import oracle.bpm.services.pml.ISecurityService;
import org.jetbrains.annotations.NotNull;

public class SecurityRemoteService
implements PmlSecurityService {
    private IBPMContext context;
    private ISecurityService service;

    public SecurityRemoteService(@NotNull IBPMContext bpmContext, @NotNull ISecurityService remoteService) {
        if (bpmContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.<init> must not be null");
        }
        if (remoteService == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.<init> must not be null");
        }
        this.context = bpmContext;
        this.service = remoteService;
    }

    public String getUserName() throws PmlSecurityException {
        return this.context.getUser();
    }

    public PmlPrincipal getPrincipal() throws PmlSecurityException {
        return this.service.getPrincipal(this.context);
    }

    public void publishProject(@NotNull String projectId) throws PmlSecurityException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.publishProject must not be null");
        }
        this.service.publishProject(this.context, projectId);
    }

    public void publishProject(@NotNull String projectId, @NotNull ProjectRole role) throws PmlSecurityException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.publishProject must not be null");
        }
        if (role == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.publishProject must not be null");
        }
        this.service.publishProject(this.context, projectId, role);
    }

    public void deleteProject(@NotNull String projectId) throws PmlSecurityException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.deleteProject must not be null");
        }
        this.service.deleteProject(this.context, projectId);
    }

    public Map<String, SecuredProject> getSecuredProjects() throws PmlSecurityException {
        return this.service.getSecuredProjects(this.context);
    }

    public Map<String, BasicSecuredProject> getProjects() throws PmlSecurityException {
        return this.service.getProjects(this.context);
    }

    public void assertPrivilege(@NotNull String projectId, @NotNull ProjectRole requiredRole) throws PmlSecurityException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.assertPrivilege must not be null");
        }
        if (requiredRole == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.assertPrivilege must not be null");
        }
        this.service.assertPrivilege(this.context, projectId, requiredRole);
    }

    public void checkMigration() throws PmlSecurityException {
        this.service.checkMigration(this.context);
    }

    public String getApplicationName() throws PmlSecurityException {
        return this.service.getApplicationName(this.context);
    }

    public PmlPrincipal getPmlPrincipal(@NotNull String userName) throws PmlSecurityException {
        if (userName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.getPmlPrincipal must not be null");
        }
        return this.service.getPmlPrincipal(this.context, userName);
    }

    public void grantProjectRole(@NotNull ProjectRole role, @NotNull String projectName, @NotNull Set<PmlPrincipal> principals) throws PmlSecurityException {
        if (role == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.grantProjectRole must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.grantProjectRole must not be null");
        }
        if (principals == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.grantProjectRole must not be null");
        }
        this.service.grantProjectRole(this.context, role, projectName, principals);
    }

    public void removeProject(@NotNull String projectName) throws PmlSecurityException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.removeProject must not be null");
        }
        this.service.removeProject(this.context, projectName);
    }

    public void revokeProject(@NotNull String projectName) throws PmlSecurityException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.revokeProject must not be null");
        }
        this.service.revokeProject(this.context, projectName);
    }

    public void revokeProjectRoles(@NotNull EnumSet<ProjectRole> projectRoles, @NotNull String projectName) throws PmlSecurityException {
        if (projectRoles == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.revokeProjectRoles must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.revokeProjectRoles must not be null");
        }
        this.service.revokeProjectRoles(this.context, projectRoles, projectName);
    }

    public Map<String, SecuredProject> getProjectsFor(@NotNull PmlPrincipal principal) throws PmlSecurityException {
        if (principal == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.getProjectsFor must not be null");
        }
        return this.service.getProjectsFor(this.context, principal);
    }

    public boolean isShared(@NotNull String projectId) throws PmlSecurityException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.isShared must not be null");
        }
        return this.service.isShared(this.context, projectId);
    }

    public void assertPrivilege(@NotNull PmlPrincipal principal, @NotNull String projectId, @NotNull ProjectRole requiredRole) throws PmlSecurityException {
        if (principal == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.assertPrivilege must not be null");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.assertPrivilege must not be null");
        }
        if (requiredRole == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.assertPrivilege must not be null");
        }
        this.service.assertPrivilege(this.context, principal, projectId, requiredRole);
    }

    public ProjectRole getRoleFor(@NotNull String project, @NotNull PmlPrincipal principal) throws PmlSecurityException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.getRoleFor must not be null");
        }
        if (principal == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.getRoleFor must not be null");
        }
        return this.service.getRoleFor(this.context, project, principal);
    }

    public Map<ProjectRole, Set<String>> getProjectGrants(@NotNull String project) throws PmlSecurityException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityRemoteService.getProjectGrants must not be null");
        }
        return this.service.getProjectGrants(this.context, project);
    }

    public boolean isFirstAccess() throws PmlSecurityException {
        return this.service.isFirstAccess(this.context);
    }
}

