/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.security;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.Predicate;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.lang.Cast;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdDomain;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.entity.DeployedProject;
import oracle.bpm.metadata.entity.DraftProject;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.SnapshotProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.MetadataExceptionFactory;
import oracle.bpm.metadata.exception.ProjectNotFoundException;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.bpm.metadata.update.UpdateResult;
import oracle.bpm.pml.security.exception.PmlSecurityException;
import oracle.bpm.pml.security.exception.PmlSecurityExceptionFactory;
import oracle.bpm.pml.security.exception.PmlSecurityObjectNotFoundException;
import oracle.bpm.pml.security.exception.PmlSecurityPermissionDeniedException;
import oracle.bpm.pml.security.impl.SecuredProjectImpl;
import oracle.bpm.pml.security.model.BasicSecuredProject;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.security.service.PmlSecurityService;
import oracle.bpm.pml.service.util.MdProjectUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecurityMdDomainDecorator
implements MdDomain {
    private MdDomain domain;
    private PmlSecurityService securityService;
    private static final Set<ProjectType> SECURED_PROJECT_TYPES = new HashSet<ProjectType>();

    public SecurityMdDomainDecorator(@NotNull MdDomain mdDomain, @NotNull PmlSecurityService service) throws PmlSecurityException {
        if (mdDomain == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.<init> must not be null");
        }
        if (service == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.<init> must not be null");
        }
        this.domain = mdDomain;
        this.securityService = service;
        this.domain.setIsAdmin(this.securityService.getPrincipal().isGlobalOwner());
    }

    @Override
    public <T extends MdProject<?>> MdTree browseFolders(@NotNull Class<T> mdType, @Nullable Predicate<String> predicate) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.browseFolders must not be null");
        }
        return this.domain.browseFolders(mdType, predicate);
    }

    @Override
    public <T extends MdProject<?>> LocalRef<T> loadProject(@NotNull Class<T> clazz, @NotNull String location, boolean reload) throws MetadataException {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.loadProject must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.loadProject must not be null");
        }
        BasicSecuredProject securedProject = null;
        this.assertProjectPrivilege(clazz, ProjectFolder.create(location), ProjectRole.VIEWER);
        if (this.isSecuredProjectType(clazz)) {
            String mdProjectFullId = MdProjectUtil.createMdProjectFullId(MetadataArtifactHelper.getProjectType(clazz), location);
            securedProject = (BasicSecuredProject)this.securityService.getProjects().get(mdProjectFullId);
        }
        LocalRef<T> tLocalRef = this.domain.loadProject(clazz, location, reload);
        if (securedProject != null) {
            MdProject t = (MdProject)tLocalRef.get();
            t.setSecuredProject(securedProject);
        }
        return tLocalRef;
    }

    @Override
    public <T extends MdProject<?>> boolean existsProject(@NotNull Class<T> clazz, @NotNull ProjectFolder location) throws MetadataException {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.existsProject must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.existsProject must not be null");
        }
        boolean result = true;
        try {
            this.assertProjectPrivilege(clazz, location, ProjectRole.VIEWER);
        }
        catch (PmlSecurityPermissionDeniedException e) {
            result = false;
        }
        catch (ProjectNotFoundException e) {
            result = false;
        }
        return result && this.domain.existsProject(clazz, location);
    }

    @Override
    public LocalRef<DraftProject> loadDraftProject(@NotNull String location, @NotNull String username) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.loadDraftProject must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.loadDraftProject must not be null");
        }
        this.assertProjectPrivilege(PublicShareProject.class, ProjectFolder.create(location), ProjectRole.EDITOR);
        return this.domain.loadDraftProject(location, this.securityService.getUserName());
    }

    @Override
    public <T extends MdProject<?>, K extends ProjectArtifact<?>> MdTree browseProject(final @NotNull Class<T> type, final @Nullable Predicate<T> predicate, @Nullable LocalRef<K> parent) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.browseProject must not be null");
        }
        final ProjectType projectType = MetadataArtifactHelper.getProjectType(type);
        final Map projects = this.isSecuredProjectType(type) ? this.securityService.getProjects() : null;
        Predicate filteredPredicate = new Predicate<T>(){

            public boolean check(@Nullable T project) {
                String mdProjectFullId;
                boolean result = true;
                BasicSecuredProject securedProject = null;
                if (projects != null && project != null && (result = projects.containsKey(mdProjectFullId = MdProjectUtil.createMdProjectFullId(projectType, project.getId())))) {
                    securedProject = (BasicSecuredProject)projects.get(mdProjectFullId);
                }
                if (result) {
                    if (securedProject != null) {
                        project.setSecuredProject(securedProject);
                    }
                    result = predicate == null || predicate.check(project);
                } else if (TemplateProject.class.equals((Object)type)) {
                    try {
                        mdProjectFullId = MdProjectUtil.createMdProjectFullId(ProjectType.TEMPLATE, project);
                        SecurityMdDomainDecorator.this.securityService.publishProject(mdProjectFullId, ProjectRole.EDITOR);
                        project.setSecuredProject((BasicSecuredProject)new SecuredProjectImpl(mdProjectFullId, ProjectRole.EDITOR, true));
                        result = predicate == null || predicate.check(project);
                    }
                    catch (PmlSecurityException e) {
                        e.printStackTrace();
                    }
                }
                return result;
            }
        };
        return this.domain.browseProject(type, filteredPredicate, parent);
    }

    @Override
    public TemplateProject createTemplateProject(@NotNull ProjectFolder location, @NotNull TemplateProject project, @NotNull String username, boolean overwrite, boolean checkVersion) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.createTemplateProject must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.createTemplateProject must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.createTemplateProject must not be null");
        }
        ProjectFolder projectFolder = ProjectFolder.create(location, project.getName());
        boolean newProject = false;
        try {
            this.assertProjectPrivilege(TemplateProject.class, projectFolder, ProjectRole.EDITOR);
        }
        catch (ProjectNotFoundException e) {
            newProject = true;
        }
        TemplateProject templateProject = this.domain.createTemplateProject(location, project, username, overwrite, checkVersion);
        if (newProject) {
            this.securityService.publishProject(MdProjectUtil.createMdProjectFullId(ProjectType.TEMPLATE, templateProject), ProjectRole.EDITOR);
        }
        return templateProject;
    }

    @Override
    public void prepareProjectToDeploy(@NotNull PublicShareProject publicShare, @NotNull String workflowTicket) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.prepareProjectToDeploy must not be null");
        }
        if (workflowTicket == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.prepareProjectToDeploy must not be null");
        }
        this.assertProjectPrivilege(PublicShareProject.class, publicShare.getFolder().get(), ProjectRole.OWNER);
        this.domain.prepareProjectToDeploy(publicShare, workflowTicket);
    }

    @Override
    public void updatePublicShare(@NotNull PublicShareProject publicShare) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.updatePublicShare must not be null");
        }
        this.assertProjectPrivilege(PublicShareProject.class, publicShare.getFolder().get(), ProjectRole.EDITOR);
        this.domain.updatePublicShare(publicShare);
    }

    @Override
    public void updateDraft(@NotNull DraftProject draftProject) throws MetadataException {
        if (draftProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.updateDraft must not be null");
        }
        this.domain.updateDraft(draftProject);
    }

    @Override
    public PublicShareProject createPublicShare(@NotNull ProjectFolder location, @NotNull PublicShareProject publicShareProject, @NotNull TemplateProject templateProject, @NotNull String userName, boolean checkVersion, boolean keepLock) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.createPublicShare must not be null");
        }
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.createPublicShare must not be null");
        }
        if (templateProject == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.createPublicShare must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.createPublicShare must not be null");
        }
        ProjectFolder projectFolder = ProjectFolder.create(location, publicShareProject.getName());
        boolean newProject = false;
        try {
            this.assertProjectPrivilege(PublicShareProject.class, projectFolder, ProjectRole.EDITOR);
        }
        catch (PmlSecurityPermissionDeniedException e) {
            if (!e.hasPermissions()) {
                throw PmlSecurityExceptionFactory.createProjectAlreadyExistsException((String)projectFolder.getLocation(), (PmlSecurityPermissionDeniedException)e);
            }
        }
        catch (ProjectNotFoundException e) {
            newProject = true;
        }
        PublicShareProject result = this.domain.createPublicShare(location, publicShareProject, templateProject, this.securityService.getUserName(), checkVersion, keepLock);
        if (newProject) {
            this.securityService.publishProject(MdProjectUtil.createMdProjectFullId(ProjectType.PUBLIC_SHARED, result));
        }
        return result;
    }

    @Override
    public PublicShareProject savePublicShare(@NotNull ProjectFolder location, @NotNull PublicShareProject publicShareProject, @NotNull String userName, boolean checkVersion, boolean keepLock) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.savePublicShare must not be null");
        }
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.savePublicShare must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.savePublicShare must not be null");
        }
        ProjectFolder projectFolder = ProjectFolder.create(location, publicShareProject.getName());
        boolean newProject = false;
        try {
            this.assertProjectPrivilege(PublicShareProject.class, projectFolder, ProjectRole.EDITOR);
        }
        catch (PmlSecurityPermissionDeniedException e) {
            if (!e.hasPermissions()) {
                throw PmlSecurityExceptionFactory.createProjectAlreadyExistsException((String)projectFolder.getLocation(), (PmlSecurityPermissionDeniedException)e);
            }
        }
        catch (ProjectNotFoundException e) {
            newProject = true;
        }
        String projectLocation = VFileUtils.getCanonicalPath((String)projectFolder.getLocation());
        String mdProjectFullId = MdProjectUtil.createMdProjectFullId(ProjectType.PUBLIC_SHARED, projectLocation);
        PublicShareProject result = this.domain.savePublicShare(location, publicShareProject, this.securityService.getUserName(), checkVersion, keepLock);
        if (newProject) {
            this.securityService.publishProject(mdProjectFullId);
        }
        return result;
    }

    @Override
    public boolean isPublicShareUpToDate(@NotNull ProjectFolder location, @NotNull PublicShareProject publicShareProject) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.isPublicShareUpToDate must not be null");
        }
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.isPublicShareUpToDate must not be null");
        }
        ProjectFolder projectFolder = ProjectFolder.create(location, publicShareProject.getName());
        this.assertProjectPrivilege(PublicShareProject.class, projectFolder, ProjectRole.VIEWER);
        return this.domain.isPublicShareUpToDate(location, publicShareProject);
    }

    @Override
    public void commitChanges(@NotNull String draftId, @NotNull String userName) throws MetadataException {
        if (draftId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.commitChanges must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.commitChanges must not be null");
        }
        String mdProjectFullId = MdProjectUtil.createMdProjectFullId(ProjectType.PUBLIC_SHARED, draftId);
        int index = mdProjectFullId.lastIndexOf(47);
        mdProjectFullId = mdProjectFullId.substring(0, index);
        this.securityService.assertPrivilege(mdProjectFullId, ProjectRole.EDITOR);
        this.domain.commitChanges(draftId, this.securityService.getUserName());
    }

    @Override
    public <T extends MdProject<?>> void createFolder(@NotNull Class<T> context, @NotNull ProjectFolder folder) throws MetadataException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.createFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.createFolder must not be null");
        }
        this.domain.createFolder(context, folder);
    }

    @Override
    public <T extends MdProject<?>> boolean existsFolder(@NotNull Class<T> context, @NotNull ProjectFolder folder) throws PersistenceException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.existsFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.existsFolder must not be null");
        }
        return this.domain.existsFolder(context, folder);
    }

    @Override
    public <T extends MdProject<?>> void removeFolder(@NotNull Class<T> context, @NotNull ProjectFolder folder, boolean recursive) throws MetadataException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.removeFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.removeFolder must not be null");
        }
        this.domain.removeFolder(context, folder, recursive);
    }

    @Override
    public void removePublicShare(@NotNull PublicShareProject publicShare) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.removePublicShare must not be null");
        }
        this.assertProjectPrivilege(PublicShareProject.class, publicShare.getFolder().get(), ProjectRole.OWNER);
        this.domain.removePublicShare(publicShare);
        String mdProjectFullId = MdProjectUtil.createMdProjectFullId(ProjectType.PUBLIC_SHARED, publicShare.getFolder().get().getLocation());
        this.securityService.deleteProject(mdProjectFullId);
    }

    @Override
    public <T extends MdProject<?>> void removeProject(@NotNull Class<T> type, @NotNull MdProject<?> mdProject) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.removeProject must not be null");
        }
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.removeProject must not be null");
        }
        ProjectFolder folder = (ProjectFolder)Cast.force((Object)mdProject.getFolder().get());
        this.assertProjectPrivilege(type, folder, ProjectRole.OWNER);
        this.domain.removeProject(type, mdProject);
    }

    @Override
    public void removeTemplate(@NotNull TemplateProject template, boolean breakLinks) throws MetadataException {
        if (template == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.removeTemplate must not be null");
        }
        ProjectFolder folder = (ProjectFolder)Cast.force((Object)template.getFolder().get());
        this.assertProjectPrivilege(TemplateProject.class, folder, ProjectRole.OWNER);
        this.domain.removeTemplate(template, breakLinks);
        String mdProjectFullId = MdProjectUtil.createMdProjectFullId(ProjectType.TEMPLATE, template.getFolder().get().getLocation());
        this.securityService.deleteProject(mdProjectFullId);
    }

    @Override
    public MdTree getPublicSharesLinkedToTemplate(@NotNull TemplateProject template) throws MetadataException {
        if (template == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.getPublicSharesLinkedToTemplate must not be null");
        }
        ProjectFolder folder = (ProjectFolder)Cast.force((Object)template.getFolder().get());
        this.assertProjectPrivilege(TemplateProject.class, folder, ProjectRole.OWNER);
        return this.domain.getPublicSharesLinkedToTemplate(template);
    }

    @Override
    public void releaseLock(@NotNull String draftLocation) throws MetadataException {
        if (draftLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.releaseLock must not be null");
        }
        String mdProjectFullId = MdProjectUtil.createMdProjectFullId(ProjectType.PUBLIC_SHARED, draftLocation);
        int idx = draftLocation.lastIndexOf(47);
        String psLocation = draftLocation.substring(0, idx);
        PublicShareProject publicShare = this.domain.loadProject(PublicShareProject.class, psLocation, true).get();
        String userName = publicShare.getUserLock();
        ProjectRole requiredRole = ProjectRole.EDITOR;
        if (!this.securityService.getUserName().equals(userName)) {
            requiredRole = ProjectRole.OWNER;
        }
        int index = mdProjectFullId.lastIndexOf(47);
        mdProjectFullId = mdProjectFullId.substring(0, index);
        this.securityService.assertPrivilege(mdProjectFullId, requiredRole);
        this.domain.releaseLock(draftLocation);
    }

    @Override
    public void releaseLock(@NotNull PublicShareProject publicShareProject) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.releaseLock must not be null");
        }
        ProjectRole requiredRole = ProjectRole.EDITOR;
        if (publicShareProject.isLocked() && !this.securityService.getUserName().equals(publicShareProject.getUserLock())) {
            requiredRole = ProjectRole.OWNER;
        }
        this.assertProjectPrivilege(PublicShareProject.class, publicShareProject.getFolder().get(), requiredRole);
        this.domain.releaseLock(publicShareProject);
    }

    @Override
    public DraftProject getLock(@NotNull PublicShareProject publicShareProject, @NotNull String userName) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.getLock must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.getLock must not be null");
        }
        this.assertProjectPrivilege(PublicShareProject.class, publicShareProject.getFolder().get(), ProjectRole.EDITOR);
        DraftProject lock = this.domain.getLock(publicShareProject, this.securityService.getUserName());
        String mdProjectFullId = MdProjectUtil.createMdProjectFullId(ProjectType.PUBLIC_SHARED, publicShareProject.getId());
        BasicSecuredProject securedProject = (BasicSecuredProject)this.securityService.getProjects().get(mdProjectFullId);
        if (securedProject != null) {
            lock.setSecuredProject(securedProject);
        }
        return lock;
    }

    @Override
    public <T extends MdProject<?>> void releaseFromCache(@NotNull Class<T> type, @NotNull String projectName) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.releaseFromCache must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.releaseFromCache must not be null");
        }
        this.domain.releaseFromCache(type, projectName);
    }

    @Override
    public void updatePublicShareProperties(@NotNull String publicShareId, boolean allowSharing, @Nullable String workflow, @Nullable List<String> participantIds) throws MetadataException {
        if (publicShareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.updatePublicShareProperties must not be null");
        }
        this.assertProjectPrivilege(PublicShareProject.class, ProjectFolder.create(publicShareId), ProjectRole.EDITOR);
        this.domain.updatePublicShareProperties(publicShareId, allowSharing, workflow, participantIds);
    }

    @Override
    public LocalRef<DeployedProject> getDeployedProject(@NotNull String projectLocation) throws MetadataException {
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.getDeployedProject must not be null");
        }
        this.assertProjectPrivilege(PublicShareProject.class, ProjectFolder.create(projectLocation), ProjectRole.OWNER);
        return this.domain.getDeployedProject(projectLocation);
    }

    @Override
    public <T extends MdProject<?>> void importProject(@NotNull File folder, @NotNull Class<T> type, @NotNull ProjectFolder destination, @NotNull String userName, @NotNull String projectName, @Nullable String description) throws MetadataException {
        if (folder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.importProject must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.importProject must not be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.importProject must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.importProject must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.importProject must not be null");
        }
        this.domain.importProject(folder, type, destination, this.securityService.getUserName(), projectName, description);
        if (this.isSecuredProjectType(type)) {
            String projectLocation = VFileUtils.getCanonicalPath((String)ProjectFolder.create(destination, projectName).getLocation());
            String mdProjectFullId = MdProjectUtil.createMdProjectFullId(MetadataArtifactHelper.getProjectType(type), projectLocation);
            if (type.equals(TemplateProject.class)) {
                this.securityService.publishProject(mdProjectFullId, ProjectRole.EDITOR);
            } else {
                this.securityService.publishProject(mdProjectFullId);
            }
        }
    }

    @Override
    public <T extends MdProject<?>> void updateProperties(@NotNull Class<T> publicShareProjectClass, @NotNull String projectLocation, @NotNull HashMap<String, String> properties) throws MetadataException {
        if (publicShareProjectClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.updateProperties must not be null");
        }
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.updateProperties must not be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.updateProperties must not be null");
        }
        this.assertProjectPrivilege(publicShareProjectClass, ProjectFolder.create(projectLocation), ProjectRole.VIEWER);
        this.domain.updateProperties(publicShareProjectClass, projectLocation, properties);
    }

    @Override
    public void createSnapshot(@NotNull PublicShareProject publicShareProject, @NotNull String versionName, @Nullable String description, @NotNull String userName) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.createSnapshot must not be null");
        }
        if (versionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.createSnapshot must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.createSnapshot must not be null");
        }
        this.assertProjectPrivilege(PublicShareProject.class, publicShareProject.getFolder().get(), ProjectRole.EDITOR);
        this.domain.createSnapshot(publicShareProject, versionName, description, this.securityService.getUserName());
    }

    @Override
    public List<LocalRef<SnapshotProject>> listSnapshots(@NotNull String publicShareId) throws MetadataException {
        if (publicShareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.listSnapshots must not be null");
        }
        LocalRef<PublicShareProject> ref = this.loadProject(PublicShareProject.class, VFileUtils.getCanonicalPath((String)publicShareId), false);
        PublicShareProject publicShareProject = ref.get();
        this.assertProjectPrivilege(PublicShareProject.class, publicShareProject.getFolder().get(), ProjectRole.VIEWER);
        return this.domain.listSnapshots(publicShareId);
    }

    @Override
    public void deleteSnapshot(@NotNull String snapshotId) throws MetadataException {
        block3: {
            if (snapshotId == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.deleteSnapshot must not be null");
            }
            LocalRef<SnapshotProject> snapshotRef = this.loadProject(SnapshotProject.class, snapshotId, true);
            SnapshotProject snapshot = snapshotRef.get();
            String userName = this.securityService.getUserName();
            LocalRef<PublicShareProject> ref = this.loadProject(PublicShareProject.class, snapshot.getPublicShareId(), false);
            PublicShareProject publicShareProject = ref.get();
            this.assertProjectPrivilege(PublicShareProject.class, publicShareProject.getFolder().get(), ProjectRole.EDITOR);
            try {
                this.assertProjectPrivilege(PublicShareProject.class, publicShareProject.getFolder().get(), ProjectRole.OWNER);
            }
            catch (PmlSecurityPermissionDeniedException e) {
                boolean isSnapshotCreator = snapshot.getOwnerName().equals(userName);
                if (isSnapshotCreator) break block3;
                throw PmlSecurityExceptionFactory.createPermissionDeniedException((String)userName, (ProjectRole)ProjectRole.OWNER, (ProjectRole)ProjectRole.EDITOR, (PmlSecurityPermissionDeniedException)e);
            }
        }
        this.domain.deleteSnapshot(snapshotId);
    }

    @Override
    public void deleteAllSnapshotsFromPublicShare(@NotNull String publicShareId) throws MetadataException {
        if (publicShareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.deleteAllSnapshotsFromPublicShare must not be null");
        }
        LocalRef<PublicShareProject> ref = this.loadProject(PublicShareProject.class, VFileUtils.getCanonicalPath((String)publicShareId), false);
        PublicShareProject publicShareProject = ref.get();
        this.assertProjectPrivilege(PublicShareProject.class, publicShareProject.getFolder().get(), ProjectRole.OWNER);
        this.domain.deleteAllSnapshotsFromPublicShare(publicShareId);
    }

    @Override
    public LocalRef<SnapshotProject> getSnapshot(@NotNull String publicShareId, @NotNull String versionName) throws MetadataException {
        if (publicShareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.getSnapshot must not be null");
        }
        if (versionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.getSnapshot must not be null");
        }
        LocalRef<PublicShareProject> ref = this.loadProject(PublicShareProject.class, VFileUtils.getCanonicalPath((String)publicShareId), false);
        PublicShareProject publicShareProject = ref.get();
        this.assertProjectPrivilege(PublicShareProject.class, publicShareProject.getFolder().get(), ProjectRole.VIEWER);
        return this.domain.getSnapshot(publicShareId, versionName);
    }

    @Override
    public <T extends MdProject<?>> ProjectFolder findProjectByName(@NotNull Class<T> type, @NotNull String projectName) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.findProjectByName must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.findProjectByName must not be null");
        }
        return this.domain.findProjectByName(type, projectName);
    }

    @Override
    public UpdateResult updatePublicShareFromBaseTemplate(@NotNull PublicShareProject publicShare, @NotNull String userName) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.updatePublicShareFromBaseTemplate must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.updatePublicShareFromBaseTemplate must not be null");
        }
        return this.domain.updatePublicShareFromBaseTemplate(publicShare, this.securityService.getUserName());
    }

    @Override
    public UpdateResult calculateFilesToBeUpdated(@NotNull PublicShareProject publicShare) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.calculateFilesToBeUpdated must not be null");
        }
        return this.domain.calculateFilesToBeUpdated(publicShare);
    }

    @Override
    public boolean isAdmin() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIsAdmin(boolean isAdmin) {
        throw new UnsupportedOperationException();
    }

    private <T extends MdProject<?>> boolean isSecuredProjectType(@NotNull Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.isSecuredProjectType must not be null");
        }
        return SECURED_PROJECT_TYPES.contains((Object)MetadataArtifactHelper.getProjectType(type));
    }

    private <T extends MdProject<?>> void assertProjectPrivilege(@NotNull Class<T> type, @NotNull ProjectFolder folder, @NotNull ProjectRole role) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.assertProjectPrivilege must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.assertProjectPrivilege must not be null");
        }
        if (role == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/security/SecurityMdDomainDecorator.assertProjectPrivilege must not be null");
        }
        if (this.isSecuredProjectType(type)) {
            ProjectType projectType = MetadataArtifactHelper.getProjectType(type);
            String location = folder.getLocation();
            String mdProjectFullId = MdProjectUtil.createMdProjectFullId(projectType, location);
            try {
                this.securityService.assertPrivilege(mdProjectFullId, role);
            }
            catch (PmlSecurityObjectNotFoundException e) {
                throw MetadataExceptionFactory.createProjectNotFound((String)location);
            }
        }
    }

    static {
        SECURED_PROJECT_TYPES.add(ProjectType.PUBLIC_SHARED);
        SECURED_PROJECT_TYPES.add(ProjectType.TEMPLATE);
    }
}

