/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import oracle.bpm.collections.Predicate;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.artifact.jaxb.ObjectFactory;
import oracle.bpm.metadata.artifact.jaxb.PublicShareMetadata;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.SnapshotProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.MetadataExceptionFactory;
import oracle.bpm.metadata.exception.ProjectNotFoundException;
import oracle.bpm.metadata.history.Criteria;
import oracle.bpm.metadata.history.LogicalArtifactRecognizer;
import oracle.bpm.metadata.history.PageContext;
import oracle.bpm.metadata.history.exceptions.HistoryException;
import oracle.bpm.metadata.history.item.recognizer.LogicalArtifactRecognizerImpl;
import oracle.bpm.metadata.history.model.Change;
import oracle.bpm.metadata.impl.MetadataArtifactBuilder;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.lock.jaxb.ApplicationType;
import oracle.bpm.pml.service.StudioMetadataService;
import oracle.bpm.pml.service.security.ApplicationServerConnection;
import oracle.bpm.pml.service.security.MetadataSecurityAccessor;
import oracle.bpm.pml.service.util.lookup.LookupServiceFactory;
import oracle.bpm.project.model.ProjectLoader;
import oracle.mds.core.MDSInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioMetadataServiceImpl
extends MetadataSecurityAccessor
implements StudioMetadataService {
    private LogicalArtifactRecognizer logicalArtifactRecognizer;

    public StudioMetadataServiceImpl(@NotNull MDSInstance instance, @NotNull ApplicationServerConnection applicationServerConnection) throws MetadataException {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.<init> must not be null");
        }
        if (applicationServerConnection == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.<init> must not be null");
        }
        super(instance, applicationServerConnection, ApplicationType.STUDIO, LookupServiceFactory.getStudioLookupHelper(applicationServerConnection.getWebsphere7Descriptor()));
    }

    public StudioMetadataServiceImpl(@NotNull MDSInstance instance, @NotNull String persistenceUnit, @NotNull File jpsConfig, @NotNull String applicationName, @NotNull String username, boolean clearJpsContext) throws MetadataException {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.<init> must not be null");
        }
        if (persistenceUnit == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.<init> must not be null");
        }
        if (jpsConfig == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.<init> must not be null");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.<init> must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.<init> must not be null");
        }
        super(instance, persistenceUnit, jpsConfig, applicationName, username, clearJpsContext, ApplicationType.STUDIO);
    }

    @Override
    public <K extends ProjectArtifact> MdTree getTemplates(@Nullable Predicate<TemplateProject> predicate, @Nullable LocalRef<K> parent) throws MetadataException {
        return this.mdDomain.browseProject(TemplateProject.class, predicate, parent);
    }

    @Override
    public <K extends ProjectArtifact> MdTree getPublicShares(@Nullable Predicate<PublicShareProject> predicate, @Nullable LocalRef<K> parent) throws MetadataException {
        return this.mdDomain.browseProject(PublicShareProject.class, predicate, parent);
    }

    @Override
    public <T extends MdProject> LocalRef<T> loadProject(@NotNull Class<T> type, @NotNull String projectId) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.loadProject must not be null");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.loadProject must not be null");
        }
        return this.loadProject(type, projectId, false);
    }

    @Override
    public <T extends MdProject> LocalRef<T> loadProject(@NotNull Class<T> type, @NotNull String projectId, boolean forceReload) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.loadProject must not be null");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.loadProject must not be null");
        }
        return this.mdDomain.loadProject(type, projectId, forceReload);
    }

    @Override
    public void deleteTemplateProject(@NotNull String templateId, @NotNull boolean breakLinks) throws MetadataException {
        if (templateId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.deleteTemplateProject must not be null");
        }
        TemplateProject template = this.loadProject(TemplateProject.class, templateId).get();
        this.mdDomain.removeTemplate(template, breakLinks);
    }

    @Override
    public void deletePublicShare(@NotNull String projectId) throws MetadataException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.deletePublicShare must not be null");
        }
        PublicShareProject publicShareProject = this.loadProject(PublicShareProject.class, projectId).get();
        if (!this.listSnapshots(publicShareProject.getId()).isEmpty()) {
            this.mdDomain.deleteAllSnapshotsFromPublicShare(publicShareProject.getId());
        }
        this.mdDomain.removePublicShare(publicShareProject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TemplateProject saveTemplateProject(@NotNull ProjectFolder location, @NotNull TemplateProject template, boolean overwrite, boolean checkVersion) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.saveTemplateProject must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.saveTemplateProject must not be null");
        }
        ProjectLoader loader = template.getProject().get().getLoader();
        if (loader == null) throw MetadataExceptionFactory.createInvalidProjectException();
        VFileSystem filesystem = loader.getProjectFileSystem().getDataFileSystem();
        MetadataType localMetadata = MetadataArtifactHelper.getMetadataArtifact(filesystem, TemplateProject.class, "/");
        if (localMetadata != null) {
            template.setUpdateTimestamp(localMetadata.getUpdateTimestamp());
        }
        TemplateProject result = this.mdDomain.createTemplateProject(location, template, this.securityService.getUserName(), overwrite, checkVersion);
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            MetadataType savedMetadata = MetadataArtifactBuilder.create(result, location.getLocation());
            VFile file = filesystem.createFile("projectMetadata.xml");
            if ((!file.exists() || !file.canWrite()) && (file.exists() || !file.getParentFile().canWrite())) return result;
            MetadataArtifactHelper.serialize(objectFactory.createMetadata(savedMetadata), file);
            return result;
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public <T extends MdProject> void createFolder(@NotNull Class<T> type, @NotNull ProjectFolder folder) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.createFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.createFolder must not be null");
        }
        this.mdDomain.createFolder(type, folder);
    }

    @Override
    public <T extends MdProject> boolean existsFolder(@NotNull Class<T> type, @NotNull ProjectFolder folder) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.existsFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.existsFolder must not be null");
        }
        return this.mdDomain.existsFolder(type, folder);
    }

    @Override
    public <T extends MdProject> void deleteFolder(@NotNull Class<T> type, @NotNull ProjectFolder folder, boolean recursive) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.deleteFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.deleteFolder must not be null");
        }
        this.mdDomain.removeFolder(type, folder, recursive);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PublicShareProject savePublicShare(@NotNull ProjectFolder location, @NotNull PublicShareProject publicShare, boolean checkVersion, boolean keepLock) throws MetadataException {
        boolean isNewLocalProject;
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.savePublicShare must not be null");
        }
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.savePublicShare must not be null");
        }
        ProjectLoader loader = publicShare.getProject().get().getLoader();
        String userName = this.securityService.getUserName();
        if (loader == null) throw MetadataExceptionFactory.createInvalidProjectException();
        VFileSystem filesystem = loader.getProjectFileSystem().getDataFileSystem();
        MetadataType localMetadata = MetadataArtifactHelper.getMetadataArtifact(filesystem, PublicShareProject.class, "/");
        boolean bl = isNewLocalProject = localMetadata == null;
        if (isNewLocalProject) {
            try {
                this.mdDomain.loadProject(PublicShareProject.class, location.getLocation() + publicShare.getName(), true);
                throw MetadataExceptionFactory.createProjectAlreadyExists((String)publicShare.getId());
            }
            catch (ProjectNotFoundException e) {}
        } else {
            publicShare.setUpdateTimestamp(localMetadata.getUpdateTimestamp());
        }
        PublicShareProject result = this.mdDomain.savePublicShare(location, publicShare, userName, checkVersion, keepLock);
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            PublicShareMetadata savedMetadata = MetadataArtifactBuilder.create(result, location.getLocation());
            VFile file = filesystem.createFile("projectMetadata.xml");
            if ((!file.exists() || !file.canWrite()) && (file.exists() || !file.getParentFile().canWrite())) return result;
            MetadataArtifactHelper.serialize(objectFactory.createMetadata(savedMetadata), file);
            return result;
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public <T extends MdProject> boolean existsProject(@NotNull Class<T> type, @NotNull ProjectFolder location) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.existsProject must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.existsProject must not be null");
        }
        return this.mdDomain.existsProject(type, location);
    }

    @Override
    public void releaseLock(@NotNull PublicShareProject publicShareProject) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.releaseLock must not be null");
        }
        this.mdDomain.releaseLock(publicShareProject);
    }

    @Override
    public void getLock(@NotNull PublicShareProject publicShareProject) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.getLock must not be null");
        }
        this.mdDomain.getLock(publicShareProject, this.securityService.getUserName());
    }

    @Override
    public List<Change> listHistoryChanges(@NotNull Criteria criteria, @Nullable PageContext pageContext) throws HistoryException {
        if (criteria == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.listHistoryChanges must not be null");
        }
        if (this.historyService == null) {
            throw new UnsupportedOperationException("History Service is not set.");
        }
        return this.historyService.listHistoryChanges(criteria, pageContext);
    }

    @Override
    public void createSnapshot(@NotNull PublicShareProject publicShareProject, @NotNull String versionName, @Nullable String description) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.createSnapshot must not be null");
        }
        if (versionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.createSnapshot must not be null");
        }
        this.mdDomain.createSnapshot(publicShareProject, versionName, description, this.securityService.getUserName());
    }

    @Override
    public void deleteSnapshot(@NotNull String snapshotId) throws MetadataException {
        if (snapshotId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.deleteSnapshot must not be null");
        }
        this.mdDomain.deleteSnapshot(snapshotId);
    }

    @Override
    public LocalRef<SnapshotProject> getSnapshot(@NotNull String publicshareid, @NotNull String versionName) throws MetadataException {
        if (publicshareid == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.getSnapshot must not be null");
        }
        if (versionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.getSnapshot must not be null");
        }
        return this.mdDomain.getSnapshot(publicshareid, versionName);
    }

    @Override
    public List<LocalRef<SnapshotProject>> listSnapshots(@NotNull String publicshareId) throws MetadataException {
        if (publicshareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.listSnapshots must not be null");
        }
        return this.mdDomain.listSnapshots(publicshareId);
    }

    @Override
    public <T extends MdProject> ProjectFolder findProjectByName(@NotNull Class<T> type, @NotNull String projectName) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.findProjectByName must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.findProjectByName must not be null");
        }
        return this.mdDomain.findProjectByName(type, projectName);
    }

    @Override
    public LogicalArtifactRecognizer getLogicalArtifactRecognizer() {
        if (this.logicalArtifactRecognizer == null) {
            this.logicalArtifactRecognizer = new LogicalArtifactRecognizerImpl();
        }
        return this.logicalArtifactRecognizer;
    }

    @Override
    public MdTree getPublicSharesLinkedToTemplate(@NotNull TemplateProject template) throws MetadataException {
        if (template == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.getPublicSharesLinkedToTemplate must not be null");
        }
        return this.mdDomain.getPublicSharesLinkedToTemplate(template);
    }
}

