/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.impl;

import java.io.File;
import java.util.Collection;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.entity.DeployedProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.MetadataExceptionFactory;
import oracle.bpm.metadata.lock.jaxb.ApplicationType;
import oracle.bpm.metadata.mds.MdsTransaction;
import oracle.bpm.metadata.mds.utils.MdsTransactionUtil;
import oracle.bpm.pml.service.DeployedProjectService;
import oracle.bpm.pml.service.impl.BaseMetadataService;
import oracle.bpm.pml.service.impl.ReferenceMap;
import oracle.bpm.pml.service.util.DeployedProjectHelper;
import oracle.bpm.pml.service.util.DeployedProjectUtil;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.IncludesStoredI18n;
import oracle.bpm.project.model.processes.Process;
import oracle.fabric.common.MetadataManager;
import oracle.fabric.composite.CompositeDN;
import oracle.fabric.composite.model.CompositeModel;
import oracle.mds.core.MDSInstance;
import oracle.mds.core.MDSSession;
import oracle.mds.net.MDSURLHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeployedProjectServiceImpl
extends BaseMetadataService
implements DeployedProjectService {
    private DeployedProjectHelper deployedProjectHelper;
    private MDSInstance mdsInstance;
    private ReferenceMap<String, Project> projectCache;
    private final Object projectCacheLock;

    @Deprecated
    public DeployedProjectServiceImpl() throws MetadataException {
        this.mdsInstance = null;
        this.projectCacheLock = new Object();
        this.init();
    }

    public DeployedProjectServiceImpl(@NotNull MDSInstance mdsInstance) throws MetadataException {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.<init> must not be null");
        }
        super(mdsInstance, ApplicationType.GENERIC_APPLICATION);
        this.mdsInstance = null;
        this.projectCacheLock = new Object();
        this.init();
        this.mdsInstance = mdsInstance;
        this.deployedProjectHelper = new DeployedProjectHelper(this.mdDomain, mdsInstance);
    }

    public void init() {
        this.projectCache = new ReferenceMap();
    }

    @Override
    @Deprecated
    public Process findProcess(@NotNull String projectsFolder, @NotNull String projectName, @NotNull String processName) throws MetadataException {
        if (projectsFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.findProcess must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.findProcess must not be null");
        }
        if (processName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.findProcess must not be null");
        }
        FileProjectRepository repo = new FileProjectRepository();
        repo.setReadOnly(true);
        try {
            File folder = new File(projectsFolder);
            Project project = repo.create(folder.toURI(), projectName);
            repo.open(project);
            Process process = project.findProcess(processName);
            if (process == null) {
                throw MetadataExceptionFactory.createProcessNotFoundException((String)processName);
            }
            return process;
        }
        catch (ProjectException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Project findProject(@NotNull CompositeDN compositeDN, @Nullable CompositeModel compositeModel) throws MetadataException {
        if (compositeDN == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.findProject must not be null");
        }
        Project project = this.projectCache.get(compositeDN.getDN());
        if (project == null) {
            String token = null;
            String mdsLabel = compositeDN.getLabel();
            MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance, mdsLabel);
            tx.setAutoCommit(false);
            MDSSession protocolSession = null;
            try {
                Object metadataManager;
                if (compositeModel != null) {
                    metadataManager = compositeModel.getMetadataManager();
                    token = metadataManager.initializeURLResolvers();
                }
                if (MDSURLHelper.getMDSSession() == null) {
                    protocolSession = this.mdsInstance.createSession(null, null);
                    MDSURLHelper.setMDSSession((MDSSession)protocolSession);
                }
                metadataManager = this.projectCacheLock;
                synchronized (metadataManager) {
                    tx.begin();
                    String projectLocation = this.getProjectLocation(compositeDN);
                    LocalRef<DeployedProject> projectLocalRef = this.mdDomain.getDeployedProject(projectLocation);
                    DeployedProject deployedProject = projectLocalRef.get();
                    project = deployedProject.getProject().get();
                    project.getComponentCatalog();
                    Collection processes = project.getProcesses();
                    project.getProjectModel().getFeatures().extendFeature((Feature)IncludesStoredI18n.create((boolean)true));
                    for (Process process : processes) {
                        process.getFeatures().extendFeature((Feature)IncludesStoredI18n.create((boolean)true));
                    }
                    this.mdDomain.releaseFromCache(DeployedProject.class, this.getProjectName(compositeDN));
                    this.projectCache.put(compositeDN.getDN(), project);
                    tx.commit();
                }
            }
            catch (MetadataException e) {
                tx.rollback();
                throw e;
            }
            finally {
                if (token != null) {
                    MetadataManager metadataManager = compositeModel.getMetadataManager();
                    metadataManager.uninitializeURLResolvers(token);
                }
                MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
                if (protocolSession != null) {
                    MDSURLHelper.removeMDSSession();
                }
            }
        }
        return project;
    }

    @Override
    public Project findDeployedProject(@NotNull CompositeDN compositeDN, @Nullable CompositeModel compositeModel) throws MetadataException {
        if (compositeDN == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/DeployedProjectServiceImpl.findDeployedProject must not be null");
        }
        Project project = null;
        if (this.deployedProjectHelper.isProjectDeployed(compositeDN)) {
            project = this.findProject(compositeDN, compositeModel);
        }
        return project;
    }

    private String getProjectLocation(CompositeDN compositeDN) {
        return compositeDN.getApplicationName() + "/" + this.getProjectName(compositeDN);
    }

    private String getProjectName(CompositeDN compositeDN) {
        return DeployedProjectUtil.buildDeployedCompositeName(compositeDN.getCompositeName(), compositeDN.getRevision());
    }
}

