/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.deployment.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.bpm.deployment.DbInfo;
import oracle.bpm.deployment.DeploymentResult;
import oracle.bpm.deployment.impl.DeploymentServiceAntExecutor;
import oracle.bpm.deployment.util.AdfConfigFileWriter;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.lang.Cast;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.msg.MetadataMsg;
import oracle.bpm.pml.service.impl.DeploymentPlanResult;
import oracle.bpm.pml.service.util.DeployedProjectUtil;
import oracle.bpm.project.catalog.composite.CompositeAccessorFactory;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.Base64;
import oracle.bpm.util.FileUtils;
import oracle.bpm.util.JarWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentServiceUtils {
    private static final String JAR_EXTENSION = ".jar";
    private static final String SAR_FILE_PREFIX = "sca_";
    private static final String SOA_INFRA = "soa-infra";

    private DeploymentServiceUtils() {
    }

    public static DeploymentResult copyProjectToTempFolder(@NotNull File tmpDirectory, @Nullable URL soaSharedBundle, @NotNull MdProject<?> projectToDeploy, @Nullable DbInfo dbInfo) {
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.copyProjectToTempFolder must not be null");
        }
        if (projectToDeploy == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.copyProjectToTempFolder must not be null");
        }
        DeploymentResult result = null;
        try {
            LocalRef projectLocalRef = (LocalRef)Cast.force(projectToDeploy.getProject());
            Project project = (Project)projectLocalRef.get();
            ProjectLoader loader = project.getLoader();
            assert (loader != null);
            ProjectFileSystem fileSystem = loader.getProjectFileSystem();
            VFileSystem sourceFS = fileSystem.getDataFileSystem();
            File targetFolder = DeploymentServiceUtils.getTempFolderForProject(tmpDirectory, projectToDeploy);
            if (targetFolder.exists()) {
                FileUtils.deleteDirectory(targetFolder, true);
            }
            targetFolder.mkdirs();
            JavaFileSystem targetFS = new JavaFileSystem(targetFolder);
            boolean wasCopied = VFileUtils.dirCopy((VFile)sourceFS.getRoot(), (VFile)targetFS.getRoot(), null);
            if (wasCopied) {
                if (DeploymentServiceUtils.isAntTaskValidatorPresent()) {
                    DeploymentServiceUtils.createAdfConfigFile(tmpDirectory, soaSharedBundle, (VFileSystem)targetFS, dbInfo);
                    targetFS.flush();
                } else {
                    targetFS.flush();
                    DeploymentServiceUtils.addComposerAdfConfigFileToProject(targetFolder);
                }
            } else {
                result = new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION, (Msg)MetadataMsg.COPY_FILE_ERROR);
            }
        }
        catch (Exception e) {
            result = new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION);
            result.addFault(e);
        }
        if (result == null) {
            result = new DeploymentResult();
        }
        return result;
    }

    public static boolean isAntTaskValidatorPresent() {
        return Boolean.parseBoolean(System.getProperty("use.ant.task.composite.validation"));
    }

    public static File getTempFolderForProject(@NotNull File tmpDirectory, @NotNull MdProject<?> mdProject) {
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.getTempFolderForProject must not be null");
        }
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.getTempFolderForProject must not be null");
        }
        return new File(tmpDirectory, mdProject.getName());
    }

    public static DeploymentResult validateProject(@NotNull MdProject<?> mdProject) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.validateProject must not be null");
        }
        DeploymentResult result = new DeploymentResult();
        try {
            Process process;
            VFile file;
            Project project = mdProject.getProject().get();
            Collection processes = project.getProcesses();
            ProjectLoader loader = project.getLoader();
            assert (loader != null);
            ProjectFileSystem fileSystem = loader.getProjectFileSystem();
            VFileSystem vFileSystem = fileSystem.getDataFileSystem();
            if (!processes.isEmpty() && (file = vFileSystem.createFile((process = (Process)processes.iterator().next()).getId() + ".wsdl")).exists()) {
                CompositeAccessorFactory.createCompositeUpdater((Process)process).updateComposite();
            }
        }
        catch (MetadataException e) {
            result = new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION);
            result.addFault(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJar(@NotNull String jarFile, @NotNull File directoryRoot, @Nullable Manifest manifest) throws IOException {
        if (jarFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.createJar must not be null");
        }
        if (directoryRoot == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.createJar must not be null");
        }
        File f = new File(jarFile);
        if (f.exists()) {
            f.delete();
        }
        JarWrapper jar = null;
        try {
            jar = JarWrapper.createJar(jarFile, manifest);
            jar.addDirectoryTree(directoryRoot, null, false);
            jar.flush();
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
    }

    public static File getSarFile(@NotNull File tmpDirectory, @NotNull MdProject<?> project, @NotNull String version) {
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.getSarFile must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.getSarFile must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.getSarFile must not be null");
        }
        File projectPath = DeploymentServiceUtils.getTempFolderForProject(tmpDirectory, project);
        StringBuilder sarFilePath = new StringBuilder(projectPath.getAbsolutePath());
        sarFilePath.append(File.separator).append("deploy");
        sarFilePath.append(File.separator).append(SAR_FILE_PREFIX);
        sarFilePath.append(DeployedProjectUtil.buildDeployedCompositeName(project.getName(), version));
        return new File(sarFilePath.append(JAR_EXTENSION).toString());
    }

    public static File getCompileOutput(@NotNull File tmpDirectory, @NotNull MdProject<?> projectToDeploy) {
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.getCompileOutput must not be null");
        }
        if (projectToDeploy == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.getCompileOutput must not be null");
        }
        return new File(DeploymentServiceUtils.getTempFolderForLogs(tmpDirectory, projectToDeploy), "sca_compile_output.xml");
    }

    public static DeploymentPlanResult generateDeploymentPlan(@NotNull DeploymentServiceAntExecutor invokerAntTask, @NotNull File tmpDirectory, @Nullable URL soaSharedBundle, @NotNull MdProject<?> mdProject) {
        if (invokerAntTask == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.generateDeploymentPlan must not be null");
        }
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.generateDeploymentPlan must not be null");
        }
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.generateDeploymentPlan must not be null");
        }
        DeploymentResult result = DeploymentServiceUtils.validateProject(mdProject);
        File tempFolderForProject = DeploymentServiceUtils.getTempFolderForProject(tmpDirectory, mdProject);
        tempFolderForProject.mkdirs();
        String plan = new File(tempFolderForProject, mdProject.getName() + "_cfgplan.xml").getAbsolutePath();
        if (result.isSuccessful() && (result = DeploymentServiceUtils.copyProjectToTempFolder(tmpDirectory, soaSharedBundle, mdProject, null)).isSuccessful()) {
            HashMap<String, String> args = new HashMap<String, String>();
            String input = DeploymentServiceUtils.getTempFolderForProject(tmpDirectory, mdProject).getAbsolutePath() + "/" + "composite.xml";
            args.put("scac.input", input);
            args.put("scac.plan", plan);
            result = invokerAntTask.deploymentPlanTask(mdProject, args);
        }
        try {
            File outputFile = new File(plan);
            FileInputStream fileInputStream = new FileInputStream(outputFile);
            return new DeploymentPlanResult(result, fileInputStream);
        }
        catch (IOException e) {
            result.addFault(e);
            return new DeploymentPlanResult(result, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static DeploymentResult validateDeploymentUser(@NotNull URL serverURL, @NotNull String user, @NotNull String password) {
        if (serverURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.validateDeploymentUser must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.validateDeploymentUser must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.validateDeploymentUser must not be null");
        }
        String encoding = Base64.encode((byte[])(user + ":" + password).getBytes());
        InputStream inputStream = null;
        DeploymentResult result = null;
        try {
            URL validationUrl = new URL(serverURL.toURI().toString() + "/" + SOA_INFRA);
            URLConnection uc = validationUrl.openConnection();
            uc.setRequestProperty("Authorization", "Basic " + encoding);
            inputStream = uc.getInputStream();
        }
        catch (IOException e) {
            block11: {
                String message = e.getMessage();
                if (message != null && message.contains("401")) {
                    result = new DeploymentResult(DeploymentResult.DeploymentFaultType.CONFIGURATION, (Msg)MetadataMsg.DEPLOYMENT_AUTHENTICATION_FAILED);
                    break block11;
                }
                result = new DeploymentResult(DeploymentResult.DeploymentFaultType.CONFIGURATION);
                result.addFault(e);
            }
            StreamUtils.close((Closeable[])new Closeable[]{inputStream});
        }
        catch (URISyntaxException e2) {
            result = new DeploymentResult(DeploymentResult.DeploymentFaultType.CONFIGURATION, (Msg)MetadataMsg.DEPLOYMENT_URL_ERROR);
            {
                catch (Throwable throwable) {
                    StreamUtils.close((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
            }
            StreamUtils.close((Closeable[])new Closeable[]{inputStream});
        }
        StreamUtils.close((Closeable[])new Closeable[]{inputStream});
        if (result == null) {
            result = new DeploymentResult();
        }
        return result;
    }

    private static void addComposerAdfConfigFileToProject(@NotNull File targetFolder) {
        if (targetFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.addComposerAdfConfigFileToProject must not be null");
        }
        File adfFolder = new File(targetFolder, ".adf");
        File metaInfFolder = new File(adfFolder, "META-INF");
        metaInfFolder.mkdirs();
        InputStream resourceAsStream = DeploymentServiceUtils.class.getResourceAsStream("/META-INF/adf-config.xml");
        if (resourceAsStream != null) {
            File adfConfig = new File(metaInfFolder, "adf-config.xml");
            FileUtils.fileCopy(resourceAsStream, adfConfig);
        }
    }

    private static void createAdfConfigFile(@NotNull File tmpDirectory, @Nullable URL soaSharedBundle, @NotNull VFileSystem targetFS, @Nullable DbInfo dbInfo) throws IOException, MetadataException {
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.createAdfConfigFile must not be null");
        }
        if (targetFS == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.createAdfConfigFile must not be null");
        }
        VFile adfFolder = targetFS.createFile(".adf");
        adfFolder.mkdirs();
        VFile metaInfFolder = targetFS.createFile(adfFolder, "META-INF");
        metaInfFolder.mkdirs();
        if (dbInfo != null) {
            if (dbInfo.host == null || dbInfo.host.trim().length() <= 0) {
                throw new MetadataException(MetadataMsg.HOST_NOT_SET);
            }
            if (dbInfo.port == null || dbInfo.port.trim().length() <= 0) {
                throw new MetadataException(MetadataMsg.PORT_NOT_SET);
            }
            if (dbInfo.sid == null || dbInfo.sid.trim().length() <= 0) {
                throw new MetadataException(MetadataMsg.SID_NOT_SET);
            }
            if (dbInfo.username == null || dbInfo.username.trim().length() <= 0) {
                throw new MetadataException(MetadataMsg.USERNAME_NOT_SET);
            }
            if (dbInfo.password == null || dbInfo.password.trim().length() <= 0) {
                throw new MetadataException(MetadataMsg.PASSWORD_NOT_SET);
            }
            AdfConfigFileWriter.writeBaseOnDbMds(metaInfFolder, SOA_INFRA, dbInfo.host, dbInfo.port, dbInfo.sid, dbInfo.username, dbInfo.password);
        } else {
            DeploymentServiceUtils.unZipSoaBundle(soaSharedBundle, tmpDirectory);
            AdfConfigFileWriter.writeBaseOnFsMds(metaInfFolder, "/soa/shared", "soa-shared", tmpDirectory.getCanonicalPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unZipSoaBundle(URL soaSharedBundle, @NotNull File tmpDirectory) throws IOException {
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.unZipSoaBundle must not be null");
        }
        if (soaSharedBundle != null) {
            File zipFolder = new File(tmpDirectory, "soa-shared");
            zipFolder.mkdir();
            File soaZipFile = new File(zipFolder, "soa-shared-bundle.zip");
            FileUtils.fileCopy(soaSharedBundle.openStream(), soaZipFile);
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(soaZipFile);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    if (zipEntry.isDirectory()) {
                        new File(zipFolder, zipEntry.getName()).mkdirs();
                        continue;
                    }
                    File file = new File(zipFolder, zipEntry.getName());
                    file.getParentFile().mkdirs();
                    FileUtils.fileCopy(zipFile.getInputStream(zipEntry), file);
                }
            }
            finally {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
        }
    }

    private static File getTempFolderForLogs(@NotNull File tmpDirectory, @NotNull MdProject<?> mdProject) {
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.getTempFolderForLogs must not be null");
        }
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/util/DeploymentServiceUtils.getTempFolderForLogs must not be null");
        }
        return new File(tmpDirectory, mdProject.getName());
    }
}

