/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.deployment.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import oracle.bpm.deployment.DbInfo;
import oracle.bpm.deployment.DeploymentResult;
import oracle.bpm.deployment.DeploymentService;
import oracle.bpm.deployment.impl.DeploymentServiceAntExecutor;
import oracle.bpm.deployment.util.DeploymentServiceUtils;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.pml.service.impl.DeploymentPlanResult;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.FileUtils;
import oracle.fabric.common.FabricException;
import oracle.integration.platform.blocks.deploy.servlet.CompositeDeployerClient;
import oracle.integration.platform.blocks.deploy.servlet.CompositeServletClientBase;
import oracle.integration.platform.blocks.deploy.servlet.CompositeUtil;
import oracle.soa.scac.FaultObject;
import oracle.soa.scac.ValidateComposite;
import oracle.soa.scac.ValidationFault;
import org.apache.tools.ant.BuildException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScacDeploymentService
implements DeploymentService {
    private final DeploymentServiceAntExecutor invokerAntTask;
    private final File tmpDirectory;
    private static FileFilter sarFileFilter;
    private static FilenameFilter sarRootFilenameFiler;

    public ScacDeploymentService(@NotNull File tmpDirectory, @NotNull File antScaDirectory, @NotNull File antDirectory) {
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.<init> must not be null");
        }
        if (antScaDirectory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.<init> must not be null");
        }
        if (antDirectory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.<init> must not be null");
        }
        this.tmpDirectory = tmpDirectory;
        this.invokerAntTask = new DeploymentServiceAntExecutor(tmpDirectory, antScaDirectory, antDirectory);
    }

    @Override
    public DeploymentResult generateSarFile(@NotNull MdProject<?> mdProject, @NotNull String version, @Nullable DbInfo dbInfo) {
        String composite;
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.generateSarFile must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.generateSarFile must not be null");
        }
        DeploymentResult result = DeploymentServiceUtils.validateProject(mdProject);
        if (result.isSuccessful() && (result = DeploymentServiceUtils.copyProjectToTempFolder(this.tmpDirectory, null, mdProject, dbInfo)).isSuccessful() && (result = this.validateProject(composite = this.getCompositePath(mdProject))).isSuccessful()) {
            File[] files;
            File tempFolderForProject = DeploymentServiceUtils.getTempFolderForProject(this.tmpDirectory, mdProject);
            File resources = new File(tempFolderForProject, "resources");
            if (resources.exists()) {
                File destination = new File(tempFolderForProject, "SCA-INF/classes");
                if (!destination.exists()) {
                    destination.mkdirs();
                }
                FileUtils.copyFileOrDirectory(resources, destination, null, false);
            }
            File dist = new File(tempFolderForProject, "dist");
            dist.mkdirs();
            for (File file : files = tempFolderForProject.listFiles(this.getRootFilter())) {
                FileUtils.copyFileOrDirectory(file, dist, this.getFileFilter(), true);
            }
            try {
                CompositeUtil.modifyRevision((File)new File(dist, "composite.xml"), (String)version);
                File sarFile = this.getSarFile(mdProject, version);
                sarFile.getParentFile().mkdirs();
                DeploymentServiceUtils.createJar(sarFile.getAbsolutePath(), dist, null);
            }
            catch (FabricException e) {
                result = new DeploymentResult(DeploymentResult.DeploymentFaultType.DEPLOYMENT);
                result.addFault(e);
            }
            catch (IOException e) {
                result = new DeploymentResult(DeploymentResult.DeploymentFaultType.DEPLOYMENT);
                result.addFault(e);
            }
        }
        return result;
    }

    @Override
    public DeploymentPlanResult generateDeploymentPlan(@NotNull MdProject<?> mdProject) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.generateDeploymentPlan must not be null");
        }
        return DeploymentServiceUtils.generateDeploymentPlan(this.invokerAntTask, this.tmpDirectory, null, mdProject);
    }

    @Override
    public DeploymentResult createPartition(@NotNull URL serverURL, @NotNull String user, @NotNull String password, @NotNull String partition) {
        if (serverURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.createPartition must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.createPartition must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.createPartition must not be null");
        }
        if (partition == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.createPartition must not be null");
        }
        return this.invokerAntTask.createPartition(serverURL, user, password, partition);
    }

    @Override
    public DeploymentResult deletePartition(@NotNull URL serverURL, @NotNull String user, @NotNull String password, @NotNull String partition) {
        if (serverURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.deletePartition must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.deletePartition must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.deletePartition must not be null");
        }
        if (partition == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.deletePartition must not be null");
        }
        return this.invokerAntTask.deletePartition(serverURL, user, password, partition);
    }

    @Override
    public DeploymentResult deploy(@NotNull URL serverURL, @NotNull String user, @NotNull String password, @NotNull MdProject<?> project, @NotNull String version, boolean overwrite, boolean forceDefault, @Nullable File deploymentPlan, @Nullable InputStream sysProp, @Nullable String partition, @Nullable DbInfo dbInfo) {
        if (serverURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.deploy must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.deploy must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.deploy must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.deploy must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.deploy must not be null");
        }
        DeploymentResult result = DeploymentServiceUtils.validateDeploymentUser(serverURL, user, password);
        if (result.isSuccessful() && (result = this.generateSarFile(project, version, dbInfo)).isSuccessful()) {
            try {
                String sarLocation;
                File sarFile = this.getSarFile(project, version);
                CompositeDeployerClient client = new CompositeDeployerClient(serverURL);
                client.setAuthorizationPrompter(null);
                client.setBasicAuth(user, password);
                if (partition != null) {
                    String partitionPar = partition;
                    if (partitionPar.startsWith("/") && partitionPar.length() > 1) {
                        partitionPar = partitionPar.substring(1);
                    }
                    client.setPartition(partitionPar);
                }
                client.setOverwrite(overwrite);
                client.setForceDefault(forceDefault);
                client.setKeepInstancesOnRedeploy(false);
                client.setCommand("deploy");
                if (deploymentPlan != null) {
                    client.setDeployPlan(deploymentPlan.getAbsolutePath());
                }
                if ((sarLocation = sarFile.getAbsolutePath()).endsWith(".ear")) {
                    client.setEar(sarLocation);
                } else {
                    client.setSar(sarLocation);
                }
                if (sysProp != null) {
                    File sysPropFileFile = new File(sarFile, "sysPropsTemp.xml");
                    FileUtils.fileCopy(sysProp, sysPropFileFile);
                    this.setSystemPropsFromFile((CompositeServletClientBase)client, sysPropFileFile.getAbsolutePath());
                }
                int respCode = client.sendRequest();
                result = this.checkResponse(respCode, client.getErrorMsg());
            }
            catch (Exception e) {
                result = new DeploymentResult(DeploymentResult.DeploymentFaultType.DEPLOYMENT);
                result.addFault(e);
            }
        }
        return result;
    }

    @Override
    public File getSarFile(@NotNull MdProject<?> project, @NotNull String version) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.getSarFile must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.getSarFile must not be null");
        }
        return DeploymentServiceUtils.getSarFile(this.tmpDirectory, project, version);
    }

    private DeploymentResult validateProject(@NotNull String composite) {
        if (composite == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.validateProject must not be null");
        }
        DeploymentResult result = new DeploymentResult();
        ValidateComposite validateComposite = new ValidateComposite(composite);
        validateComposite.setUseSoaInfraMds(true);
        try {
            validateComposite.doValidation();
            ValidationFault validationFault = validateComposite.getFaults();
            List faults = validationFault.getFaults();
            if (!faults.isEmpty()) {
                String errorMsg = null;
                for (FaultObject fault : faults) {
                    if (fault.getSeverity() != ValidationFault.FaultSeverity.FATAL_ERROR) continue;
                    if (errorMsg == null) {
                        errorMsg = fault.getMessage() + '\n';
                        continue;
                    }
                    errorMsg = errorMsg + fault.getMessage();
                }
                if (errorMsg != null) {
                    result = new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION, Msg.QUOTE(errorMsg));
                }
            }
        }
        catch (Exception e) {
            result = new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION);
            result.addFault(e);
        }
        return result;
    }

    private FileFilter getFileFilter() {
        if (sarFileFilter == null) {
            sarFileFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String name = pathname.getName();
                    return !name.endsWith(".jpr") && !name.endsWith(".ear") && !name.endsWith(".zip") && !name.endsWith(".war") && !name.endsWith(".jws");
                }
            };
        }
        return sarFileFilter;
    }

    private FilenameFilter getRootFilter() {
        if (sarRootFilenameFiler == null) {
            sarRootFilenameFiler = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.endsWith(".jpr") && !name.endsWith(".ear") && !name.endsWith(".zip") && !name.endsWith(".war") && !name.endsWith(".jws") && !name.equals("classes") && !name.equals("deploy") && !name.equals("dist") && !name.equals(".designer") && !name.equals(".adf");
                }
            };
        }
        return sarRootFilenameFiler;
    }

    private String getCompositePath(@NotNull MdProject<?> mdProject) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/ScacDeploymentService.getCompositePath must not be null");
        }
        return DeploymentServiceUtils.getTempFolderForProject(this.tmpDirectory, mdProject).getAbsolutePath() + "/" + "composite.xml";
    }

    private DeploymentResult checkResponse(int respCode, String errorMsg) {
        DeploymentResult result = new DeploymentResult();
        if (respCode != 200) {
            if (respCode == 500) {
                if (errorMsg != null) {
                    throw new BuildException(errorMsg);
                }
                throw new BuildException("Error occured on server, check server log.");
            }
            if (respCode == -1) {
                throw new BuildException("Connection to the server timed out. Check server log for problems or increase the timeout value");
            }
            if (respCode == 2000) {
                throw new BuildException("The server is not hosting the SOA Platform. Please make sure to send the deployment request to a managed server to which the SOA Platform is deployed.");
            }
            throw new BuildException("Problem in sending HTTP request to the server. Check standard HTTP response code for " + respCode);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSystemPropsFromFile(CompositeServletClientBase client, String m_sysPropFile) {
        block7: {
            if (m_sysPropFile == null) break block7;
            File syspropFile = new File(m_sysPropFile);
            if (!syspropFile.exists()) {
                System.out.println("WARNING: system property file " + syspropFile.getAbsolutePath() + " doesn't exist");
                return;
            }
            Properties props = new Properties();
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(syspropFile);
                props.load(fin);
            }
            catch (Exception ex) {
                try {
                    System.out.println("WARNING: error in reading system property file -" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    StreamUtils.close((Closeable[])new Closeable[]{fin});
                    throw throwable;
                }
                StreamUtils.close((Closeable[])new Closeable[]{fin});
            }
            StreamUtils.close((Closeable[])new Closeable[]{fin});
            if (!props.isEmpty()) {
                for (String prop : props.stringPropertyNames()) {
                    String value = props.getProperty(prop);
                    if (value == null) continue;
                    client.setProperty(prop, value);
                }
            }
        }
    }
}

