/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.deployment.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;
import oracle.bpm.deployment.DeploymentResult;
import oracle.bpm.deployment.impl.AntDeploymentService;
import oracle.bpm.deployment.util.DeploymentServiceUtils;
import oracle.bpm.deployment.util.ant.AntExecutor;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.msg.MetadataMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.FileUtils;
import org.jetbrains.annotations.NotNull;

public class DeploymentServiceAntExecutor {
    final Pattern deployErrorPattern;
    private AntExecutor antExecutor;
    private File antScaDirectory;
    private File tmpDirectory;
    private static final String INVALID_USER_PRIVILEGE = "doesnt have the privilege of deploying/undeploying composites";
    private static final String REVISION_ID_SCAC_ERROR = "Composite with same revision ID already exists";
    private static final String ANT_SCA_DEPLOY = "ant-sca-deploy.xml";
    private static final String ANT_SCA_PACKAGE = "ant-sca-package.xml";
    private static final String ANT_SCA_COMPILE = "ant-sca-compile.xml";
    private static final String REPLACE_CLASS_ORIGINAL = "oracle.integration.platform.blocks.deploy.servlet.client.ant.ReplaceRevisionTask\">\\n[\\s]*<classpath>";
    private static final String REPLACE_CLASS_NEW = "oracle.bpm.deployment.util.ant.PMLReplaceRevisionTask";
    private static final String REPLACE_CLASS_SEARCH = "oracle.bpm.deployment.util.ant.PMLReplaceRevisionTask\">\n<classpath>\n<pathelement location=";
    private static final String JAR_FILE = "oracle.bpm.pml.sca.jar";
    private static final String REGEX_DEPLOYMENT_ERROR = "(Error during deployment: )(.*)";

    public DeploymentServiceAntExecutor(@NotNull File tmpDirectory, @NotNull File antScaDirectory, @NotNull File antDirectory) {
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.<init> must not be null");
        }
        if (antScaDirectory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.<init> must not be null");
        }
        if (antDirectory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.<init> must not be null");
        }
        this.tmpDirectory = tmpDirectory;
        this.antScaDirectory = antScaDirectory;
        this.antExecutor = new AntExecutor(antDirectory);
        this.deployErrorPattern = Pattern.compile(REGEX_DEPLOYMENT_ERROR);
    }

    public DeploymentResult createPartition(@NotNull URL serverURL, @NotNull String user, @NotNull String password, @NotNull String partition) {
        if (serverURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.createPartition must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.createPartition must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.createPartition must not be null");
        }
        if (partition == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.createPartition must not be null");
        }
        Map<String, String> args = this.getPartitionArgumentExecution(serverURL, user, password, partition);
        return this.invokeTask("createPartition", args);
    }

    public DeploymentResult deletePartition(@NotNull URL serverURL, @NotNull String user, @NotNull String password, @NotNull String partition) {
        if (serverURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.deletePartition must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.deletePartition must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.deletePartition must not be null");
        }
        if (partition == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.deletePartition must not be null");
        }
        Map<String, String> args = this.getPartitionArgumentExecution(serverURL, user, password, partition);
        return this.invokeTask("deletePartition", args);
    }

    public DeploymentResult packageTask(@NotNull MdProject mdProject, @NotNull Map<String, String> args) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.packageTask must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.packageTask must not be null");
        }
        return this.invokeTask(mdProject, "package", args);
    }

    public DeploymentResult deployTask(@NotNull MdProject mdProject, @NotNull Map<String, String> args) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.deployTask must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.deployTask must not be null");
        }
        return this.invokeTask(mdProject, "deploy", args);
    }

    public DeploymentResult deploymentPlanTask(@NotNull MdProject mdProject, @NotNull Map<String, String> args) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.deploymentPlanTask must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.deploymentPlanTask must not be null");
        }
        return this.invokeTask(mdProject, "generateplan", args);
    }

    private DeploymentResult invokeTask(@NotNull String action, @NotNull Map<String, String> args) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.invokeTask must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.invokeTask must not be null");
        }
        File scacBuildFile = new File(this.antScaDirectory, "ant-sca-mgmt.xml");
        DeploymentResult result = null;
        try {
            this.antExecutor.invoke(scacBuildFile, action, args);
        }
        catch (Exception e) {
            result = new DeploymentResult(DeploymentResult.DeploymentFaultType.DEPLOYMENT);
            result.addFault(e);
        }
        if (result == null) {
            result = new DeploymentResult();
        }
        return result;
    }

    private Map<String, String> getPartitionArgumentExecution(URL serverURL, String user, String password, String partition) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("user", user);
        args.put("password", password);
        args.put("host", serverURL.getHost());
        args.put("port", Integer.toString(serverURL.getPort()));
        args.put("partition", partition);
        return args;
    }

    private DeploymentResult invokeTask(@NotNull MdProject mdProject, @NotNull String task, @NotNull Map<String, String> args) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.invokeTask must not be null");
        }
        if (task == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.invokeTask must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/impl/DeploymentServiceAntExecutor.invokeTask must not be null");
        }
        File outputFile = DeploymentServiceUtils.getCompileOutput(this.tmpDirectory, mdProject);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        args.put("scac.output", outputFile.getAbsolutePath());
        DeploymentResult result = null;
        try {
            File scacBuildFile;
            if (task.equals("deploy")) {
                scacBuildFile = new File(this.antScaDirectory, ANT_SCA_DEPLOY);
            } else if (task.equals("generateplan")) {
                scacBuildFile = new File(this.antScaDirectory, ANT_SCA_COMPILE);
            } else {
                scacBuildFile = this.replaceAntTask();
                args.put("basedir", this.antScaDirectory.getAbsolutePath());
            }
            this.antExecutor.invoke(scacBuildFile, task, args);
            result = DeploymentResult.parseCompileOutput(outputFile, null);
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException();
            exception.getMessage();
            String message = exception.getMessage();
            Msg deployMessage = null;
            if (message != null && message.length() > 0) {
                Matcher matcher = this.deployErrorPattern.matcher(message);
                if (matcher.find() && matcher.groupCount() == 2) {
                    message = matcher.group(2);
                    result = message.contains(REVISION_ID_SCAC_ERROR) ? new DeploymentResult(DeploymentResult.DeploymentFaultType.CONFIGURATION, (Msg)MetadataMsg.DEPLOYMENT_REVISION_ERROR) : new DeploymentResult(DeploymentResult.DeploymentFaultType.CONFIGURATION, Msg.QUOTE((String)message));
                } else if (message.contains(INVALID_USER_PRIVILEGE)) {
                    result = new DeploymentResult(DeploymentResult.DeploymentFaultType.CONFIGURATION, (Msg)MetadataMsg.DEPLOYMENT_INVALID_USER_ROLE);
                }
            }
            if (result == null && (result = DeploymentResult.parseCompileOutput(outputFile, null)).isSuccessful()) {
                result = new DeploymentResult(DeploymentResult.DeploymentFaultType.DEPLOYMENT, deployMessage);
            }
            result.addFault(e);
        }
        catch (Exception e) {
            result = new DeploymentResult(DeploymentResult.DeploymentFaultType.DEPLOYMENT);
            result.addFault(e);
        }
        if (result == null) {
            result = new DeploymentResult();
        }
        return result;
    }

    private File replaceAntTask() throws IOException {
        String jarFile = this.tmpDirectory.getAbsolutePath() + File.separator + JAR_FILE;
        this.createJar(jarFile, REPLACE_CLASS_NEW);
        File file = new File(this.antScaDirectory, ANT_SCA_PACKAGE);
        String contents = FileUtils.readUTF8File(file);
        String baseDir = this.antScaDirectory.getAbsolutePath().replaceAll("\\\\", "/");
        contents = contents.replaceFirst("basedir=\".\"", "basedir=\"" + baseDir + "\"");
        String replace = "oracle.bpm.deployment.util.ant.PMLReplaceRevisionTask\">\n<classpath>\n<pathelement location=\"" + jarFile + "\"/>";
        replace = replace.replaceAll("\\\\", "/");
        contents = contents.replaceFirst(REPLACE_CLASS_ORIGINAL, replace);
        File replacedFile = new File(this.tmpDirectory, ANT_SCA_PACKAGE);
        FileUtils.writeString(replacedFile, contents);
        return replacedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJar(String jarFile, String className) throws IOException {
        InputStream in = null;
        ZipOutputStream target = null;
        try {
            int count;
            className = className.replace(".", "/");
            in = AntDeploymentService.class.getClassLoader().getResourceAsStream(className + ".clazz");
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            target = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
            JarEntry entry = new JarEntry(className + ".class");
            ((JarOutputStream)target).putNextEntry(entry);
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
            target.closeEntry();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (target != null) {
                target.close();
            }
        }
    }
}

