/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.deployment.impl;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import oracle.bpm.deployment.DbInfo;
import oracle.bpm.deployment.DeploymentResult;
import oracle.bpm.deployment.DeploymentService;
import oracle.bpm.deployment.impl.DeploymentServiceAntExecutor;
import oracle.bpm.deployment.util.DeploymentServiceUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.pml.service.impl.DeploymentPlanResult;
import oracle.bpm.project.catalog.composite.CompositeAccessorFactory;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntDeploymentService
implements DeploymentService {
    private DeploymentServiceAntExecutor deploymentAntExecutor;
    private final File oracleHome;
    private URL soaSharedBundle;
    private File tmpDirectory;

    public AntDeploymentService(@NotNull File tmpDirectory, @NotNull File antScaDirectory, @NotNull File antDirectory, @NotNull URL soaSharedBundle) {
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.<init> must not be null");
        }
        if (antScaDirectory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.<init> must not be null");
        }
        if (antDirectory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.<init> must not be null");
        }
        if (soaSharedBundle == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.<init> must not be null");
        }
        this.tmpDirectory = tmpDirectory;
        this.deploymentAntExecutor = new DeploymentServiceAntExecutor(tmpDirectory, antScaDirectory, antDirectory);
        this.soaSharedBundle = soaSharedBundle;
        this.oracleHome = new File(antScaDirectory, "../");
    }

    @Override
    public DeploymentResult generateSarFile(@NotNull MdProject<?> mdProject, @NotNull String version, @Nullable DbInfo dbInfo) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.generateSarFile must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.generateSarFile must not be null");
        }
        DeploymentResult result = this.validateProject(mdProject);
        if (result.isSuccessful() && (result = DeploymentServiceUtils.copyProjectToTempFolder(this.tmpDirectory, this.soaSharedBundle, mdProject, dbInfo)).isSuccessful()) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("oracle.home", this.oracleHome.getAbsolutePath());
            args.put("compositeDir", DeploymentServiceUtils.getTempFolderForProject(this.tmpDirectory, mdProject).getAbsolutePath());
            args.put("compositeName", mdProject.getName());
            args.put("revision", version);
            result = this.deploymentAntExecutor.packageTask(mdProject, args);
        }
        return result;
    }

    @Override
    public DeploymentPlanResult generateDeploymentPlan(@NotNull MdProject<?> mdProject) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.generateDeploymentPlan must not be null");
        }
        return DeploymentServiceUtils.generateDeploymentPlan(this.deploymentAntExecutor, this.tmpDirectory, this.soaSharedBundle, mdProject);
    }

    @Override
    public DeploymentResult createPartition(@NotNull URL serverURL, @NotNull String user, @NotNull String password, @NotNull String partition) {
        if (serverURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.createPartition must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.createPartition must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.createPartition must not be null");
        }
        if (partition == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.createPartition must not be null");
        }
        return this.deploymentAntExecutor.createPartition(serverURL, user, password, partition);
    }

    @Override
    public DeploymentResult deletePartition(@NotNull URL serverURL, @NotNull String user, @NotNull String password, @NotNull String partition) {
        if (serverURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.deletePartition must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.deletePartition must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.deletePartition must not be null");
        }
        if (partition == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.deletePartition must not be null");
        }
        return this.deploymentAntExecutor.deletePartition(serverURL, user, password, partition);
    }

    @Override
    public DeploymentResult deploy(@NotNull URL serverURL, @NotNull String user, @NotNull String password, @NotNull MdProject<?> project, @NotNull String version, boolean overwrite, boolean forceDefault, @Nullable File deploymentPlan, @Nullable InputStream sysProp, @Nullable String partition, @Nullable DbInfo dbInfo) {
        if (serverURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.deploy must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.deploy must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.deploy must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.deploy must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.deploy must not be null");
        }
        DeploymentResult result = DeploymentServiceUtils.validateDeploymentUser(serverURL, user, password);
        if (result.isSuccessful() && (result = this.generateSarFile(project, version, dbInfo)).isSuccessful()) {
            File sarFile = this.getSarFile(project, version);
            HashMap<String, String> args = new HashMap<String, String>();
            String beaHomeFolder = new File(this.oracleHome, "../").getAbsolutePath();
            args.put("bea.home", beaHomeFolder);
            args.put("oracle.home", this.oracleHome.getAbsolutePath());
            args.put("serverURL", serverURL.toString());
            args.put("user", user);
            args.put("password", password);
            args.put("sarLocation", sarFile.getAbsolutePath());
            args.put("overwrite", Boolean.toString(overwrite));
            args.put("forceDefault", Boolean.toString(forceDefault));
            args.put("failOnError", Boolean.TRUE.toString());
            if (deploymentPlan != null) {
                args.put("configPlan", deploymentPlan.getAbsolutePath());
            }
            if (partition != null) {
                String partitionPar = partition;
                if (partitionPar.startsWith("/") && partitionPar.length() > 1) {
                    partitionPar = partitionPar.substring(1);
                }
                args.put("partition", partitionPar);
            }
            if (sysProp != null) {
                File sysPropFileFile = new File(sarFile, "sysPropsTemp.xml");
                FileUtils.fileCopy(sysProp, sysPropFileFile);
                args.put("sysPropFile", sysPropFileFile.getAbsolutePath());
            }
            result = this.deploymentAntExecutor.deployTask(project, args);
        }
        return result;
    }

    @Override
    public File getSarFile(@NotNull MdProject<?> project, @NotNull String version) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.getSarFile must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.getSarFile must not be null");
        }
        return DeploymentServiceUtils.getSarFile(this.tmpDirectory, project, version);
    }

    private DeploymentResult validateProject(@NotNull MdProject<?> mdProject) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/impl/AntDeploymentService.validateProject must not be null");
        }
        DeploymentResult result = new DeploymentResult();
        try {
            Process process;
            VFile file;
            Project project = mdProject.getProject().get();
            Collection processes = project.getProcesses();
            ProjectLoader loader = project.getLoader();
            assert (loader != null);
            ProjectFileSystem fileSystem = loader.getProjectFileSystem();
            VFileSystem vFileSystem = fileSystem.getDataFileSystem();
            if (!processes.isEmpty() && (file = vFileSystem.createFile((process = (Process)processes.iterator().next()).getId() + ".wsdl")).exists()) {
                CompositeAccessorFactory.createCompositeUpdater((Process)process).updateComposite();
            }
        }
        catch (MetadataException e) {
            result = new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION);
            result.addFault(e);
        }
        return result;
    }
}

