/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.deployment;

import java.util.EnumMap;
import javax.xml.namespace.QName;
import org.jetbrains.annotations.NotNull;

public final class DeploymentFault {
    private Throwable exception;
    private EnumMap<FaultTag, String> values;

    DeploymentFault() {
        this.values = new EnumMap(FaultTag.class);
        this.setFaultValue(FaultTag.SEVERITY, SeverityType.ERROR.name());
    }

    DeploymentFault(@NotNull Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/DeploymentFault.<init> must not be null");
        }
        this();
        this.setException(exception);
    }

    public EnumMap<FaultTag, String> getFaults() {
        return this.values;
    }

    public void setFaultValue(@NotNull FaultTag fault, @NotNull String value) {
        if (fault == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/DeploymentFault.setFaultValue must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/deployment/DeploymentFault.setFaultValue must not be null");
        }
        this.values.put(fault, value);
    }

    public void setException(@NotNull Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/DeploymentFault.setException must not be null");
        }
        this.exception = exception;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getFaultValue(@NotNull FaultTag fault) {
        if (fault == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/DeploymentFault.getFaultValue must not be null");
        }
        return this.values.get((Object)fault);
    }

    public boolean isWarning() {
        String severity = this.values.get((Object)FaultTag.SEVERITY);
        return SeverityType.WARNING.name().equals(severity);
    }

    public boolean isError() {
        String severity = this.values.get((Object)FaultTag.SEVERITY);
        return SeverityType.ERROR.name().equals(severity);
    }

    public boolean isFatal() {
        String severity = this.values.get((Object)FaultTag.SEVERITY);
        return SeverityType.FATAL_ERROR.name().equals(severity);
    }

    public SeverityType getSeverity() {
        String severity = this.values.get((Object)FaultTag.SEVERITY);
        return SeverityType.valueOf(severity);
    }

    public boolean shouldFail() {
        return this.isFatal() || this.isError();
    }

    public String toString() {
        String result = "Fault severity: " + this.values.get((Object)FaultTag.SEVERITY) + " should fail: " + this.shouldFail() + "\n";
        Throwable exception = this.getException();
        if (exception == null) {
            EnumMap<FaultTag, String> values = this.getFaults();
            for (FaultTag faultTag : values.keySet()) {
                result = result + "  " + (Object)((Object)faultTag) + "= " + values.get((Object)faultTag) + "\n";
            }
        } else {
            result = result + exception + "\n";
        }
        return result;
    }

    public static enum SeverityType {
        FATAL_ERROR,
        ERROR,
        WARNING,
        INFO;

    }

    public static enum FaultTag {
        SEVERITY(new QName("severity")),
        LOCATION(new QName("loc")),
        LINE(new QName("line")),
        COLUMN(new QName("col")),
        FILE(new QName("file")),
        MESSAGE(new QName("msg"));

        private QName tagName;

        private FaultTag(QName name) {
            if (string == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/DeploymentFault$FaultTag.<init> must not be null");
            }
            this.tagName = name;
        }

        QName getTagName() {
            return this.tagName;
        }

        public static FaultTag valueOfId(@NotNull QName name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/deployment/DeploymentFault$FaultTag.valueOfId must not be null");
            }
            FaultTag result = null;
            for (FaultTag tag : FaultTag.values()) {
                if (!tag.getTagName().equals(name)) continue;
                result = tag;
                break;
            }
            return result;
        }
    }
}

