/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleTableSort;
import fuego.fuegoui.samples.TableSortData;
import java.text.DateFormatSymbols;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.table.ProviderTableModel;

public class SortTableModel
extends ProviderTableModel<TableSortData> {
    static final MsgList TITLES = MsgList.create(Msg.QUOTE("Employees"), Msg.QUOTE("age"));
    static final int COLUMN_SIMPLE_CLASS = 0;

    public SortTableModel() {
        super(TITLES);
        this.populate(SortTableModel.getTableData());
    }

    @Override
    public void addRow(TableSortData object) {
        this.insertRow(this.getRowCount(), object);
    }

    @Override
    public void insertRow(int row, TableSortData object) {
        this.getData().add(row, object);
        this.fireTableRowsInserted(row, row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        TableSortData data = (TableSortData)this.getRow(row);
        switch (column) {
            case 0: {
                return data.getCustomValue();
            }
            case 1: {
                return row % 2 == 0 ? 1 : 2;
            }
        }
        return "";
    }

    @Override
    public Class getColumnClass(int column) {
        if (column == 0) {
            return SampleTableSort.SimpleClass.class;
        }
        return Integer.class;
    }

    static TableSortData[] getTableData() {
        DateFormatSymbols df = new DateFormatSymbols();
        String[] months = df.getMonths();
        SampleTableSort.SimpleClass[] employees = new SampleTableSort.SimpleClass[months.length];
        String[] names = new String[]{"Jonh", "Peter", "Daniel", "Christopher", "Wayne", "Caroline", "Emily", "Freddy", "Susan", "Patrice", "Tupac", "Paul"};
        for (int i = 0; i < months.length - 1; ++i) {
            SampleTableSort.SimpleClass employee;
            employees[i] = employee = new SampleTableSort.SimpleClass(21 + i, names[i]);
        }
        TableSortData[] data = new TableSortData[months.length - 1];
        for (int i = 0; i < months.length - 1; ++i) {
            data[i] = TableSortData.create(employees[i]);
        }
        return data;
    }

    private void populate(TableSortData[] data) {
        for (TableSortData aData : data) {
            this.insertRow(aData);
        }
    }

    private void insertRow(TableSortData data) {
        this.addRow(data);
    }
}

