/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import java.util.ArrayList;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextField;

class SampleToolbar
extends SampleBase {
    public SampleToolbar() {
        super("Simple ToolBar");
    }

    public static SampleToolbar create() {
        return new SampleToolbar();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout(new FlowLayout(0));
        panel.add(this.buildStandardToolBar(panel));
        panel.add(this.buildComponentToolBar(panel));
        panel.add(Label.create((UiContainer)panel, Msg.QUOTE("Debajo de este label tiene que haber un toolbar")));
        panel.add(this.buildButtonsToolBar(panel));
        panel.add(Label.create((UiContainer)panel, Msg.QUOTE("Arriba de este label tiene que haber un toolbar")));
        return panel;
    }

    private static MsgList getSeverityList() {
        return MsgList.create(UIMsg.DEBUG, UIMsg.INFO, UIMsg.WARNING, UIMsg.SEVERE, UIMsg.FATAL);
    }

    private ToolBar buildStandardToolBar(UiContainer parent) {
        ToolBar toolBar = new ToolBar(parent);
        toolBar.add(Label.create((UiContainer)toolBar, UIMsg.TO_MSG("Button->")));
        toolBar.add(Actions.ADD);
        toolBar.add(Actions.REMOVE);
        Actions.ADD_GRAYED.setSmallIcon(Image.create(UIMsg.ADD).getGrayed());
        toolBar.add(Actions.ADD_GRAYED);
        Actions.REMOVE_ROTATE.setSmallIcon(Image.create(UIMsg.REMOVE).rotate90cc());
        toolBar.add(Actions.REMOVE_ROTATE);
        toolBar.addSeparator();
        toolBar.add(Label.create((UiContainer)toolBar, UIMsg.TO_MSG("Check->")));
        toolBar.addToggleButton(Actions.ADD);
        ToolBarItem toggleButtonItem = toolBar.addToggleButton(Actions.REMOVE);
        toggleButtonItem.setSelected(true);
        toolBar.addSeparator();
        toolBar.add(Label.create((UiContainer)toolBar, UIMsg.TO_MSG("Radio->")));
        toolBar.addRadioButton(Actions.ADD);
        ToolBarItem radioButtionItem = toolBar.addRadioButton(Actions.REMOVE);
        radioButtionItem.setSelected(true);
        toolBar.addSeparator();
        toolBar.add(Label.create((UiContainer)toolBar, UIMsg.TO_MSG("Radio2->")));
        toolBar.addRadioButton(Actions.ADD);
        toolBar.addRadioButton(Actions.REMOVE);
        toolBar.addSeparator();
        toolBar.add(Label.create((UiContainer)toolBar, UIMsg.TO_MSG("CompositeButton->")));
        toolBar.addCompositeButton(Actions.ADD, Actions.DROP_DOWN);
        return toolBar;
    }

    private ToolBar buildButtonsToolBar(UiContainer parent) {
        ToolBar toolBar = new ToolBar(parent);
        toolBar.add(Label.create((UiContainer)toolBar, UIMsg.TO_MSG("Label1")));
        toolBar.add(new Button((UiContainer)toolBar, Actions.ADD, 2));
        toolBar.add(Label.create((UiContainer)toolBar, UIMsg.TO_MSG("Label2")));
        return toolBar;
    }

    private ToolBar buildComponentToolBar(UiContainer parent) {
        ToolBar toolBar = new ToolBar(parent);
        toolBar.add(Label.create((UiContainer)toolBar, UIMsg.TO_MSG("Test ->")));
        final ToolBarItem buttonItem = toolBar.add(Actions.ADD);
        BaseAction testAction = new BaseAction(UIMsg.TO_MSG("Change Text")){

            @Override
            public void run() {
                buttonItem.setText(buttonItem.getText() + "A");
            }
        };
        toolBar.add(testAction, 1);
        toolBar.addSeparator();
        toolBar.add(Label.create((UiContainer)toolBar, UIMsg.TO_MSG("TextField->")));
        TextField txtFld = new TextField(toolBar);
        txtFld.setColumns(5);
        toolBar.add(txtFld);
        toolBar.add(Label.create((UiContainer)toolBar, UIMsg.TO_MSG("NumericField->")));
        toolBar.add(NumericField.createIntegerNumericField(toolBar));
        toolBar.addSeparator();
        toolBar.add(Label.create((UiContainer)toolBar, UIMsg.TO_MSG("Panel->")));
        Panel panel = new Panel(toolBar);
        panel.setBackground(Color.RED);
        panel.setMaximumSize(Dimension.valueOf(10, 10));
        toolBar.add(panel);
        toolBar.addSeparator();
        toolBar.add(Label.create((UiContainer)toolBar, UIMsg.TO_MSG("Dynamic Panel->")));
        toolBar.add(this.buildDynamicPanel(toolBar));
        return toolBar;
    }

    private Panel buildDynamicPanel(UiContainer parent) {
        Panel mainPanel = new Panel(parent);
        mainPanel.setLayout(new FlowLayout(0));
        mainPanel.setBackground(Color.GREEN);
        ArrayList<String> items = new ArrayList<String>();
        items.add("Text");
        items.add("Combo");
        items.add("Spinner");
        ComboBox combo = UiFactory.createMutableComboBox(mainPanel, items);
        final Panel panel = new Panel(mainPanel);
        panel.setBackground(Color.BLUE);
        final CardLayout layout = new CardLayout();
        panel.setLayout(layout);
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ComboBox source = (ComboBox)e.getSource();
                System.out.println("SampleToolbar.buildDynamicPanel() Change Card Layout");
                switch (source.getSelectedIndex()) {
                    case 0: {
                        layout.show(panel, "text");
                        break;
                    }
                    case 1: {
                        layout.show(panel, "combo");
                        break;
                    }
                    case 2: {
                        layout.show(panel, "spinner");
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid option");
                    }
                }
            }
        });
        combo.setSelectedIndex(1);
        TextField text = new TextField(panel);
        text.setColumns(25);
        ComboBox<Msg> choiceSeverity = UiFactory.createComboBox((UiContainer)panel, SampleToolbar.getSeverityList());
        NumericField<Integer> numSpinner = NumericField.createIntegerNumericField(panel);
        numSpinner.setRange(1, 10);
        numSpinner.setValue(1);
        numSpinner.setStepSize(1);
        panel.add(text, "text");
        panel.add(choiceSeverity, "combo");
        panel.add(numSpinner, "spinner");
        mainPanel.add(combo);
        mainPanel.add(panel);
        return mainPanel;
    }

    private static class Actions {
        public static final BaseAction ADD = new BaseAction(UIMsg.ADD){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("SampleToolBar.Action ADD source=" + event.getSource().getClass());
            }
        };
        public static final BaseAction ADD_GRAYED = new BaseAction(UIMsg.ADD){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("SampleToolBar.Action ADD_GRAYED source=" + event.getSource().getClass());
            }
        };
        public static final BaseAction REMOVE = new BaseAction(UIMsg.REMOVE){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("SampleToolBar.Action REMOVE source=" + event.getSource().getClass());
            }
        };
        public static final BaseAction REMOVE_ROTATE = new BaseAction(UIMsg.REMOVE){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("SampleToolBar.Action REMOVE_ROTATE source=" + event.getSource().getClass());
            }
        };
        public static final BaseAction DROP_DOWN = new BaseAction(UIMsg.NEW){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("SampleToolBar.Action DROP_DOWN source=" + e.getSource().getClass());
                UiComponent source = e.getSource();
                PopupMenu popup = new PopupMenu(source.getParent());
                popup.add("Item 1");
                popup.add("Item 2");
                popup.add("Item 3");
                popup.show(source, 0, source.getHeight());
            }
        };

        private Actions() {
        }
    }
}

