/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import fuego.fuegoui.samples.SortTableModel;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.AutoResizeMode;
import oracle.bpm.ui.table.Table;

public class SampleTableSort
extends SampleBase {
    private SampleTableSort() {
        super("Table with sort");
    }

    public static SampleTableSort create() {
        return new SampleTableSort();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel mainPanel = new Panel(parent);
        mainPanel.setLayout(new BorderLayout());
        SortTableModel sampleModel = new SortTableModel();
        final Table table = new Table((UiContainer)mainPanel, sampleModel);
        table.setAutoResizeMode(AutoResizeMode.OFF);
        table.setRowHeight(20);
        table.getColumn(1).setImage(Image.create(UIMsg.NEW));
        final CheckBox sort = CheckBox.create(mainPanel, UIMsg.TO_MSG("Sortable Table"), false);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                table.setAutoCreateRowSorter(sort.isSelected());
                table.revalidate();
            }
        };
        sort.addActionListener(actionListener);
        mainPanel.add(table, "Center");
        mainPanel.add(sort, "South");
        return mainPanel;
    }

    public static class SimpleClass
    implements Comparable<SimpleClass> {
        private int age;
        private String name;

        public SimpleClass(int val, String nameVal) {
            this.age = val;
            this.name = nameVal;
        }

        public String toString() {
            return this.name + " Edad:" + this.age;
        }

        @Override
        public int compareTo(SimpleClass m1) {
            if (m1.getVal() > this.getVal()) {
                return -1;
            }
            return 1;
        }

        public int getVal() {
            return this.age;
        }
    }
}

