/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import fuego.fuegoui.samples.SampleTableModel;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.EditorListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.AutoResizeMode;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.editors.ComboCellEditor;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.table.renderers.BooleanCheckBoxLabelProvider;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.TimeField;

class SampleTable
extends SampleBase {
    private SampleTable() {
        super("Table");
    }

    public static SampleTable create() {
        return new SampleTable();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        SampleTableModel model = new SampleTableModel(true);
        Table table = new Table(parent, model);
        table.setAutoResizeMode(AutoResizeMode.OFF);
        table.getColumn(5).setLabelProvider(BooleanCheckBoxLabelProvider.getInstance());
        table.getColumn(8).setColorProvider(new MyColorProvider());
        table.getColumn(8).setImage(Image.create(UIMsg.ERROR));
        table.getColumn(8).setFontProvider(new MyFontProvider(table.getFont()));
        table.setDefaultLabelProvider(String.class, new StringDefaultLabelProvider());
        List<String> values = Arrays.asList("Hight", "Medium", "Low");
        table.getColumn(6).setCellEditor(new TimeEditor());
        table.getColumn(7).setCellEditor(new IntervalEditor());
        table.getColumn(10).setCellEditor(new ComboCellEditor<String>(values));
        table.getColumn(11).setCellEditor(new MyCustomCellEditor());
        table.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                System.out.println("SampleTable.ChangeSelection first=" + e.getFirstIndex() + " last=" + e.getLastIndex());
            }
        });
        table.addEditorListener(new EditorListener(){

            @Override
            public void editingStopped() {
                System.out.println("SampleTable.editingStopped");
            }

            @Override
            public void editingStarted() {
                System.out.println("SampleTable.editingStarted");
            }
        });
        return table;
    }

    private static class TimeEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TimeField timeField;

        private TimeEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.timeField.getTime();
        }

        @Override
        public UiComponent getTableCellEditor(Table parent, Object value, boolean isSelected, int row, int column) {
            return this.createEditor(parent, value);
        }

        @Override
        public UiComponent createEditor(UiContainer parent, Object value) {
            this.timeField = new TimeField(parent);
            this.timeField.setTime((Time)value);
            return this.timeField;
        }
    }

    private static class StringDefaultLabelProvider
    extends LabelProvider.Default {
        private StringDefaultLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            return "<<<" + String.valueOf(element) + ">>>";
        }
    }

    private static class MyFontProvider
    implements FontProvider {
        private Font defaultFont;

        MyFontProvider(Font defaultFont) {
            this.defaultFont = defaultFont;
        }

        public Font getFont(Object element) {
            return this.defaultFont.applyStyle(FontStyle.BOLD_ITALIC);
        }
    }

    private static class MyCustomCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private MyCustomCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return "Holaaa Cableado";
        }

        @Override
        public UiComponent getTableCellEditor(Table parent, Object value, boolean isSelected, int row, int column) {
            return this.createEditor(parent, value);
        }

        @Override
        public UiComponent createEditor(UiContainer parent, Object value) {
            Panel panel = new Panel(parent);
            panel.setLayout(new BorderLayout());
            Label label = Label.create((UiContainer)panel, Msg.QUOTE("Hola"));
            Button button = new Button((UiContainer)panel, UIMsg.TO_MSG("..."));
            ComboBox<Object> combo = UiFactory.createComboBox((UiContainer)panel, "1", "2", "4");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MessageDialog.showNotice(UIMsg.TO_MSG("MyDialogCellEditor.getEditor() SII ANDA !!!!"));
                }
            });
            panel.add(label, "West");
            panel.add(combo, "Center");
            button.setMaximumSize(Dimension.valueOf(10, 10));
            panel.add(button, "East");
            return panel;
        }
    }

    private static class MyComboEditor<E>
    extends AbstractCellEditor
    implements TableCellEditor {
        private ComboBox<E> comboBox;
        private List<E> values;

        MyComboEditor(List<E> values) {
            this.values = values;
        }

        public E getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        @Override
        public UiComponent getTableCellEditor(Table parent, Object value, boolean isSelected, int row, int column) {
            return this.createEditor(parent, value);
        }

        @Override
        public UiComponent createEditor(UiContainer parent, Object value) {
            Panel panel = new Panel(parent);
            panel.setLayout(new BorderLayout());
            this.comboBox = UiFactory.createComboBox((UiContainer)panel, this.values);
            panel.add(this.comboBox, "Center");
            this.comboBox.setSelectedItem(value);
            return panel;
        }
    }

    private static class MyColorProvider
    implements ColorProvider {
        private MyColorProvider() {
        }

        public Color getBackground(Object element) {
            if (element instanceof Color) {
                return (Color)element;
            }
            return null;
        }

        public Color getForeground(Object element) {
            Color color;
            if (element instanceof Color && (color = (Color)element).getRed() % 32 == 0) {
                return Color.WHITE;
            }
            return null;
        }
    }

    private static class IntervalEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private IntervalField intervalField;

        private IntervalEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.intervalField.getInterval();
        }

        @Override
        public UiComponent getTableCellEditor(Table parent, Object value, boolean isSelected, int row, int column) {
            return this.createEditor(parent, value);
        }

        @Override
        public UiComponent createEditor(UiContainer parent, Object value) {
            this.intervalField = new IntervalField(parent);
            this.intervalField.setInterval((Interval)value);
            return this.intervalField;
        }
    }
}

