/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import fuego.fuegoui.samples.SampleTable;
import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextArea;

public class SampleTabbedPane
extends SampleBase {
    private SampleTabbedPane() {
        super("TabbedPane");
    }

    public static SampleTabbedPane create() {
        return new SampleTabbedPane();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout(new BorderLayout());
        panel.add(this.buildTabbedPane(panel), "North");
        panel.add(this.buildTabbedPane2(panel), "Center");
        return panel;
    }

    private TabbedPane buildTabbedPane(UiContainer parent) {
        TabbedPane tabbedPane = new TabbedPane(parent);
        TextArea ta = new TextArea(tabbedPane);
        ta.setColumns(40);
        ta.setRows(5);
        tabbedPane.addTab(UIMsg.TO_MSG("My Tab"), (UiComponent)ta);
        tabbedPane.addTab(UIMsg.TO_MSG("My Label"), (UiComponent)Label.create((UiContainer)tabbedPane, Msg.QUOTE("Hola")));
        return tabbedPane;
    }

    private TabbedPane buildTabbedPane2(UiContainer parent) {
        TabbedPane tabbedPane = new TabbedPane(parent);
        TabbedPane tabbedPane2 = new TabbedPane(tabbedPane);
        SampleTable table = SampleTable.create();
        TextArea ta = new TextArea(tabbedPane2);
        ta.setText("This is a textArea");
        ta.setColumns(40);
        ta.setRows(5);
        SplitPane splitPane = new SplitPane(tabbedPane2);
        splitPane.setOneTouchExpandable(true);
        Panel redPanel = new Panel(splitPane, UIMsg.TO_MSG("RED"));
        redPanel.setBackground(Color.RED);
        splitPane.setLeftComponent(redPanel);
        Panel rightPanel = new Panel(splitPane, UIMsg.TO_MSG("The Big Table"));
        rightPanel.setLayout(new BorderLayout());
        rightPanel.add(table.buildEditorPanel(rightPanel), "Center");
        splitPane.setRightComponent(rightPanel);
        splitPane.setResizeWeight(0.25);
        tabbedPane2.addTab(UIMsg.TO_MSG("TextArea"), (UiComponent)ta);
        tabbedPane2.addTab(UIMsg.TO_MSG("ComplexTable"), (UiComponent)splitPane);
        TextArea ta2 = new TextArea(tabbedPane);
        ta.setColumns(40);
        ta.setRows(5);
        tabbedPane.addTab(UIMsg.TO_MSG("My Tab"), (UiComponent)ta2);
        tabbedPane.addTab(UIMsg.TO_MSG("My Label"), (UiComponent)tabbedPane2);
        return tabbedPane;
    }
}

