/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import oracle.bpm.draw.Color;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;

public class SampleScrollPane
extends SampleBase {
    SampleScrollPane() {
        super("ScrollPane");
    }

    public static SampleScrollPane create() {
        return new SampleScrollPane();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        final ScrollPane scrollPane = new ScrollPane(parent);
        Panel mainPanel = new Panel(scrollPane);
        mainPanel.setLayout(new BorderLayout());
        scrollPane.setView(mainPanel);
        mainPanel.setBackground(Color.RED);
        mainPanel.setName("MainPanel");
        final Panel centerPanel = new Panel(mainPanel);
        centerPanel.setName("CenterPanel");
        Panel actionPanel = new Panel(mainPanel);
        BaseAction buildAction = new BaseAction(UIMsg.TO_MSG("Create")){

            @Override
            public void run() {
                SampleScrollPane.this.build(centerPanel);
                scrollPane.revalidate();
            }
        };
        BaseAction clearAction = new BaseAction(UIMsg.TO_MSG("Clear All")){

            @Override
            public void run() {
                centerPanel.removeAll();
                scrollPane.revalidate();
            }
        };
        actionPanel.add(new Button((UiContainer)actionPanel, buildAction));
        actionPanel.add(new Button((UiContainer)actionPanel, clearAction));
        this.build(centerPanel);
        mainPanel.add(actionPanel, "North");
        mainPanel.add(centerPanel, "Center");
        return scrollPane;
    }

    private void build(Panel panel) {
        StandardForm form = FormsFactory.createStandardForm(panel);
        int n = 30;
        for (int i = 1; i <= n; ++i) {
            TextField tf = form.createTextField();
            tf.setText(i + " de " + n);
            form.add(UIMsg.TO_MSG("Name #" + i + ":"), tf);
        }
    }
}

