/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import oracle.bpm.lang.CompOperator;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;

public class SampleRemovePanel1
extends SampleBase {
    private PanelBuilder builder;
    private FormLayout layout;
    private Panel rowsPanel;

    private SampleRemovePanel1() {
        super("Remove Panel (FormLayout)");
    }

    public static SampleRemovePanel1 create() {
        return new SampleRemovePanel1();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        ScrollPane scroll = new ScrollPane(parent);
        Panel mainPanel = new Panel(scroll);
        mainPanel.setLayout(new BorderLayout());
        this.rowsPanel = new Panel(mainPanel);
        this.layout = new FormLayout("pref");
        this.builder = this.layout.createBuilder(this.rowsPanel);
        Button createButton = new Button((UiContainer)mainPanel, UIMsg.TO_MSG("Create Panel"));
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UiComponent panel = SampleRemovePanel1.this.buildInnerPanel(SampleRemovePanel1.this.rowsPanel);
                SampleRemovePanel1.this.addRow(panel);
            }
        });
        Button removeButton = new Button((UiContainer)mainPanel, UIMsg.TO_MSG("Remove Panel"));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<UiComponent> children = SampleRemovePanel1.this.rowsPanel.getChildren();
                if (children.size() > 0) {
                    UiComponent panel = children.get(children.size() - 1);
                    SampleRemovePanel1.this.removeRow(panel);
                }
            }
        });
        mainPanel.add(createButton, "North");
        mainPanel.add(this.rowsPanel, "Center");
        mainPanel.add(removeButton, "South");
        scroll.setView(mainPanel);
        return scroll;
    }

    private void addRow(UiComponent panel) {
        this.layout.appendRow("pref");
        CellConstraints cc = this.layout.createCellConstraints();
        int currentRow = this.layout.getRowCount();
        this.builder.add(panel, cc.xy(1, currentRow));
        this.rowsPanel.revalidate();
    }

    private void removeRow(UiComponent panel) {
        int index = this.layout.getConstraints((UiComponent)panel).gridY;
        this.rowsPanel.remove(panel);
        this.layout.removeRow(index);
        System.out.println("SampleRemovePanel1.removeRow() index=" + index);
        this.rowsPanel.revalidate();
    }

    private UiComponent buildInnerPanel(UiContainer parent) {
        final Panel mainPanel = new Panel(parent);
        String colSpecs = "pref, 5dlu, max(80dlu;pref), 5dlu, left:pref:grow, 5dlu";
        String rowSpecs = "5dlu, pref";
        FormLayout layout = new FormLayout(colSpecs, rowSpecs);
        CellConstraints cc = layout.createCellConstraints();
        PanelBuilder builder = layout.createBuilder(mainPanel);
        BaseAction removeAction = new BaseAction(UIMsg.REMOVE){

            @Override
            public void run() {
                SampleRemovePanel1.this.removeRow(mainPanel);
            }
        };
        builder.add(this.createButton(mainPanel, removeAction), cc.xy(1, 2));
        builder.add((UiComponent)Label.create((UiContainer)mainPanel, Msg.QUOTE("Label...")), cc.xy(3, 2));
        OperatorPanel operatorPanel = new OperatorPanel(mainPanel);
        builder.add((UiComponent)operatorPanel, cc.xy(5, 2));
        return mainPanel;
    }

    private UiComponent createButton(UiContainer parent, BaseAction action) {
        ToolBar toolBar = new ToolBar(parent);
        toolBar.add(action);
        return toolBar;
    }

    private static class OperatorPanel
    extends Panel {
        public OperatorPanel(UiContainer parent) {
            super(parent);
            this.init();
        }

        private void init() {
            EnumSet<CompOperator> comparisons = CompOperator.fromKind(5);
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.isStateSelected()) {
                        // empty if block
                    }
                }
            };
            ComboBox<CompOperator> operatorComboBox = UiFactory.createMutableComboBox(this, new ArrayList<CompOperator>(comparisons));
            operatorComboBox.setSelectedIndex(0);
            operatorComboBox.addItemListener(itemListener);
            String colSpecs = "max(100dlu;pref), 5dlu, pref:grow, 5dlu";
            String rowSpecs = "pref";
            FormLayout layout = new FormLayout(colSpecs, rowSpecs);
            CellConstraints cc = layout.createCellConstraints();
            PanelBuilder builder = layout.createBuilder(this);
            builder.add(operatorComboBox, cc.xy(1, 1));
            builder.add((UiComponent)new TextField(this), cc.xy(3, 1));
        }
    }
}

