/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import java.util.Arrays;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButtonsPanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.msg.UIMsg;

public class SampleRelativeLayout
extends SampleBase {
    private SampleRelativeLayout() {
        super("RelativeLayout");
    }

    public static SampleRelativeLayout create() {
        return new SampleRelativeLayout();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel mainPanel = new Panel(parent);
        RelativeLayout layout = new RelativeLayout();
        mainPanel.setLayout(layout);
        RadioButtonsPanel<UiType> panel = new RadioButtonsPanel<UiType>(mainPanel, Arrays.asList(UiType.values()), true);
        panel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("EnumRadioPanel.itemStateChanged() " + e.getItem());
            }
        });
        CheckBox checkBox = CheckBox.create((UiContainer)mainPanel, UIMsg.USE_CALENDAR_RULES);
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("SampleRelativeLayout.buildEditorPanel() checkbox=" + e.isStateSelected());
            }
        });
        LabelMultiline multi = new LabelMultiline(mainPanel, UIMsg.TO_MSG("Este es un texto largo y demasiado extenso para que aparezca en una sola linea"));
        mainPanel.add(panel, "typePanel");
        mainPanel.add(checkBox, "holidaysCheckBox");
        mainPanel.add(multi, "multi");
        layout.addConstraint("typePanel", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 5));
        layout.addConstraint("typePanel", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 5));
        layout.addConstraint("typePanel", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -5));
        layout.addConstraint("holidaysCheckBox", AttributeType.TOP, new AttributeConstraint("typePanel", AttributeType.BOTTOM, 5));
        layout.addConstraint("holidaysCheckBox", AttributeType.LEFT, new AttributeConstraint("typePanel", AttributeType.LEFT));
        layout.addConstraint("multi", AttributeType.TOP, new AttributeConstraint("holidaysCheckBox", AttributeType.BOTTOM, 5));
        layout.addConstraint("multi", AttributeType.LEFT, new AttributeConstraint("holidaysCheckBox", AttributeType.LEFT));
        return mainPanel;
    }
}

