/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopUpWindow;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.GridLayout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.utils.Layout;

public class SamplePopUpWindows
extends SampleBase {
    SamplePopUpWindows() {
        super("PopUp Windows");
    }

    public static SamplePopUpWindows create() {
        return new SamplePopUpWindows();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        final Button button = new Button(panel);
        button.setText("Press me!");
        Button button2 = new Button((UiContainer)panel, UIMsg.TO_MSG("Press me and you'll get a Tree!"));
        ButtonGroup buttonGroup = new ButtonGroup();
        Panel currentPanel = new Panel(panel);
        currentPanel.setLayout(new GridLayout(2, 0));
        RadioButton checkX = new RadioButton((UiContainer)currentPanel, "x");
        checkX.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    System.out.println("x selected...");
                }
            }
        });
        currentPanel.add(checkX);
        buttonGroup.add(checkX);
        RadioButton checkZ = new RadioButton((UiContainer)currentPanel, "z");
        checkZ.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    System.out.println("z selected...");
                }
            }
        });
        currentPanel.add(checkZ);
        buttonGroup.add(checkZ);
        checkZ.setSelected(true);
        checkX.setSelected(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpWindow popup = new PopUpWindow(button.getOwnerWindow(), false, true);
                popup.add(this.createTree(popup));
                popup.show(button);
            }

            private Panel createTree(UiContainer parent) {
                ButtonGroup buttonGroup = new ButtonGroup();
                Panel currentPanel = new Panel(parent);
                currentPanel.setLayout(new GridLayout(2, 0));
                final RadioButton checkX = new RadioButton((UiContainer)currentPanel, "x");
                checkX.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (checkX.isSelected()) {
                            System.out.println("x selected...");
                        }
                    }
                });
                currentPanel.add(checkX);
                buttonGroup.add(checkX);
                final RadioButton checkZ = new RadioButton((UiContainer)currentPanel, "z");
                checkZ.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (checkZ.isSelected()) {
                            System.out.println("z selected...");
                        }
                    }
                });
                currentPanel.add(checkZ);
                buttonGroup.add(checkZ);
                return currentPanel;
            }
        });
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        RelativeLayout layout = new RelativeLayout();
        panel.setLayout(layout);
        panel.add(button, "windowButton");
        panel.add(button2, "dummyButton");
        panel.add(currentPanel, "currentPanel");
        Layout.fixToRoot(layout, "windowButton", AttributeType.LEFT, 5);
        Layout.fixToRoot(layout, "windowButton", AttributeType.TOP, 5);
        Layout.fixToRoot(layout, "dummyButton", AttributeType.LEFT, 5);
        Layout.fixToComp(layout, "dummyButton", AttributeType.TOP, "windowButton", AttributeType.BOTTOM, 5);
        Layout.fixToRoot(layout, "currentPanel", AttributeType.LEFT, 5);
        Layout.fixToComp(layout, "currentPanel", AttributeType.TOP, "dummyButton", AttributeType.BOTTOM, 5);
        return panel;
    }
}

