/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import java.math.BigDecimal;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.NumericField;

class SampleInputNumber
extends SampleBase {
    private SampleInputNumber() {
        super("Number inputs");
    }

    public static SampleInputNumber create() {
        return new SampleInputNumber();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        StandardForm form = FormsFactory.createStandardForm(panel);
        final NumericField<Integer> numericField0 = NumericField.createIntegerNumericField(panel, true);
        numericField0.setMinimum(1);
        numericField0.setValue(1);
        Label label0 = Label.create((UiContainer)panel, Msg.QUOTE("(Min = " + numericField0.getMinimum() + " Max = " + numericField0.getMaximum() + ")"));
        form.add(UIMsg.TO_MSG("NumericField<Integer>"), numericField0, label0);
        numericField0.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                System.out.println("SampleInputNumber.objectModified() Integer Value=" + numericField0.getValue());
            }
        });
        final NumericField<Integer> numericField = NumericField.createIntegerNumericField(panel, false);
        numericField.setMaximum(10);
        numericField.setMinimum(-10);
        numericField.setStepSize(2);
        numericField.setLength(4);
        Label label = Label.create((UiContainer)panel, Msg.QUOTE("(Min = " + numericField.getMinimum() + " Max = " + numericField.getMaximum() + ")"));
        form.add(UIMsg.TO_MSG("NumericField<Integer>"), numericField, label);
        numericField.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                System.out.println("SampleInputNumber.objectModified() Integer Value=" + numericField.getValue());
            }
        });
        final NumericField<Double> pi = NumericField.createDoubleNumericField(panel);
        pi.setLength(1);
        pi.setScale(5);
        pi.setPattern("#.#####");
        pi.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                System.out.println("SampleInputNumber.objectModified() Double Value=" + pi.getValue());
            }
        });
        Label label1 = Label.create((UiContainer)panel, Msg.QUOTE("(Min = " + pi.getMinimum() + " Max = " + pi.getMaximum() + ")"));
        form.add(UIMsg.TO_MSG("NumericField<Double>"), pi, label1);
        final NumericField<BigDecimal> bd = NumericField.createBigDecimalNumericField(panel);
        bd.setLength(18);
        bd.setScale(5);
        pi.setPattern("#.#####");
        bd.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                System.out.println("SampleInputNumber.objectModified() BigDecimal Value=" + bd.getValue());
            }
        });
        Label label2 = Label.create((UiContainer)panel, Msg.QUOTE("(Min = " + bd.getMinimum() + " Max = " + bd.getMaximum() + ")"));
        form.add(UIMsg.TO_MSG("NumericField<BigDecimal>"), bd, label2);
        BaseAction valueAction = new BaseAction(UIMsg.TO_MSG("Print Values")){

            @Override
            public void run() {
                System.out.println("Integer=" + numericField.getValue() + " Double=" + pi.getValue());
            }
        };
        Button button = new Button((UiContainer)panel, valueAction);
        form.add(button);
        return panel;
    }
}

