/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import java.util.Locale;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.List;
import oracle.bpm.ui.Menu;
import oracle.bpm.ui.MenuBar;
import oracle.bpm.ui.MenuItem;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.WindowAdapter;
import oracle.bpm.ui.event.WindowEvent;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.DefaultTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

public class SampleI18n
extends SampleBase {
    private SampleI18n() {
        super("I18n");
    }

    public static SampleI18n create() {
        return new SampleI18n();
    }

    @Override
    public UiComponent buildEditorPanel(final UiContainer parent) {
        Panel mainPanel = new Panel(parent);
        Button button = new Button((UiContainer)mainPanel, UIMsg.TO_MSG("Lauch Test Application"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                I18nApplication app = new I18nApplication(parent.getOwnerWindow());
                app.setVisible(true);
            }
        });
        return mainPanel;
    }

    private static class I18nApplication
    extends Dialog {
        private static final String CHINESE_TEXT = "Chinese_\u9ad8\u30eb\u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u597d\u691c\uc6f9\u201e\u7f51\u8a9e \u7f51\u8a9e \u7f51\u8a9e\u9ad8\u30eb";
        private static final String TITLE = "Chinese_\u9ad8\u30eb\u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u597d\u691c\uc6f9\u201e\u7f51\u8a9e \u7f51\u8a9e \u7f51\u8a9e\u9ad8\u30eb";

        public I18nApplication(UiWindow parent) {
            super(parent);
            this.setTitle("Chinese_\u9ad8\u30eb\u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u597d\u691c\uc6f9\u201e\u7f51\u8a9e \u7f51\u8a9e \u7f51\u8a9e\u9ad8\u30eb");
            this.init();
        }

        private static Tree buildTree(UiContainer parent) {
            TreeNode root = TreeNode.create("\u201e\u9ad8\u30eb \u7f51\u8a9e\u9ad8\u30ebt");
            for (int i = 0; i < I18nTableModel.VALUES.length; ++i) {
                root.add(TreeNode.create(I18nTableModel.VALUES[i]));
            }
            return new Tree(parent, root);
        }

        private static MenuBar buildMenuBar(UiContainer parent) {
            MenuBar menuBar = new MenuBar(parent);
            Menu menu = new Menu((UiContainer)menuBar, "Chinese_\u9ad8\u30eb\u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u597d\u691c\uc6f9\u201e\u7f51\u8a9e \u7f51\u8a9e \u7f51\u8a9e\u9ad8\u30eb");
            menuBar.add(menu);
            for (int i = 0; i < I18nTableModel.VALUES.length; ++i) {
                menu.add(new MenuItem((UiContainer)menu, I18nTableModel.VALUES[i]));
            }
            return menuBar;
        }

        private void init() {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                }
            });
            this.setMenuBar(I18nApplication.buildMenuBar(this));
            UiContainer panel = this.getContentPane();
            panel.setLayout(new BoxLayout(panel, 1));
            Label localeLabel = Label.create(panel, Msg.QUOTE("Current Locale=" + Locale.getDefault() + " System properties=" + System.getProperty("user.language") + " " + System.getProperty("user.country")));
            Button btn = new Button(panel, "Chinese_\u9ad8\u30eb\u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u597d\u691c\uc6f9\u201e\u7f51\u8a9e \u7f51\u8a9e \u7f51\u8a9e\u9ad8\u30eb");
            Label label = Label.create(panel, Msg.QUOTE("Chinese_\u9ad8\u30eb\u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u597d\u691c\uc6f9\u201e\u7f51\u8a9e \u7f51\u8a9e \u7f51\u8a9e\u9ad8\u30eb"));
            TextField field = new TextField(panel);
            field.setText("Chinese_\u9ad8\u30eb\u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u597d\u691c\uc6f9\u201e\u7f51\u8a9e \u7f51\u8a9e \u7f51\u8a9e\u9ad8\u30eb");
            field.setColumns(40);
            TextArea area = new TextArea(panel);
            area.setText("Chinese_\u9ad8\u30eb\u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u597d\u691c\uc6f9\u201e\u7f51\u8a9e \u7f51\u8a9e \u7f51\u8a9e\u9ad8\u30eb");
            area.setRows(3);
            area.setColumns(40);
            List list = List.create(panel, I18nTableModel.VALUES);
            Tree tree = I18nApplication.buildTree(panel);
            Table table = new Table(panel, new I18nTableModel(true));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            panel.add(localeLabel);
            panel.add(btn);
            panel.add(label);
            panel.add(field);
            panel.add(area);
            panel.add(list);
            panel.add(tree);
            panel.add(table);
            this.pack();
            this.setLocation(300, 300);
        }

        private static class I18nTableModel
        extends DefaultTableModel {
            private boolean isEditable;
            private static final MsgList TITLES = MsgList.create(UIMsg.TO_MSG("English"), UIMsg.TO_MSG("Spanish (\u00e1\u00e9\u00ed)"), UIMsg.TO_MSG("Portuguese (\u00f5\u00f3\u00f4)"), UIMsg.TO_MSG("French (\u00f4\u0153\u00f9)"), UIMsg.TO_MSG("Italian (\u00e8\u00e9\u00ec)"), UIMsg.TO_MSG("German (\u00fc\u00df\u00c4)"), UIMsg.TO_MSG("Chinese (\u7f51\u8a9e\u7f51)"));
            private static final String[] VALUES = new String[]{"English_Hello", "Spanish_\u00e1\u00e9\u00ed\u00f1\u00f3\u00fa\u00fc\u00bf\u00a1\u2014\ufffd?\u00c9\ufffd?\u00d1\u00d3\u00da\u00dc\u00bf", "Portigu\u00eas_\u00f5\u00f3\u00f4\u00fa\u00fc\u2014\u00e3\u00e1\u00e2\u00e0\u00e7\u00e9\u00ea\u00ed-\u00d5\u00d3\u00d4\u00da\u00dc\u2014\u00c3\ufffd?\u00c2\u00c0\u00c7\u00c9\u00ca\ufffd?", "Fran\u00e7ais_\u00f4\u0153\u00f9\u00fb\u00fc\u00ff\u00ab\u00bb\u2014\u00e0\u00e2\u00e7\u00e9\u00e8\u00ea\u00eb\u00ef\u00ee-\u00d4\u0152\u00d9\u00db\u00dc\u0178\u00ab\u00bb\u2014\u00c0\u00c2\u00c7\u00c9\u00c8\u00ca\u00cb\ufffd?\u00ce", "Italian_\u00e0\u00e8\u00e9\u00ec\u00f2\u00f3\u00f9\u00ab\u00bb\u2014\u00c0\u00c8\u00c9\u00cc\u00d2\u00d3\u00d9\u00ab\u00bb\u2014", "German_\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc\u2014\u00c4\u00d6\u00dc\u00df\u00c4\u00d6\u00dc\u2014", "Chinese_\u9ad8\u30eb\u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u7f51\u8a9e \u7f51\u8a9e\u597d\u691c\uc6f9\u201e\u7f51\u8a9e \u7f51\u8a9e \u7f51\u8a9e\u9ad8\u30eb"};

            public I18nTableModel() {
                this(false);
            }

            public I18nTableModel(boolean isEditable) {
                super(TITLES, 0);
                this.isEditable = isEditable;
                this.populate();
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return this.isEditable;
            }

            private void populate() {
                for (int i = 0; i < 5; ++i) {
                    this.addRow(VALUES);
                }
            }
        }
    }
}

