/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;

public class SampleHidePanel
extends SampleBase {
    private SampleHidePanel() {
        super("Hide Panel");
    }

    public static SampleHidePanel create() {
        return new SampleHidePanel();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel mainPanel = new Panel(parent);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(new SimulatePropertyPanel(mainPanel));
        mainPanel.add(new SimulatePropertyPanel(mainPanel));
        return mainPanel;
    }

    private static class SimulatePropertyPanel
    extends Panel {
        private UiComponent centerPanel;

        SimulatePropertyPanel(UiContainer parent) {
            super(parent);
            this.init();
        }

        private static UiComponent buildCenterPanel(UiContainer parent) {
            Panel mainPanel = new Panel(parent);
            mainPanel.setLayout(new FlowLayout());
            mainPanel.add(Label.create((UiContainer)mainPanel, UIMsg.TO_MSG("Dynamic Panel Created")));
            mainPanel.add(new Button((UiContainer)mainPanel, UIMsg.TO_MSG("A")));
            mainPanel.add(new Button((UiContainer)mainPanel, UIMsg.TO_MSG("B")));
            return mainPanel;
        }

        private void init() {
            this.setLayout(new BorderLayout());
            final Button showHideButton = new Button((UiContainer)this, UIMsg.TO_MSG("Hide Panel"));
            showHideButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean isHide = showHideButton.getText().equals("Hide Panel");
                    SimulatePropertyPanel.this.centerPanel.setVisible(!isHide);
                    showHideButton.setText(isHide ? "Show Panel" : "Hide Panel");
                    SimulatePropertyPanel.this.revalidate();
                    SimulatePropertyPanel.this.repaint();
                }
            });
            this.centerPanel = SimulatePropertyPanel.buildCenterPanel(this);
            this.centerPanel.makeRecyclable();
            this.add(showHideButton, "North");
            this.add(this.centerPanel, "Center");
        }
    }
}

