/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import fuego.fuegoui.samples.SamplePropertyGroup;
import fuego.fuegoui.samples.SampleTable;
import fuego.fuegoui.samples.SampleTableDynamic;
import oracle.bpm.ui.ExpandBar;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.PropertyTablePanel;

public class SampleExpandBar
extends SampleBase {
    public SampleExpandBar(String description) {
        super(description);
    }

    public static SampleExpandBar create() {
        return new SampleExpandBar("Simple ExpandBar");
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout(new BorderLayout());
        ExpandBar expandBar = new ExpandBar(panel);
        SampleExpandBar.populateExpandBar(expandBar);
        panel.add(expandBar, "Center");
        return panel;
    }

    private static void populateExpandBar(ExpandBar expandBar) {
        PropertyTablePanel externalPanel = new PropertyTablePanel(expandBar, UIMsg.TO_MSG("Externas"));
        PropertyTablePanel instancePanel = new PropertyTablePanel(expandBar, UIMsg.TO_MSG("Instances"));
        PropertyTablePanel localPanel = new PropertyTablePanel(expandBar, UIMsg.TO_MSG("Local"));
        SampleExpandBar.initGroup(externalPanel);
        SampleExpandBar.initGroup(instancePanel);
        SampleExpandBar.initGroup(localPanel);
        expandBar.add((UiComponent)externalPanel, UIMsg.TO_MSG("Externas"), true);
        expandBar.add((UiComponent)instancePanel, UIMsg.TO_MSG("Instances"), true);
        expandBar.add((UiComponent)localPanel, UIMsg.TO_MSG("Local"), false);
        SampleTable stable = SampleTable.create();
        expandBar.add(stable.buildEditorPanel(expandBar), UIMsg.TO_MSG("Normal Table"), false);
        SampleTableDynamic sdtable = SampleTableDynamic.create();
        expandBar.add(sdtable.buildEditorPanel(expandBar), UIMsg.TO_MSG("Dynamic Table"), false);
    }

    private static void initGroup(final PropertyTablePanel propertyPanel) {
        final PropertyGroup root = propertyPanel.getGroup();
        SamplePropertyGroup var1 = new SamplePropertyGroup("Var1", "Hola");
        root.add(var1);
        SamplePropertyGroup.populate(var1);
        SamplePropertyGroup var2 = new SamplePropertyGroup("Var2", "Chau");
        root.add(var2);
        SamplePropertyGroup.populate(var2);
        BaseAction addAction = new BaseAction(UIMsg.ADD){

            @Override
            public void run() {
                root.add(Factory.createText(UIMsg.TO_MSG("Dummy"), "dummy"));
                propertyPanel.reload();
            }
        };
        BaseAction removeAction = new BaseAction(UIMsg.REMOVE){

            @Override
            public void run() {
                Property selected = propertyPanel.getSelectedProperty();
                if (selected != null) {
                    propertyPanel.stopCellEditing();
                    if (root.remove(selected)) {
                        propertyPanel.reload();
                    }
                }
            }
        };
        propertyPanel.addAction(addAction);
        propertyPanel.addAction(removeAction);
    }
}

