/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Ellipse;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DragSourceHandler;
import oracle.bpm.ui.dnd.DropTargetHandler;
import oracle.bpm.ui.dnd.FileTransfer;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.TextTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.GridLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.TextArea;

class SampleDragDrop
extends SampleBase {
    private SampleDragDrop() {
        super("Drag & Drop");
    }

    public static SampleDragDrop create() {
        return new SampleDragDrop();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        return new SamplePanel(parent);
    }

    private static class SamplePanel
    extends Panel {
        public SamplePanel(UiContainer parent) {
            super(parent);
            this.init();
        }

        public void init() {
            this.setLayout(new BorderLayout());
            UiComponent component = this.buildDragSourcePanel(this);
            this.add(component, "West");
            UiComponent component1 = this.buildDropTargetPanel(this);
            this.add(component1, "Center");
        }

        private static Label buildStringDragSourceLabel(UiContainer parent, String text) {
            Label label = Label.create(parent, Msg.QUOTE(text));
            new DragSourceHandler(label, DndAction.COPY_OR_MOVE){
                static final String RETVAL = "[reference to String]";

                @Override
                public Object getObject(Transfer type) {
                    return RETVAL;
                }

                @Override
                public Transfer[] getTransfers() {
                    return new Transfer[]{TextTransfer.getInstance()};
                }
            };
            return label;
        }

        private static Label buildIntegerDragSourceLabel(UiContainer parent, String text) {
            Label label = Label.create(parent, Msg.QUOTE(text));
            new DragSourceHandler(label, DndAction.COPY_OR_MOVE, new Transfer[]{LocalObjectTransfer.getInstance(Integer.class)}){

                @Override
                public Object getObject(Transfer type) {
                    return 800;
                }
            };
            return label;
        }

        private static Label buildFileDragSourceLabel(UiContainer parent, String text, final File file) {
            Label label = Label.create(parent, Msg.QUOTE(text));
            new DragSourceHandler(label, DndAction.COPY_OR_MOVE, new Transfer[]{FileTransfer.getInstance()}){

                @Override
                public Object getObject(Transfer type) {
                    return new String[]{file.getAbsolutePath()};
                }
            };
            return label;
        }

        private static UiComponent buildMyAdressBookDragSourceLabel(UiContainer parent, String text) {
            Label label = Label.create(parent, Msg.QUOTE(text));
            new DragSourceHandler(label, DndAction.COPY_OR_MOVE, new Transfer[]{LocalObjectTransfer.getInstance(MyAddressBook.class)}){

                @Override
                public Object getObject(Transfer type) {
                    return new MyAddressBook("Ale", 43);
                }
            };
            return label;
        }

        private static Label buildStringArrayDragSourceLabel(UiContainer parent, String text) {
            Label label = Label.create(parent, Msg.QUOTE(text));
            new DragSourceHandler(label, DndAction.COPY_OR_MOVE, new Transfer[]{LocalObjectTransfer.getInstance(String[].class)}){

                @Override
                public Object getObject(Transfer type) {
                    return new String[]{"[String1]", "[String2]", "[String3]"};
                }
            };
            return label;
        }

        private static Label buildLocaleDragSourceLabel(UiContainer parent, String text) {
            Label label = Label.create(parent, Msg.QUOTE(text));
            new DragSourceHandler(label, DndAction.COPY_OR_MOVE, new Transfer[]{LocalObjectTransfer.getInstance(Locale.class)}){

                @Override
                public Object getObject(Transfer type) {
                    return Locale.ENGLISH;
                }
            };
            return label;
        }

        private UiComponent buildDropTargetPanel(UiContainer parent) {
            Panel panel = new Panel(parent, Msg.QUOTE("Drop Target Panel"));
            panel.setLayout(new GridLayout(2, 1));
            final TextArea textArea = new TextArea(panel);
            textArea.setLineWrap(true);
            textArea.setText("[Drop Region]");
            final DropTargetPaintCanvas canvas = new DropTargetPaintCanvas(panel);
            panel.add(canvas);
            panel.add(textArea);
            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance(), LocalObjectTransfer.getInstance(Integer.class), LocalObjectTransfer.getInstance(Locale.class), LocalObjectTransfer.getInstance(String[].class), LocalObjectTransfer.getInstance(MyAddressBook.class)};
            new DropTargetHandler(canvas, DndAction.COPY_OR_MOVE, transfers){

                @Override
                public void drop(Object data, Transfer type, Point point, DndAction dndAction) {
                    canvas.addDrop(point);
                }

                @Override
                public boolean canDrop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                    return canvas.canDrop(point);
                }
            };
            new DropTargetHandler(textArea, DndAction.COPY_OR_MOVE, transfers){

                @Override
                public void drop(Object data, Transfer type, Point point, DndAction dndAction) {
                    String result = "";
                    if (type == TextTransfer.getInstance()) {
                        result = (String)data;
                    } else if (type == FileTransfer.getInstance()) {
                        String[] s;
                        for (String value : s = (String[])data) {
                            result = result + value + "\n";
                        }
                    } else if (type == LocalObjectTransfer.getInstance(Integer.class)) {
                        result = String.valueOf(data);
                    } else if (type == LocalObjectTransfer.getInstance(Locale.class)) {
                        result = data.toString();
                    } else if (type == LocalObjectTransfer.getInstance(String[].class)) {
                        String[] s;
                        for (String value : s = (String[])data) {
                            result = result + value;
                        }
                    } else if (type == LocalObjectTransfer.getInstance(MyAddressBook.class)) {
                        result = data.toString();
                    }
                    textArea.setText(textArea.getText() + "\n" + result);
                }
            };
            return panel;
        }

        private UiComponent buildDragSourcePanel(UiContainer parent) {
            Panel panel = new Panel(parent);
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(SamplePanel.buildStringDragSourceLabel(panel, "[Drag a String]"));
            panel.add(SamplePanel.buildStringArrayDragSourceLabel(panel, "[Drag a String Array]"));
            panel.add(SamplePanel.buildLocaleDragSourceLabel(panel, "[Drag a Locale]"));
            panel.add(SamplePanel.buildIntegerDragSourceLabel(panel, "[Drag an Integer(800)]"));
            File file = this.getTempFile();
            panel.add(SamplePanel.buildFileDragSourceLabel(panel, "[Drag a File (" + file.getAbsolutePath() + ")]", file));
            panel.add(SamplePanel.buildMyAdressBookDragSourceLabel(panel, "[Drag a non Serializable Class]"));
            return panel;
        }

        private File getTempFile() {
            File result;
            try {
                result = File.createTempFile("pattern", ".suffix");
                result.deleteOnExit();
            }
            catch (IOException e) {
                result = new File("C:\\error_creating_tmp_file.txt");
            }
            return result;
        }

        private static class DropTargetPaintCanvas
        extends PaintCanvas {
            private Map<Ellipse, Boolean> drops;
            private boolean lastCanDrop;
            private static final int ELLIPSE_SIZE = 20;

            protected DropTargetPaintCanvas(UiContainer parent) {
                super(parent);
                this.setPreferredSize(Dimension.valueOf(300, 300));
                this.drops = new HashMap<Ellipse, Boolean>();
                this.lastCanDrop = true;
            }

            public boolean canDrop(Point point) {
                Rectangle rectangle = new Rectangle(point.getX() - 10, point.getY() - 10, 20, 20);
                boolean canDrop = true;
                for (Ellipse ellipse : this.drops.keySet()) {
                    boolean contains = rectangle.contains(ellipse.getCenterX(), ellipse.getCenterY());
                    this.drops.put(ellipse, contains);
                    canDrop &= !contains;
                }
                if (this.lastCanDrop != canDrop) {
                    this.lastCanDrop = canDrop;
                    this.repaint();
                }
                return canDrop;
            }

            public void addDrop(Point point) {
                Ellipse ellipse = new Ellipse(point.getX() + 10, point.getY() + 10, 20, 20);
                this.drops.put(ellipse, false);
                this.repaint();
            }

            @Override
            public void paintCanvas(Graphics graphics) {
                graphics.setStroke(Stroke.TWO_SOLID);
                graphics.drawRect(0, 0, 300, 300);
                graphics.drawString("Drop Items Here", 20, 20);
                for (Map.Entry<Ellipse, Boolean> entry : this.drops.entrySet()) {
                    graphics.setForeground(entry.getValue() != false ? Color.RED : Color.BLACK);
                    graphics.draw(entry.getKey());
                }
            }
        }
    }

    private static class MyAddressBook
    implements Serializable {
        private int code;
        private String name;
        private static final long serialVersionUID = -2268185831375786657L;

        MyAddressBook() {
        }

        MyAddressBook(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public String toString() {
            return "name=" + this.name + " code=" + this.code;
        }
    }
}

