/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import java.util.ArrayList;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.border.BorderLayout;

class SampleCardLayout
extends SampleBase {
    private SampleCardLayout() {
        super("CardLayout");
    }

    public static SampleCardLayout create() {
        return new SampleCardLayout();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel mainPanel = new Panel(parent);
        mainPanel.setLayout(new BorderLayout());
        Panel subPanel = new Panel(mainPanel);
        subPanel.setLayout(new BorderLayout());
        final ComboBox<String> combo = UiFactory.createMutableComboBox(subPanel, new ArrayList());
        combo.addItem("Panel_A");
        combo.addItem("Panel_B");
        Button addPanel = new Button(subPanel);
        addPanel.setText("Add a new Panel to the combo...");
        subPanel.add(combo, "North");
        subPanel.add(addPanel, "South");
        mainPanel.add(subPanel, "North");
        CardLayout cardLayout = new CardLayout();
        final Panel cardPanel = new Panel(mainPanel);
        cardPanel.setLayout(cardLayout);
        mainPanel.add(cardPanel, "Center");
        addPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = "Panel " + System.currentTimeMillis();
                Panel cardX = SampleCardLayout.this.createPanel(cardPanel, name);
                cardPanel.add(cardX, name);
                combo.addItem(name);
                cardPanel.revalidate();
            }
        });
        Panel card0 = this.createPanel(cardPanel, "Panel_A");
        Panel card1 = this.createPanel(cardPanel, "Panel_B");
        cardPanel.add(card0, "Panel_A");
        cardPanel.add(card1, "Panel_B");
        cardPanel.revalidate();
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    CardLayout cardLayout = (CardLayout)cardPanel.getLayout();
                    String name = (String)e.getItem();
                    cardLayout.show(cardPanel, name);
                }
            }
        });
        combo.setSelectedIndex(1);
        cardLayout.show(cardPanel, "Panel_B");
        return mainPanel;
    }

    private Panel createPanel(UiContainer parent, String name) {
        Panel panel = new Panel(parent);
        panel.setLayout(new FlowLayout());
        Label label = Label.create((UiContainer)panel, Msg.QUOTE(name));
        panel.add(label);
        return panel;
    }
}

