/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

class SampleBorders
extends SampleBase {
    private SampleBorders() {
        super("Borders");
    }

    public static SampleBorders create() {
        return new SampleBorders();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setName("borders.panel");
        panel.setLayout(new FlowLayout(0));
        Button button = new Button((UiContainer)panel, "change Border");
        Border etchedBorder = BorderFactory.createEtchedBorder(Color.RED, Color.BLUE);
        this.addBorder(panel, "Etched", etchedBorder);
        final Label redBorder = this.addBorder(panel, "Line Border (red) ", BorderFactory.createLineBorder(Color.RED));
        this.addBorder(panel, "Empty Border 10px", BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.addBorder(panel, "Empty Border 20px", BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.addBorder(panel, "Raised Bevel Border", BorderFactory.createRaisedBevelBorder());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                redBorder.setBorder(BorderFactory.createLineBorder(Color.BLUE, 25));
                redBorder.repaint();
                redBorder.getParent().repaint();
                redBorder.getParent().revalidate();
            }
        });
        Tree tree = new Tree(panel);
        TreeNode root = TreeNode.create("Root");
        root.add(TreeNode.create("Child"));
        tree.setRoot(root);
        tree.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        panel.add(tree);
        Panel p = new Panel(panel, UIMsg.TO_MSG("Titulo"));
        p.add(Label.create((UiContainer)p, Msg.QUOTE("Test")));
        panel.add(p);
        return panel;
    }

    private Label addBorder(Panel parent, String name, Border border) {
        Label label = Label.create((UiContainer)parent, Msg.QUOTE(name));
        System.out.println("\nborder: " + name + " with insets: " + border.getBorderInsets(label));
        System.out.println("    before.size: " + label.getSize());
        System.out.println("    before.preferredSize: " + label.getPreferredSize());
        System.out.println("    before.insets: " + label.getInsets());
        label.setBorder(border);
        parent.add(label);
        System.out.println("    size: " + label.getSize());
        System.out.println("    preferredSize: " + label.getPreferredSize());
        System.out.println("    insets: " + label.getInsets());
        System.out.println("    bounds: " + label.getBounds());
        System.out.println("    location: " + label.getLocation());
        return label;
    }
}

