/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui;

import fuego.fuegoui.ISample;
import fuego.fuegoui.samples.Samples;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Menu;
import oracle.bpm.ui.MenuBar;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.TreeSelectionMode;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DragSourceHandler;
import oracle.bpm.ui.dnd.DropTargetHandler;
import oracle.bpm.ui.dnd.TextTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.tree.TreePath;

public class FuegoUi
extends Frame {
    private TocPanel tocPanel;

    public FuegoUi() {
        super("Fuego UI Test - " + (Object)((Object)Ui.getType()));
        this.init();
    }

    public static void main(String[] args) {
        UiType type = UiType.SWING;
        if (args.length > 0) {
            String param = args[0].trim().toUpperCase();
            type = "SWT".equalsIgnoreCase(param) ? UiType.SWT : ("SWING".equalsIgnoreCase(param) ? UiType.SWING : type);
        }
        Ui.initialize(type);
        FuegoUi myApp = new FuegoUi();
        myApp.setVisible(true);
    }

    public static TocPanel createTocPanel(UiContainer parent) {
        return new TocPanel(parent);
    }

    private TocPanel getTocPanel() {
        if (this.tocPanel == null) {
            this.tocPanel = FuegoUi.createTocPanel(this.getContentPane());
        }
        return this.tocPanel;
    }

    private MenuBar buildMenuBar() {
        MenuBar menuBar = new MenuBar(this);
        Menu fileMenu = new Menu((UiContainer)menuBar, UIMsg.FILE);
        BaseAction exitAction = new BaseAction(UIMsg.EXIT){

            @Override
            public void run() {
                System.out.println(".actionPerformed() EXIT");
                System.exit(0);
            }
        };
        fileMenu.add(exitAction);
        return menuBar;
    }

    private void buildToolBar() {
        ToolBar toolBar = this.getToolBar();
        BaseAction showInDialogPackAction = new BaseAction(UIMsg.TO_MSG("Show Sample in Dialog (pack)")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ISample sample = FuegoUi.this.getTocPanel().getCurrentSample();
                DialogViewer dialog = new DialogViewer((UiWindow)FuegoUi.this, sample, true);
                dialog.setVisible(true);
            }
        };
        BaseAction showInDialogSizeAction = new BaseAction(UIMsg.TO_MSG("Show Sample in Dialog (setSize)")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ISample sample = FuegoUi.this.getTocPanel().getCurrentSample();
                DialogViewer dialog = new DialogViewer((UiWindow)FuegoUi.this, sample, false);
                dialog.setVisible(true);
            }
        };
        toolBar.add(new Button((UiContainer)toolBar, showInDialogPackAction));
        toolBar.add(new Button((UiContainer)toolBar, showInDialogSizeAction));
    }

    private void init() {
        this.setDefaultCloseOperation(3);
        this.setMenuBar(this.buildMenuBar());
        this.buildToolBar();
        TocPanel tp = this.getTocPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(tp, "Center");
        this.setSize(Dimension.valueOf(800, 600));
        this.setLocationRelativeTo(null);
    }

    private static class DialogViewer
    extends Dialog {
        DialogViewer(UiWindow parent, ISample sample, boolean isPack) {
            super(parent, sample.getDescription(), false);
            this.init(sample, isPack);
        }

        private void init(ISample sample, boolean isPack) {
            UiContainer panel = this.getContentPane();
            panel.add(sample.buildEditorPanel(panel));
            this.setLocationRelativeTo(this.getParent());
            if (isPack) {
                this.pack();
            } else {
                this.setSize(600, 400);
            }
        }
    }

    public static class TocPanel
    extends SplitPane {
        private ISample currentSample;
        private TabbedPane tabbedPane;

        TocPanel(UiContainer parent) {
            super(parent);
            UiComponent tree = this.buildTreeSamples(this);
            this.setLeftComponent(tree);
            this.showSample(Samples.DEFAULT);
        }

        public void showSample(ISample sample) {
            try {
                TabbedPane tp = this.getTabbedPane();
                String description = sample.getDescription();
                int index = tp.indexOfTab(description);
                if (index == -1) {
                    UiComponent component = sample.buildEditorPanel(this.getTabbedPane());
                    tp.addTab(Msg.QUOTE(description), component);
                    index = tp.getTabCount() - 1;
                }
                tp.setSelectedIndex(index);
                this.currentSample = sample;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public ISample getCurrentSample() {
            return this.currentSample;
        }

        private TabbedPane getTabbedPane() {
            if (this.tabbedPane == null) {
                this.tabbedPane = new TabbedPane(this);
                this.setRightComponent(this.tabbedPane);
                this.setResizeWeight(0.25);
            }
            return this.tabbedPane;
        }

        private UiComponent buildTreeSamples(UiContainer parent) {
            Panel panel = new Panel(parent);
            panel.setLayout(new BorderLayout());
            final Tree tree = Samples.buildTree(panel);
            tree.setSelectionMode(TreeSelectionMode.SINGLE_TREE_SELECTION);
            tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    Samples.SampleNode node;
                    System.out.println(".valueChanged() Change TREE selection");
                    TreePath treePath = tree.getSelectionPath();
                    if (treePath != null && (node = (Samples.SampleNode)treePath.getLastPathComponent()) != null && node.isLeaf()) {
                        TocPanel.this.showSample(node.getSample());
                    }
                }
            });
            tree.setSelectionRow(0);
            new DragSourceHandler(tree, DndAction.COPY, new Transfer[]{TextTransfer.getInstance()}){

                @Override
                public Object getObject(Transfer transfer) {
                    TreeNode node = tree.getSelectedTreeNode();
                    return node != null ? node.toString() : null;
                }
            };
            new DropTargetHandler(tree, DndAction.COPY, new Transfer[]{TextTransfer.getInstance()}){

                @Override
                public void drop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                    System.out.println("FuegoUi point=" + point);
                }
            };
            System.out.println("Tree.preferredSize: " + tree.getPreferredSize());
            System.out.println("Tree.minimumSize: " + tree.getMinimumSize());
            System.out.println("Tree.maximumSize: " + tree.getMaximumSize());
            System.out.println("Tree.size: " + tree.getSize());
            Button btn = new Button(panel);
            btn.setText("Test Event Selection Tree");
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println(".actionPerformed() SELECCION\ufffd\ufffd Item 3");
                    tree.setSelectionRow(3);
                }
            });
            panel.add(btn, "North");
            panel.add(tree, "Center");
            return panel;
        }
    }
}

