/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.security.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.log.Log;
import oracle.bpm.pml.security.exception.PmlSecurityException;
import oracle.bpm.pml.security.exception.PmlSecurityExceptionFactory;
import oracle.bpm.pml.security.exception.PmlSecurityObjectNotFoundException;
import oracle.bpm.pml.security.impl.SecuredProjectImpl;
import oracle.bpm.pml.security.model.PmlPrincipal;
import oracle.bpm.pml.security.model.ProjectAction;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.security.model.SecuredProject;
import oracle.bpm.pml.security.msg.PmlSecurityMsg;
import oracle.bpm.pml.security.service.PmlSecurityCoreService;
import oracle.bpm.pml.security.util.OpssCoreHelper;
import oracle.security.jps.JpsContext;
import oracle.security.jps.JpsContextFactory;
import oracle.security.jps.JpsException;
import oracle.security.jps.ResourcePermission;
import oracle.security.jps.internal.idstore.info.RealmEntry;
import oracle.security.jps.internal.idstore.info.RealmRoleEntry;
import oracle.security.jps.internal.idstore.info.RealmRoleMemberEntry;
import oracle.security.jps.internal.idstore.xml.idm.IdmXmlIdentityStore;
import oracle.security.jps.service.idstore.IdentityStoreException;
import oracle.security.jps.service.idstore.IdentityStoreService;
import oracle.security.jps.service.idstore.IdentityStoreType;
import oracle.security.jps.service.policystore.PolicyStore;
import oracle.security.jps.service.policystore.info.GrantEntry;
import oracle.security.jps.service.policystore.info.PermissionEntry;
import oracle.security.jps.service.policystore.info.PrincipalEntry;
import oracle.tip.pc.services.identity.BPMGroup;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMIdentityService;
import oracle.tip.pc.services.identity.BPMRole;
import oracle.tip.pc.services.identity.BPMUser;
import org.jetbrains.annotations.NotNull;

public class SecurityServiceHelper
implements PmlSecurityCoreService {
    private String applicationName;
    private boolean firstAccess;
    private BPMIdentityService identityService;
    private IdentityStoreService identityStore;
    private OpssCoreHelper opssCoreHelper;
    private Map<String, PmlPrincipal> userPrincipals;
    public static final String OPSS_HELPER_CLASS = "oracle.bpm.services.pml.impl.OpssCoreHelperImpl";
    public static final String ADMIN_ANY_PROJECT = "BPMComposerAdmin";
    public static final String SOA_DESIGNER = "SOADesigner";

    public SecurityServiceHelper(@NotNull PolicyStore policyStore, @NotNull String applicationName) throws PmlSecurityException {
        if (policyStore == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.<init> must not be null");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.<init> must not be null");
        }
        this.firstAccess = true;
        this.applicationName = applicationName;
        this.userPrincipals = new HashMap<String, PmlPrincipal>();
        this.opssCoreHelper = this.newOpssCoreHelper(policyStore, applicationName);
        try {
            JpsContext context = JpsContextFactory.getContextFactory().getContext();
            this.identityStore = (IdentityStoreService)context.getServiceInstance(IdentityStoreService.class);
        }
        catch (JpsException e) {
            throw PmlSecurityExceptionFactory.createSecurityException(e);
        }
    }

    public SecurityServiceHelper(@NotNull BPMIdentityService identityService, @NotNull PolicyStore policyStore, @NotNull String applicationName) throws PmlSecurityException {
        if (identityService == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.<init> must not be null");
        }
        if (policyStore == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.<init> must not be null");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.<init> must not be null");
        }
        this(policyStore, applicationName);
        this.identityService = identityService;
    }

    public BPMIdentityService getIdentityService() {
        return this.identityService;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public PmlPrincipal getPmlPrincipal(@NotNull String userName) throws PmlSecurityException {
        if (userName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.getPmlPrincipal must not be null");
        }
        PmlPrincipal result = this.userPrincipals.get(userName);
        if (result == null) {
            result = this.identityService == null ? this.getIdentityStorePrincipal(userName) : this.getBPMIdentityServicePrincipal(userName);
            this.userPrincipals.put(userName, result);
        }
        return result;
    }

    @Override
    public void grantProjectRole(@NotNull ProjectRole role, @NotNull String projectName, @NotNull Set<PmlPrincipal> principals) throws PmlSecurityException {
        if (role == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.grantProjectRole must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.grantProjectRole must not be null");
        }
        if (principals == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.grantProjectRole must not be null");
        }
        if (!principals.isEmpty()) {
            String permissionSetName = role.getProjectPrefix(projectName);
            Set<String> allowedActions = ProjectAction.toStringSet(role.getAllowedActions());
            HashSet<PrincipalEntry> principalEntries = new HashSet<PrincipalEntry>();
            for (PmlPrincipal principal : principals) {
                principalEntries.add(principal);
            }
            if (!this.opssCoreHelper.existsResource(projectName)) {
                this.opssCoreHelper.createResource(projectName);
            }
            this.opssCoreHelper.grantResource(permissionSetName, allowedActions, projectName, principalEntries);
        }
    }

    @Override
    public void removeProject(@NotNull String projectName) throws PmlSecurityException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.removeProject must not be null");
        }
        this.revokeProject(projectName);
        this.opssCoreHelper.removeResource(projectName);
    }

    @Override
    public void revokeProject(@NotNull String projectName) throws PmlSecurityException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.revokeProject must not be null");
        }
        this.revokeProjectRoles(EnumSet.allOf(ProjectRole.class), projectName);
    }

    @Override
    public void revokeProjectRoles(@NotNull EnumSet<ProjectRole> projectRoles, @NotNull String projectName) throws PmlSecurityException {
        if (projectRoles == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.revokeProjectRoles must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.revokeProjectRoles must not be null");
        }
        this.opssCoreHelper.revokePermissionSets(projectName, projectRoles);
    }

    @Override
    public Map<String, SecuredProject> getProjectsFor(@NotNull PmlPrincipal principal) throws PmlSecurityException {
        if (principal == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.getProjectsFor must not be null");
        }
        HashMap<String, SecuredProject> result = new HashMap<String, SecuredProject>();
        if (principal.isGlobalOwner()) {
            Set<String> resources = this.opssCoreHelper.getAllResources();
            for (String resource : resources) {
                result.put(resource, new SecuredProjectImpl(resource, ProjectRole.OWNER, this.isShared(resource)));
            }
        }
        Iterable<GrantEntry> grants = this.opssCoreHelper.getGrantsForPrincipal(principal);
        for (GrantEntry grant : grants) {
            List permissionEntries = grant.getPermissionEntries();
            for (PermissionEntry permissionEntry : permissionEntries) {
                if (!ResourcePermission.class.getCanonicalName().equals(permissionEntry.getClassName())) continue;
                ResourcePermission newPermission = (ResourcePermission)permissionEntry.getPermission();
                String projectId = permissionEntry.getTargetName();
                EnumSet<ProjectAction> actions = ProjectAction.fromString(newPermission.getActions());
                ProjectRole role = ProjectRole.getProjectRole(actions);
                boolean isShared = false;
                boolean addProject = false;
                if (result.containsKey(projectId)) {
                    SecuredProject oldProject = (SecuredProject)result.get(projectId);
                    if (role.implies(oldProject.getProjectRole())) {
                        isShared = oldProject.isShared();
                        addProject = true;
                    }
                } else {
                    isShared = this.isShared(projectId);
                    addProject = true;
                }
                if (!addProject) continue;
                SecuredProjectImpl project = new SecuredProjectImpl(projectId, role, isShared);
                project.setIsOwner(role.implies(ProjectRole.OWNER));
                result.put(projectId, project);
            }
        }
        return result;
    }

    @Override
    public boolean isShared(@NotNull String projectId) throws PmlSecurityException {
        ProjectRole projectRole;
        Set<String> users;
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.isShared must not be null");
        }
        Map<ProjectRole, Set<String>> projectGrants = this.getProjectGrants(projectId);
        boolean isShared = false;
        int totalUsers = 0;
        Iterator<ProjectRole> i$ = projectGrants.keySet().iterator();
        while (i$.hasNext() && !(isShared = (totalUsers += (users = projectGrants.get(projectRole = i$.next())).size()) > 1)) {
        }
        return isShared;
    }

    @Override
    public void assertPrivilege(@NotNull PmlPrincipal principal, @NotNull String projectId, @NotNull ProjectRole requiredRole) throws PmlSecurityException {
        if (principal == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.assertPrivilege must not be null");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.assertPrivilege must not be null");
        }
        if (requiredRole == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.assertPrivilege must not be null");
        }
        if (!this.opssCoreHelper.existsResource(projectId)) {
            throw PmlSecurityExceptionFactory.createObjectNotFoundException(projectId);
        }
        if (principal.isGlobalOwner()) {
            return;
        }
        ProjectRole role = this.getRoleFor(projectId, principal);
        if (role == null || !role.implies(requiredRole)) {
            throw PmlSecurityExceptionFactory.createPermissionDeniedException(principal.getName(), requiredRole, role);
        }
    }

    @Override
    public ProjectRole getRoleFor(@NotNull String project, @NotNull PmlPrincipal principal) throws PmlSecurityException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.getRoleFor must not be null");
        }
        if (principal == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.getRoleFor must not be null");
        }
        if (!this.opssCoreHelper.existsResource(project)) {
            throw PmlSecurityExceptionFactory.createObjectNotFoundException(project);
        }
        if (principal.isGlobalOwner()) {
            return ProjectRole.OWNER;
        }
        EnumSet<ProjectRole> requiredRoles = EnumSet.allOf(ProjectRole.class);
        Iterable<GrantEntry> grants = this.opssCoreHelper.getGrants(project, requiredRoles);
        HashSet<String> names = new HashSet<String>(principal.getGroups());
        names.add(principal.getName());
        names.add(PmlPrincipal.getPublicPrincipal(this.applicationName).getName());
        ResourcePermission permission = null;
        for (GrantEntry grant : grants) {
            boolean found = false;
            List principalEntries = grant.getGranteeEntry().getPrincipalEntries();
            for (PrincipalEntry principalEntry : principalEntries) {
                if (!names.contains(principalEntry.getName())) continue;
                found = true;
                break;
            }
            if (!found) continue;
            List permissionEntries = grant.getPermissionEntries();
            for (PermissionEntry permissionEntry : permissionEntries) {
                if (!ResourcePermission.class.getCanonicalName().equals(permissionEntry.getClassName()) || !project.equals(permissionEntry.getTargetName())) continue;
                Permission foundPermission = permissionEntry.getPermission();
                if (permission != null && !foundPermission.implies((Permission)permission)) continue;
                permission = (ResourcePermission)foundPermission;
            }
        }
        ProjectRole result = null;
        if (permission != null) {
            result = ProjectRole.getProjectRole(ProjectAction.fromString(permission.getActions()));
        }
        return result;
    }

    @Override
    public Map<ProjectRole, Set<String>> getProjectGrants(@NotNull String project) throws PmlSecurityException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.getProjectGrants must not be null");
        }
        HashMap<ProjectRole, Set<String>> result = new HashMap<ProjectRole, Set<String>>();
        Iterable<GrantEntry> grants = this.opssCoreHelper.getGrants(project, EnumSet.allOf(ProjectRole.class));
        for (GrantEntry grant : grants) {
            List principalEntries = grant.getGranteeEntry().getPrincipalEntries();
            if (principalEntries.isEmpty()) continue;
            HashSet<String> principals = new HashSet<String>();
            for (PrincipalEntry principalEntry : principalEntries) {
                principals.add(principalEntry.getName());
            }
            List permissionEntries = grant.getPermissionEntries();
            for (PermissionEntry permission : permissionEntries) {
                EnumSet<ProjectAction> actions;
                ProjectRole role;
                if (!project.equals(permission.getTargetName()) || (role = ProjectRole.getProjectRole(actions = ProjectAction.fromString(permission.getActions()))) == null) continue;
                Set foundPrincipals = (Set)result.get(role);
                if (foundPrincipals == null) {
                    result.put(role, principals);
                    continue;
                }
                foundPrincipals.addAll(principals);
            }
        }
        return result;
    }

    @Override
    public boolean isFirstAccess() {
        boolean result = false;
        if (this.firstAccess) {
            this.firstAccess = false;
            result = this.identityService != null && this.opssCoreHelper.isFirstAccess();
        }
        return result;
    }

    private OpssCoreHelper newOpssCoreHelper(@NotNull PolicyStore policyStore, @NotNull String applicationName) throws PmlSecurityException {
        if (policyStore == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.newOpssCoreHelper must not be null");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.newOpssCoreHelper must not be null");
        }
        OpssCoreHelper result = null;
        try {
            Class<?> opssClass = Class.forName(OPSS_HELPER_CLASS);
            Constructor<?> constructor = opssClass.getConstructor(PolicyStore.class, String.class);
            result = (OpssCoreHelper)constructor.newInstance(policyStore, applicationName);
        }
        catch (ClassNotFoundException e) {
            throw PmlSecurityExceptionFactory.createServiceCreationException(e);
        }
        catch (NoSuchMethodException e) {
            throw PmlSecurityExceptionFactory.createServiceCreationException(e);
        }
        catch (InvocationTargetException e) {
            throw PmlSecurityExceptionFactory.createServiceCreationException(e);
        }
        catch (InstantiationException e) {
            throw PmlSecurityExceptionFactory.createServiceCreationException(e);
        }
        catch (IllegalAccessException e) {
            throw PmlSecurityExceptionFactory.createServiceCreationException(e);
        }
        return result;
    }

    private PmlPrincipal getBPMIdentityServicePrincipal(String userName) throws PmlSecurityObjectNotFoundException {
        try {
            BPMUser bpmUser = this.identityService.lookupUser(userName);
            List userGroups = bpmUser.getGroups(true);
            List appRoles = bpmUser.getAppRoles(true);
            LinkedList<String> groups = new LinkedList<String>();
            boolean isGlobalOwner = false;
            boolean isGlobalEditor = false;
            for (BPMGroup userGroup : userGroups) {
                groups.add(userGroup.getName());
            }
            for (BPMRole appRole : appRoles) {
                if (ADMIN_ANY_PROJECT.equals(appRole.getName())) {
                    isGlobalOwner = true;
                    continue;
                }
                if (isGlobalOwner || !SOA_DESIGNER.equals(appRole.getName())) continue;
                isGlobalEditor = true;
            }
            return new PmlPrincipal(userName, groups, this.applicationName, isGlobalOwner, isGlobalEditor);
        }
        catch (BPMIdentityException e) {
            Log.logSevere(e);
            throw PmlSecurityExceptionFactory.createObjectNotFoundException(userName, e);
        }
    }

    private PmlPrincipal getIdentityStorePrincipal(@NotNull String userName) throws PmlSecurityException {
        if (userName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceHelper.getIdentityStorePrincipal must not be null");
        }
        if (!IdentityStoreType.XML.equals((Object)this.identityStore.getIdStoreType())) {
            throw new PmlSecurityException(PmlSecurityMsg.IDENTITY_STORE_NOT_SUPPORTED);
        }
        LinkedList<String> groups = new LinkedList<String>();
        boolean isGlobalAdmin = false;
        boolean isGlobalSoa = false;
        try {
            IdmXmlIdentityStore idmStore = (IdmXmlIdentityStore)this.identityStore.getIdmStore();
            RealmEntry realm = idmStore.getRealmEntry();
            List roles = realm.getRoles();
            block2: for (RealmRoleEntry role : roles) {
                List members = role.getMembers();
                for (RealmRoleMemberEntry member : members) {
                    if (!userName.equals(member.getName())) continue;
                    groups.add(role.getPrincipalName());
                    isGlobalAdmin = ADMIN_ANY_PROJECT.equals(role.getPrincipalName());
                    isGlobalSoa = SOA_DESIGNER.equals(role.getPrincipalName());
                    continue block2;
                }
            }
        }
        catch (IdentityStoreException e) {
            throw PmlSecurityExceptionFactory.createSecurityException(e);
        }
        return new PmlPrincipal(userName, groups, this.applicationName, isGlobalAdmin, isGlobalSoa);
    }
}

