/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.security.util;

import java.io.File;
import java.util.HashMap;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpm.pml.security.exception.PmlSecurityException;
import oracle.bpm.pml.security.exception.PmlSecurityExceptionFactory;
import oracle.bpm.pml.security.impl.PmlSecurityServiceImpl;
import oracle.bpm.pml.security.msg.PmlSecurityMsg;
import oracle.bpm.pml.security.service.PmlSecurityService;
import oracle.bpm.pml.security.util.SecurityServiceHelper;
import oracle.security.jps.JpsContext;
import oracle.security.jps.JpsContextFactory;
import oracle.security.jps.JpsException;
import oracle.security.jps.service.policystore.ApplicationPolicy;
import oracle.security.jps.service.policystore.PolicyObjectNotFoundException;
import oracle.security.jps.service.policystore.PolicyStore;
import oracle.tip.pc.services.identity.BPMIdentityService;
import oracle.tip.pc.services.identity.config.BPMIdentityConfigService;
import oracle.tip.pc.services.identity.config.Configuration;
import oracle.tip.pc.services.identity.config.ProviderCfg;
import oracle.tip.pc.services.identity.jps.JpsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SecurityServiceFactory {
    public static SecurityServiceHelper createSecurityHelper(@Nullable String identityConfigServerURL, @NotNull String applicationName) throws PmlSecurityException {
        if (applicationName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceFactory.createSecurityHelper must not be null");
        }
        SecurityServiceHelper result = null;
        String serverURL = identityConfigServerURL;
        if (serverURL == null) {
            serverURL = "http://localhost:7001";
        }
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> _properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        _properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "SOAP");
        _properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.SOAP_END_POINT_ROOT, serverURL);
        try {
            BPMIdentityConfigService identityConfigService = WorkflowServiceClientFactory.getSOAPIdentityConfigServiceClient(_properties, null);
            Configuration configuration = identityConfigService.getConfiguration(identityConfigService.getDefaultRealmName());
            if (configuration != null) {
                PolicyStore policyStore;
                JpsProvider jpsProvider;
                BPMIdentityService identityService = WorkflowServiceClientFactory.getSOAPIdentityServiceClient((String)configuration.getRealmName(), _properties, null);
                ProviderCfg providerCfg = configuration.getProviderCfg("Authorization");
                if (providerCfg != null && (jpsProvider = (JpsProvider)JpsProvider.getInstance((ProviderCfg)providerCfg)) != null && (policyStore = jpsProvider.getPolicyStore()) != null) {
                    result = new SecurityServiceHelper(identityService, policyStore, applicationName);
                }
            }
        }
        catch (Exception e) {
            throw new PmlSecurityException(PmlSecurityMsg.SERVICE_CREATION_ERROR(e.getMessage()), (Throwable)e);
        }
        if (result == null) {
            throw new PmlSecurityException(PmlSecurityMsg.SERVICE_CREATION_ERROR(PmlSecurityMsg.SERVICE_CREATION_ERROR_DESCRIPTION.getString()));
        }
        return result;
    }

    public static SecurityServiceHelper createSecurityHelper(@NotNull File jspConfigFile, @NotNull String applicationName, boolean clearJpsContext) throws PmlSecurityException {
        if (jspConfigFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceFactory.createSecurityHelper must not be null");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceFactory.createSecurityHelper must not be null");
        }
        try {
            System.setProperty("oracle.security.jps.config", jspConfigFile.toURI().getPath());
            JpsContext context = JpsContextFactory.getContextFactory().getContext();
            PolicyStore policyStore = (PolicyStore)context.getServiceInstance(PolicyStore.class);
            ApplicationPolicy applicationPolicy = null;
            try {
                applicationPolicy = policyStore.getApplicationPolicy(applicationName);
            }
            catch (PolicyObjectNotFoundException e) {
                // empty catch block
            }
            if (clearJpsContext && applicationPolicy != null) {
                policyStore.deleteApplicationPolicy(applicationName);
                applicationPolicy = null;
            }
            if (applicationPolicy == null) {
                policyStore.createApplicationPolicy(applicationName);
            }
            return new SecurityServiceHelper(policyStore, applicationName);
        }
        catch (JpsException e) {
            throw PmlSecurityExceptionFactory.createSecurityException(e);
        }
    }

    public static PmlSecurityService createPmlSecurityService(@NotNull SecurityServiceHelper serviceHelper, @NotNull String userName) throws PmlSecurityException {
        if (serviceHelper == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceFactory.createPmlSecurityService must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/util/SecurityServiceFactory.createPmlSecurityService must not be null");
        }
        return new PmlSecurityServiceImpl(serviceHelper, userName);
    }
}

