/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.security.model;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.Locale;
import oracle.bpm.pml.security.model.ProjectAction;
import oracle.bpm.pml.security.msg.PmlSecurityMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Labeled;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public enum ProjectRole implements Serializable,
I18nProvider,
Labeled
{
    OWNER("OWNER-", PmlSecurityMsg.PROJECT_ROLE_OWNER, EnumSet.allOf(ProjectAction.class)),
    EDITOR("EDITOR-", PmlSecurityMsg.PROJECT_ROLE_EDITOR, EnumSet.of(ProjectAction.VIEW, ProjectAction.EDIT, ProjectAction.DOCUMENT)),
    VIEWER("VIEWER-", PmlSecurityMsg.PROJECT_ROLE_VIEWER, EnumSet.of(ProjectAction.VIEW));

    private EnumSet<ProjectAction> allowedActions;
    private String prefix;
    private transient Msg msg;

    private ProjectRole(@NotNull String prefix, Msg msg, EnumSet<ProjectAction> allowedActions) {
        if (string == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/model/ProjectRole.<init> must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/security/model/ProjectRole.<init> must not be null");
        }
        this.prefix = prefix;
        this.msg = msg;
        this.allowedActions = allowedActions;
    }

    public String getProjectPrefix(@NotNull String project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/model/ProjectRole.getProjectPrefix must not be null");
        }
        return this.prefix + project;
    }

    public EnumSet<ProjectAction> getAllowedActions() {
        return this.allowedActions;
    }

    public boolean canView() {
        return this.implies(VIEWER);
    }

    public boolean canEdit() {
        return this.implies(EDITOR);
    }

    public boolean canManage() {
        return this.implies(OWNER);
    }

    public boolean implies(@NotNull EnumSet<ProjectAction> actions) {
        if (actions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/model/ProjectRole.implies must not be null");
        }
        return this.getAllowedActions().containsAll(actions);
    }

    public boolean implies(@NotNull ProjectRole role) {
        if (role == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/model/ProjectRole.implies must not be null");
        }
        return this.implies(role.getAllowedActions());
    }

    public static ProjectRole getProjectRole(@NotNull EnumSet<ProjectAction> actions) {
        if (actions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/model/ProjectRole.getProjectRole must not be null");
        }
        ProjectRole result = null;
        for (ProjectRole role : EnumSet.allOf(ProjectRole.class)) {
            if (!role.implies(actions)) continue;
            if (result == null) {
                result = role;
                continue;
            }
            if (!result.implies(role)) continue;
            result = role;
        }
        return result;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    @Override
    public Msg getLabel() {
        return this.getMsg();
    }
}

