/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.security.model;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.security.jps.service.policystore.info.AuthenticatedRoleEntry;
import oracle.security.jps.service.policystore.info.PrincipalConstraint;
import oracle.security.jps.service.policystore.info.PrincipalEntry;
import org.jetbrains.annotations.NotNull;

public class PmlPrincipal
implements PrincipalEntry,
Principal,
Serializable {
    private String applicationId;
    private Set<String> groups;
    private boolean isGlobalEditor;
    private boolean isGlobalOwner;
    private String name;
    private static final long serialVersionUID = -1658673473956819043L;
    private static Principal authenticatedPrincipal;
    private static PmlPrincipal publicPmlPrincipal;

    public PmlPrincipal(@NotNull String principal, @NotNull String applicationId) {
        if (principal == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/model/PmlPrincipal.<init> must not be null");
        }
        if (applicationId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/model/PmlPrincipal.<init> must not be null");
        }
        this.name = principal;
        this.applicationId = applicationId;
        this.groups = new HashSet<String>();
        this.isGlobalEditor = false;
        this.isGlobalOwner = false;
    }

    public PmlPrincipal(@NotNull String principal, @NotNull List<String> groups, @NotNull String applicationId, boolean isGlobalOwner, boolean isGlobalEditor) {
        if (principal == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/model/PmlPrincipal.<init> must not be null");
        }
        if (groups == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/model/PmlPrincipal.<init> must not be null");
        }
        if (applicationId == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/security/model/PmlPrincipal.<init> must not be null");
        }
        this(principal, applicationId);
        this.groups.addAll(groups);
        this.isGlobalEditor = isGlobalEditor;
        this.isGlobalOwner = isGlobalOwner;
    }

    public static PmlPrincipal getPublicPrincipal(@NotNull String applicationId) {
        if (applicationId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/model/PmlPrincipal.getPublicPrincipal must not be null");
        }
        if (publicPmlPrincipal == null) {
            publicPmlPrincipal = new PmlPrincipal(PmlPrincipal.getAuthenticatedPrincipal().getName(), applicationId);
        }
        return publicPmlPrincipal;
    }

    public PrincipalConstraint getConstraint() {
        return null;
    }

    public boolean isGlobalOwner() {
        return this.isGlobalOwner;
    }

    public boolean isSoaEditor() {
        return this.isGlobalEditor;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public String getType() {
        return null;
    }

    public String getClassName() {
        return this.getClass().getCanonicalName();
    }

    public String getPrincipalName() {
        return this.name;
    }

    public Principal getPrincipal() {
        return this;
    }

    public String getUniqueName() {
        return null;
    }

    public String getAppID() {
        return null;
    }

    public String getGUID() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getGuid() {
        return this.getGUID();
    }

    public String getDisplayName() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public boolean equals(PrincipalEntry principalEntry) {
        if (this == principalEntry) {
            return true;
        }
        if (!(principalEntry instanceof PmlPrincipal)) {
            return false;
        }
        PmlPrincipal principal = (PmlPrincipal)principalEntry;
        return this.name.equals(principal.getName());
    }

    @Override
    public boolean equals(Object another) {
        if (!(another instanceof PmlPrincipal)) {
            return false;
        }
        PmlPrincipal principal = (PmlPrincipal)another;
        return this.name.equals(principal.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    private static Principal getAuthenticatedPrincipal() {
        if (authenticatedPrincipal == null) {
            authenticatedPrincipal = new AuthenticatedRoleEntry().getPrincipal();
        }
        return authenticatedPrincipal;
    }
}

