/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.security.impl;

import java.util.EnumSet;
import oracle.bpm.pml.security.model.ProjectAction;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.security.model.SecuredProject;
import org.jetbrains.annotations.NotNull;

public class SecuredProjectImpl
implements SecuredProject {
    private EnumSet<ProjectAction> allowedActions;
    private boolean isOwner;
    private boolean isShared;
    private String projectId;
    private ProjectRole role;
    private static final long serialVersionUID = -4990870292932679463L;

    public SecuredProjectImpl(@NotNull String projectId, @NotNull ProjectRole projectRole) {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/SecuredProjectImpl.<init> must not be null");
        }
        if (projectRole == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/SecuredProjectImpl.<init> must not be null");
        }
        this.projectId = projectId;
        this.allowedActions = projectRole.getAllowedActions();
        this.role = projectRole;
        this.isOwner = false;
        this.isShared = false;
    }

    public SecuredProjectImpl(@NotNull String projectId, @NotNull ProjectRole projectRole, boolean isShared) {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/SecuredProjectImpl.<init> must not be null");
        }
        if (projectRole == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/SecuredProjectImpl.<init> must not be null");
        }
        this(projectId, projectRole);
        this.isShared = isShared;
    }

    @Override
    public boolean isOwner() {
        return this.isOwner;
    }

    @Override
    public String getId() {
        return this.projectId;
    }

    @Override
    public void setIsOwner(boolean isOwner) {
        this.isOwner = isOwner;
    }

    @Override
    public void setIsShared(boolean isShared) {
        this.isShared = isShared;
    }

    @Override
    public EnumSet<ProjectAction> getAllowedActions() {
        return this.allowedActions;
    }

    @Override
    public boolean implies(EnumSet<ProjectAction> neededActions) {
        return this.allowedActions.containsAll(neededActions);
    }

    @Override
    public boolean implies(ProjectRole neededRole) {
        return this.implies(neededRole.getAllowedActions());
    }

    @Override
    public boolean implies(SecuredProject neededPermission) {
        return neededPermission.getId().equals(this.projectId) && this.implies(neededPermission.getAllowedActions());
    }

    @Override
    public ProjectRole getProjectRole() {
        return this.role;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.projectId);
        result.append('\n');
        if (this.allowedActions.isEmpty()) {
            result.append("  No granted actions\n");
        } else {
            result.append("  Actions: ");
            boolean first = true;
            for (ProjectAction allowedAction : this.allowedActions) {
                if (first) {
                    first = false;
                } else {
                    result.append(',');
                }
                result.append((Object)allowedAction);
            }
        }
        result.append('\n');
        result.append("  ROLE: ");
        result.append(this.role);
        return result.toString();
    }

    @Override
    public boolean isEditable() {
        return this.implies(ProjectRole.EDITOR);
    }

    @Override
    public boolean isManageable() {
        return this.implies(ProjectRole.OWNER);
    }

    @Override
    public boolean isShared() {
        return this.isShared;
    }
}

