/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.security.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.bpm.pml.security.model.PmlPrincipal;
import oracle.bpm.pml.security.model.ProjectPolicy;
import oracle.bpm.pml.security.model.SecuredProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectPolicyImpl
implements ProjectPolicy {
    private int hashCode;
    private boolean isPublic;
    private boolean isPublicOriginal;
    private Set<String> principals;
    private PmlPrincipal publicPrincipal;
    private SecuredProject securedProject;
    private static final long serialVersionUID = 379588215250174922L;

    public ProjectPolicyImpl(@NotNull String applicationName, @NotNull SecuredProject securedProject, @Nullable Set<String> principals) {
        if (applicationName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPolicyImpl.<init> must not be null");
        }
        if (securedProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPolicyImpl.<init> must not be null");
        }
        this.publicPrincipal = PmlPrincipal.getPublicPrincipal(applicationName);
        this.securedProject = securedProject;
        this.principals = new HashSet<String>();
        this.setPrincipals(principals);
        this.hashCode = ((Object)this.principals).hashCode();
        this.resetDirty();
    }

    @Override
    public SecuredProject getSecuredProject() {
        return this.securedProject;
    }

    @Override
    public Set<String> getPrincipals() {
        return this.principals;
    }

    @Override
    public void addPrincipal(@NotNull String principal) {
        if (principal == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPolicyImpl.addPrincipal must not be null");
        }
        if (!this.principals.contains(principal)) {
            if (this.publicPrincipal.getName().equals(principal)) {
                this.setPublic(true);
            } else {
                this.principals.add(principal);
            }
        }
    }

    @Override
    public void addPrincipals(@NotNull Set<String> principals) {
        if (principals == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPolicyImpl.addPrincipals must not be null");
        }
        for (String principal : principals) {
            this.addPrincipal(principal);
        }
    }

    @Override
    public void setPrincipals(@Nullable Set<String> principals) {
        this.principals.clear();
        if (principals != null) {
            for (String principal : principals) {
                this.addPrincipal(principal);
            }
        }
    }

    @Override
    public void removePrincipal(@NotNull String principal) {
        if (principal == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPolicyImpl.removePrincipal must not be null");
        }
        if (this.publicPrincipal.getName().equals(principal)) {
            this.setPublic(false);
        } else {
            this.principals.remove(principal);
        }
    }

    @Override
    public void removePrincipals(@NotNull Set<String> principals) {
        if (principals == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPolicyImpl.removePrincipals must not be null");
        }
        for (String principal : principals) {
            this.removePrincipal(principal);
        }
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Override
    public boolean isEmpty() {
        return this.principals.isEmpty() && !this.isPublic();
    }

    @Override
    public boolean isDirty() {
        return this.hashCode != ((Object)this.principals).hashCode() || this.isPublic != this.isPublicOriginal;
    }

    @Override
    public boolean resetDirty() {
        boolean result = this.isDirty();
        this.hashCode = ((Object)this.principals).hashCode();
        this.isPublicOriginal = this.isPublic;
        return result;
    }

    @Override
    public boolean isGrantedTo(@NotNull PmlPrincipal principal) {
        boolean result;
        block2: {
            String group;
            if (principal == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/ProjectPolicyImpl.isGrantedTo must not be null");
            }
            boolean bl = result = this.isPublic() || principal.isGlobalOwner() || this.principals.contains(principal.getName());
            if (result) break block2;
            Iterator<String> i$ = principal.getGroups().iterator();
            while (i$.hasNext() && !(result = this.principals.contains(group = i$.next()))) {
            }
        }
        return result;
    }

    public int hashCode() {
        return ((Object)this.principals).hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder("ProjectPolicy for: ");
        result.append(this.securedProject.getId()).append('\n');
        result.append(" Grantees:  ");
        for (String principal : this.principals) {
            result.append(principal).append(' ');
        }
        return result.toString();
    }
}

