/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.security.impl;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.bpm.pml.security.exception.PmlSecurityException;
import oracle.bpm.pml.security.exception.PmlSecurityObjectNotFoundException;
import oracle.bpm.pml.security.impl.BasicSecuredProjectImpl;
import oracle.bpm.pml.security.model.BasicSecuredProject;
import oracle.bpm.pml.security.model.PmlPrincipal;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.security.model.SecuredProject;
import oracle.bpm.pml.security.service.PmlSecurityService;
import oracle.bpm.pml.security.util.SecurityServiceHelper;
import org.jetbrains.annotations.NotNull;

public class PmlSecurityServiceImpl
implements PmlSecurityService {
    private PmlPrincipal principal;
    private SecurityServiceHelper serviceHelper;

    public PmlSecurityServiceImpl(@NotNull SecurityServiceHelper serviceHelper, @NotNull String userName) throws PmlSecurityException {
        if (serviceHelper == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.<init> must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.<init> must not be null");
        }
        this.serviceHelper = serviceHelper;
        this.principal = serviceHelper.getPmlPrincipal(userName);
    }

    @Override
    public String getUserName() throws PmlSecurityException {
        return this.principal.getName();
    }

    @Override
    public PmlPrincipal getPrincipal() {
        return this.principal;
    }

    @Override
    public void publishProject(@NotNull String projectId) throws PmlSecurityException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.publishProject must not be null");
        }
        try {
            this.assertPrivilege(projectId, ProjectRole.EDITOR);
        }
        catch (PmlSecurityObjectNotFoundException e) {
            // empty catch block
        }
        HashSet<PmlPrincipal> principals = new HashSet<PmlPrincipal>();
        principals.add(this.principal);
        this.serviceHelper.grantProjectRole(ProjectRole.OWNER, projectId, principals);
    }

    @Override
    public void publishProject(@NotNull String projectId, @NotNull ProjectRole role) throws PmlSecurityException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.publishProject must not be null");
        }
        if (role == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.publishProject must not be null");
        }
        try {
            this.assertPrivilege(projectId, ProjectRole.EDITOR);
        }
        catch (PmlSecurityObjectNotFoundException e) {
            // empty catch block
        }
        HashSet<PmlPrincipal> principals = new HashSet<PmlPrincipal>();
        principals.add(PmlPrincipal.getPublicPrincipal(this.serviceHelper.getApplicationName()));
        if (!ProjectRole.OWNER.equals(role)) {
            this.serviceHelper.grantProjectRole(role, projectId, principals);
            principals.clear();
        }
        principals.add(this.principal);
        this.serviceHelper.grantProjectRole(ProjectRole.OWNER, projectId, principals);
    }

    @Override
    public void deleteProject(@NotNull String projectId) throws PmlSecurityException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.deleteProject must not be null");
        }
        this.assertPrivilege(projectId, ProjectRole.OWNER);
        this.serviceHelper.removeProject(projectId);
    }

    @Override
    public Map<String, SecuredProject> getSecuredProjects() throws PmlSecurityException {
        return this.serviceHelper.getProjectsFor(this.principal);
    }

    @Override
    public Map<String, BasicSecuredProject> getProjects() throws PmlSecurityException {
        HashMap<String, BasicSecuredProjectImpl> result = null;
        Map<String, SecuredProject> securedProjects = this.serviceHelper.getProjectsFor(this.principal);
        if (securedProjects != null) {
            result = new HashMap<String, BasicSecuredProjectImpl>();
            for (String securedProject : securedProjects.keySet()) {
                result.put(securedProject, new BasicSecuredProjectImpl(securedProjects.get(securedProject)));
            }
        }
        return result;
    }

    @Override
    public void assertPrivilege(@NotNull String projectId, @NotNull ProjectRole requiredRole) throws PmlSecurityException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.assertPrivilege must not be null");
        }
        if (requiredRole == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.assertPrivilege must not be null");
        }
        this.serviceHelper.assertPrivilege(this.principal, projectId, requiredRole);
    }

    @Override
    public String getApplicationName() {
        return this.serviceHelper.getApplicationName();
    }

    @Override
    public PmlPrincipal getPmlPrincipal(@NotNull String userName) throws PmlSecurityException {
        if (userName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.getPmlPrincipal must not be null");
        }
        return this.serviceHelper.getPmlPrincipal(userName);
    }

    @Override
    public void grantProjectRole(@NotNull ProjectRole role, @NotNull String projectName, @NotNull Set<PmlPrincipal> principals) throws PmlSecurityException {
        if (role == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.grantProjectRole must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.grantProjectRole must not be null");
        }
        if (principals == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.grantProjectRole must not be null");
        }
        this.serviceHelper.grantProjectRole(role, projectName, principals);
    }

    @Override
    public void removeProject(@NotNull String projectName) throws PmlSecurityException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.removeProject must not be null");
        }
        this.serviceHelper.removeProject(projectName);
    }

    @Override
    public void revokeProject(@NotNull String projectName) throws PmlSecurityException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.revokeProject must not be null");
        }
        this.serviceHelper.revokeProject(projectName);
    }

    @Override
    public void revokeProjectRoles(@NotNull EnumSet<ProjectRole> projectRoles, @NotNull String projectName) throws PmlSecurityException {
        if (projectRoles == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.revokeProjectRoles must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.revokeProjectRoles must not be null");
        }
        this.serviceHelper.revokeProjectRoles(projectRoles, projectName);
    }

    @Override
    public Map<String, SecuredProject> getProjectsFor(@NotNull PmlPrincipal principal) throws PmlSecurityException {
        if (principal == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.getProjectsFor must not be null");
        }
        return this.serviceHelper.getProjectsFor(principal);
    }

    @Override
    public boolean isShared(@NotNull String projectId) throws PmlSecurityException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.isShared must not be null");
        }
        return this.serviceHelper.isShared(projectId);
    }

    @Override
    public void assertPrivilege(@NotNull PmlPrincipal principal, @NotNull String projectId, @NotNull ProjectRole requiredRole) throws PmlSecurityException {
        if (principal == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.assertPrivilege must not be null");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.assertPrivilege must not be null");
        }
        if (requiredRole == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.assertPrivilege must not be null");
        }
        this.serviceHelper.assertPrivilege(principal, projectId, requiredRole);
    }

    @Override
    public ProjectRole getRoleFor(@NotNull String project, @NotNull PmlPrincipal principal) throws PmlSecurityException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.getRoleFor must not be null");
        }
        if (principal == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.getRoleFor must not be null");
        }
        return this.serviceHelper.getRoleFor(project, principal);
    }

    @Override
    public Map<ProjectRole, Set<String>> getProjectGrants(@NotNull String project) throws PmlSecurityException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/PmlSecurityServiceImpl.getProjectGrants must not be null");
        }
        return this.serviceHelper.getProjectGrants(project);
    }

    @Override
    public boolean isFirstAccess() {
        return this.serviceHelper.isFirstAccess();
    }
}

