/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.security.impl;

import java.io.Serializable;
import oracle.bpm.pml.security.model.BasicSecuredProject;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.security.model.SecuredProject;
import org.jetbrains.annotations.NotNull;

public class BasicSecuredProjectImpl
implements BasicSecuredProject,
Serializable {
    private boolean isEditable;
    private boolean isManageable;
    private boolean isOwner;
    private boolean isShared;
    private String projectId;
    private static final long serialVersionUID = 6574072331478925441L;

    public BasicSecuredProjectImpl(@NotNull SecuredProject securedProject) {
        if (securedProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/security/impl/BasicSecuredProjectImpl.<init> must not be null");
        }
        this.isEditable = securedProject.isEditable();
        this.isManageable = securedProject.isManageable();
        this.isShared = securedProject.isShared();
        this.isOwner = securedProject.isOwner();
        this.projectId = securedProject.getId();
    }

    public BasicSecuredProjectImpl(String projectId, ProjectRole projectRole, boolean isShared) {
        this.isEditable = projectRole.canEdit();
        this.isManageable = projectRole.canManage();
        this.isShared = isShared;
        this.projectId = projectId;
    }

    @Override
    public String getId() {
        return this.projectId;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public boolean isManageable() {
        return this.isManageable;
    }

    @Override
    public boolean isShared() {
        return this.isShared;
    }

    @Override
    public boolean isOwner() {
        return this.isOwner;
    }
}

