/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.studioui;

import java.awt.Component;
import java.awt.Frame;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.tutor.bpmapi.ConversionExceptions;
import oracle.bpm.tutor.bpmapi.ErrorInfo;
import oracle.bpm.tutor.bpmapi.convert2docx;
import oracle.bpm.tutor.studioui.ConverterMsgXlateUtil;
import oracle.ide.Ide;
import oracle.tutor.bpmn.ProgressDialog;
import oracle.tutor.bpmn.ProgressNotifier;
import oracle.tutor.bpmn.ProgressbarUpdater;

class worker
extends SwingWorker<String, Void> {
    private Process bpmProcess;
    private Project bpmProject;
    private boolean CONVERT_ENTIRE_PROJECT = false;
    private boolean CONVERT_ONE_PROCESS = false;
    private ProgressDialog dlg = new ProgressDialog((Frame)Ide.getMainWindow(), ConverterMsgXlateUtil.msg("CONVERT_TO_ORACLE_TUTOR"), false);
    private String filename;
    private String outputDir;

    worker() {
    }

    public void convertOneProcess(Process bpmProcess, String filename, String outputDir) {
        this.bpmProcess = bpmProcess;
        this.filename = filename;
        this.outputDir = outputDir;
        this.CONVERT_ONE_PROCESS = true;
        this.execute();
    }

    public void convertEntireProject(Project bpmProject, String outputDir) {
        this.bpmProject = bpmProject;
        this.outputDir = outputDir;
        this.CONVERT_ENTIRE_PROJECT = true;
        this.execute();
    }

    @Override
    public void done() {
        String convMsg = "";
        this.dlg.setLocation(300, 400);
        this.dlg.setVisible(true);
        try {
            convMsg = (String)this.get();
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), convMsg);
        }
        catch (ExecutionException e) {
            Throwable realException = e.getCause();
            if (realException instanceof ProjectException) {
                JOptionPane.showMessageDialog(null, ConverterMsgXlateUtil.msg("ERROR_CREATING_PROCESS"), e.getMessage(), 0);
            } else {
                this.dlg.dispose();
                this.showErrors(e);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.dlg.dispose();
    }

    @Override
    public String doInBackground() throws ProjectException, ConversionExceptions {
        ProgressbarUpdater notifier = new ProgressbarUpdater(this.dlg);
        String conversionMsg = "";
        if (this.CONVERT_ONE_PROCESS) {
            conversionMsg = convert2docx.convert((Process)this.bpmProcess, (ProgressNotifier)notifier, (String)this.filename, (String)this.outputDir);
        } else if (this.CONVERT_ENTIRE_PROJECT) {
            conversionMsg = convert2docx.convert((Project)this.bpmProject, (ProgressNotifier)notifier, (String)this.outputDir);
        }
        return conversionMsg;
    }

    void showErrors(Exception e) {
        ErrorInfo errorsDlg = new ErrorInfo((Frame)Ide.getMainWindow(), ConverterMsgXlateUtil.msg("ERRORS"), true);
        errorsDlg.setText(e.getMessage());
        errorsDlg.setVisible(true);
    }
}

