/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.studioui;

import java.awt.Component;
import javax.swing.JOptionPane;
import oracle.bpm.fusion.repository.JdevRepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.tutor.studioui.CreateBPMProcess;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.extension.RegisteredByExtension;
import oracle.ide.layout.ViewId;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.navigator.NavigatorManager;

@RegisteredByExtension(value="oracle.tutor.bpm.bpmConverter")
final class createSampleBPMProcess
implements Addin {
    createSampleBPMProcess() {
    }

    public void initialize() {
        NavigatorManager navigatorManager = NavigatorManager.getApplicationNavigatorManager();
        if (navigatorManager != null) {
            navigatorManager.getContextMenu().addContextMenuListener((ContextMenuListener)new CreateBPMSampleAction());
        }
    }

    private void createLog() {
        LogManager logManager = LogManager.getLogManager();
        logManager.addPage((LogPage)new DefaultLogPage(new ViewId("Extension Registration Info"), null, true, DefaultLogPage.HIDE_ALL_MENUS){});
    }

    private static class CreateBPMSampleAction
    implements ContextMenuListener {
        private CreateBPMSampleAction() {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            Context context = contextMenu.getContext();
            Node node = context.getNode();
            if (node instanceof Project) {
                Project ideProject = (Project)node;
                oracle.bpm.project.model.Project bpmProject = JdevRepositoryService.getInstance().getProject(ideProject);
                if (bpmProject != null) {
                    IdeAction action = IdeAction.get((int)CreateBPMSampleController.CREATE_BPM_SAMPLE_CMD_ID, null, (String)"Create BPM sample test model", null, null, null, null, (boolean)true);
                    action.addController(CreateBPMSampleController.getInstance());
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)action));
                }
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    public static class CreateBPMSampleController
    implements Controller {
        public static final int CREATE_BPM_SAMPLE_CMD_ID = Ide.findOrCreateCmdID((String)"CREATE_BPM_SAMPLE_CMD_ID");
        private static Controller instance;

        private CreateBPMSampleController() {
        }

        public static Controller getInstance() {
            if (instance == null) {
                instance = new CreateBPMSampleController();
            }
            return instance;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == CREATE_BPM_SAMPLE_CMD_ID) {
                boolean modelCreated;
                try {
                    modelCreated = CreateBPMProcess.create(this.getBpmProject(context));
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                    return false;
                }
                if (modelCreated) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), "Model created");
                    return true;
                }
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            boolean enabled = ideAction.getCommandId() == CREATE_BPM_SAMPLE_CMD_ID && this.getBpmProject(context) != null;
            ideAction.setEnabled(enabled);
            return enabled;
        }

        private oracle.bpm.project.model.Project getBpmProject(Context context) {
            oracle.bpm.project.model.Project bpmProject = null;
            Node node = context.getNode();
            if (node instanceof Project) {
                Project ideProject = (Project)node;
                bpmProject = JdevRepositoryService.getInstance().getProject(ideProject);
            }
            return bpmProject;
        }
    }
}

