/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.studioui;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bpm.fusion.core.ProjectObjectNode;
import oracle.bpm.fusion.core.model.ObjectContainerNode;
import oracle.bpm.fusion.repository.JdevRepositoryService;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.tutor.studioui.ConverterMsgXlateUtil;
import oracle.bpm.tutor.studioui.worker;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.extension.RegisteredByExtension;
import oracle.ide.model.Node;
import oracle.ide.model.Project;

@RegisteredByExtension(value="oracle.bpm.tutor.studioui")
final class ExportDocx
implements Addin {
    ExportDocx() {
    }

    public void initialize() {
    }

    private static class MyFileChooser
    extends JFileChooser {
        public MyFileChooser() {
        }

        public MyFileChooser(File openDir) {
            super(openDir);
        }

        @Override
        public void approveSelection() {
            File f = this.getSelectedFile();
            if (f.exists() && this.getDialogType() == 1) {
                int result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), f.isDirectory() ? ConverterMsgXlateUtil.msg("PROMPT_OVERWRITE_FOLDER") : ConverterMsgXlateUtil.msg("PROMPT_OVERWRITE_FILE"), ConverterMsgXlateUtil.msg("FILE_OVERWRITE"), 0, 3);
                switch (result) {
                    case 0: {
                        super.approveSelection();
                        return;
                    }
                    case 1: {
                        return;
                    }
                }
            }
            super.approveSelection();
        }
    }

    public static class ExportController
    implements Controller {
        public static final int EXPORT_ONE_PROCESS_CMD_ID = Ide.findOrCreateCmdID((String)"EXPORT_ONE_PROCESS_CMD_ID");
        public static final int EXPORT_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"EXPORT_PROJECT_CMD_ID");
        private static File priorProcessSavedIn = null;
        private static File priorProjectSavedIn = null;
        private static Controller instance;

        private ExportController() {
        }

        public static Controller getInstance() {
            if (instance == null) {
                instance = new ExportController();
            }
            return instance;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            if (action.getCommandId() == EXPORT_ONE_PROCESS_CMD_ID) {
                return this.exportProcessClicked(context);
            }
            if (action.getCommandId() == EXPORT_PROJECT_CMD_ID) {
                return this.exportProjectClicked(context);
            }
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            boolean enabled = action.getCommandId() == EXPORT_ONE_PROCESS_CMD_ID && this.getBpmProcess(context) != null || action.getCommandId() == EXPORT_PROJECT_CMD_ID && this.getBpmProject(context) != null;
            action.setEnabled(enabled);
            return enabled;
        }

        private boolean exportProcessClicked(Context context) {
            Process bpmProcess = this.getBpmProcess(context);
            File bpmPrjDir = bpmProcess.getProject().getWriter().getProjectRepository().getDefaultBaseDir();
            MyFileChooser fileChooser = null;
            fileChooser = priorProcessSavedIn == null ? new MyFileChooser(bpmPrjDir) : new MyFileChooser(priorProcessSavedIn);
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Oracle Tutor (docx)", "docx"));
            fileChooser.setSelectedFile(new File(bpmProcess.getName() + ".docx"));
            int result = fileChooser.showSaveDialog((Component)Ide.getMainWindow());
            if (result == 1) {
                return true;
            }
            if (result == -1) {
                return false;
            }
            if (result == 0) {
                File file = fileChooser.getSelectedFile();
                priorProcessSavedIn = fileChooser.getCurrentDirectory();
                worker worker2 = new worker();
                worker2.convertOneProcess(this.getBpmProcess(context), file.getName(), fileChooser.getCurrentDirectory().getAbsolutePath());
                return true;
            }
            return false;
        }

        private boolean exportProjectClicked(Context context) {
            oracle.bpm.project.model.Project bpmProject = this.getBpmProject(context);
            File bpmPrjDir = bpmProject.getWriter().getProjectRepository().getDefaultBaseDir();
            MyFileChooser fileChooser = null;
            fileChooser = priorProjectSavedIn == null ? new MyFileChooser(bpmPrjDir) : new MyFileChooser(priorProjectSavedIn);
            fileChooser.setFileSelectionMode(1);
            fileChooser.setDialogTitle(ConverterMsgXlateUtil.msg("ENTER_FOLDER_NAME"));
            fileChooser.setSelectedFile(new File(bpmProject.getName()));
            int result = fileChooser.showSaveDialog((Component)Ide.getMainWindow());
            if (result == 1) {
                return true;
            }
            if (result == -1) {
                return false;
            }
            if (result == 0) {
                priorProjectSavedIn = fileChooser.getSelectedFile();
                worker worker2 = new worker();
                worker2.convertEntireProject(this.getBpmProject(context), priorProjectSavedIn.getAbsolutePath());
                return true;
            }
            return false;
        }

        private Process getBpmProcess(Context context) {
            Process bpmProcess = null;
            Node node = context.getNode();
            if (node instanceof ProjectObjectNode && ((ProjectObjectNode)node).getObject() instanceof Process) {
                bpmProcess = (Process)((ProjectObjectNode)node).getObject();
            }
            return bpmProcess;
        }

        private oracle.bpm.project.model.Project getBpmProject(Context context) {
            ObjectContainerNode bpmNode;
            Object bpmObject;
            oracle.bpm.project.model.Project bpmProject = null;
            Node node = context.getNode();
            if (node instanceof Project) {
                Project ideProject = (Project)node;
                bpmProject = JdevRepositoryService.getInstance().getProject(ideProject);
            } else if (node instanceof ObjectContainerNode && (bpmObject = (bpmNode = (ObjectContainerNode)node).getObject()) instanceof oracle.bpm.project.model.Project) {
                bpmProject = (oracle.bpm.project.model.Project)bpmObject;
            }
            return bpmProject;
        }
    }
}

