/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.studioui;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.net.VirtualFileSystem;
import javax.ide.net.VirtualFileSystemHelper;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bpm.fusion.core.model.ObjectContainerNode;
import oracle.bpm.fusion.repository.JdevRepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.tutor.bpmapi.ConversionExceptions;
import oracle.bpm.tutor.bpmapi.ErrorInfo;
import oracle.bpm.tutor.bpmapi.convert2bpm;
import oracle.bpm.tutor.studioui.ConverterMsgXlateUtil;
import oracle.bpm.tutor.studioui.MergeSplitDialog;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.tutor.bpmn.ProgressDialog;
import oracle.tutor.bpmn.ProgressNotifier;
import oracle.tutor.bpmn.ProgressbarUpdater;
import oracle.tutor.docx.Utils;

public class BPMConverterAddin
implements Addin {
    public void initialize() {
    }

    public static class ImportController
    implements Controller {
        oracle.bpm.project.model.Project bpmProject = null;
        File[] inputFiles = null;
        String xmlFolderPath = null;
        private boolean mergePools = true;
        private boolean userCancel = false;
        public static final int IMPORT_CMD_ID = Ide.findOrCreateCmdID((String)"IMPORT_CMD_ID");
        private static File priorOpenedFolder = null;
        private static Controller instance;
        private static MergeSplitDialog dlg;

        private ImportController() {
        }

        public static Controller getInstance() {
            if (instance == null) {
                instance = new ImportController();
            }
            return instance;
        }

        public static oracle.bpm.project.model.Project getBpmProject(Context context) {
            ObjectContainerNode bpmNode;
            Object bpmObject;
            oracle.bpm.project.model.Project bpmProject = null;
            Node node = context.getNode();
            if (node instanceof Project) {
                Project ideProject = (Project)node;
                bpmProject = JdevRepositoryService.getInstance().getProject(ideProject);
            } else if (node instanceof ObjectContainerNode && (bpmObject = (bpmNode = (ObjectContainerNode)node).getObject()) instanceof oracle.bpm.project.model.Project) {
                bpmProject = (oracle.bpm.project.model.Project)bpmObject;
            }
            return bpmProject;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean handleEvent(IdeAction action, Context context) {
            if (action.getCommandId() != IMPORT_CMD_ID) return false;
            this.bpmProject = ImportController.getBpmProject(context);
            File prjDir = this.bpmProject.getWriter().getProjectRepository().getDefaultBaseDir();
            JFileChooser fileChooser = null;
            fileChooser = priorOpenedFolder == null ? new JFileChooser(prjDir) : new JFileChooser(priorOpenedFolder);
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("XPDL", "xpdl"));
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Oracle Tutor", "docx"));
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Visio", "vdx"));
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Oracle Workflow", "wft"));
            fileChooser.setAcceptAllFileFilterUsed(true);
            fileChooser.setMultiSelectionEnabled(true);
            int result = fileChooser.showOpenDialog((Component)Ide.getMainWindow());
            if (result == 1) {
                return true;
            }
            if (result == 0) {
                priorOpenedFolder = fileChooser.getCurrentDirectory();
                this.inputFiles = fileChooser.getSelectedFiles();
                this.xmlFolderPath = null;
                try {
                    Utils docx_utils = new Utils(Logger.getLogger(BPMConverterAddin.class.getName()));
                    this.xmlFolderPath = docx_utils.getTutorXMLFolderPath();
                    if (this.xmlFolderPath == null) {
                        throw new RuntimeException("tutor is not installed in this environment");
                    }
                }
                catch (RuntimeException e) {
                    this.xmlFolderPath = this.getTutorXMLFolderPath();
                }
                catch (FileNotFoundException e) {
                    ImportController.showErrors(e);
                }
                catch (IOException e) {
                    ImportController.showErrors(e);
                }
                if (!this.multiPoolModelsSelected(this.inputFiles)) return this.callConvert(null);
                dlg = new MergeSplitDialog((Component)Ide.getMainWindow(), this);
                return false;
            }
            if (result != -1) return false;
            return false;
        }

        public String getTutorXMLFolderPath() {
            String xmlFolderPath = null;
            ExtensionRegistry extnRegistery = ExtensionRegistry.getExtensionRegistry();
            Extension extn = extnRegistery.findExtension("oracle.bpm.tutor.studioui");
            if (extn != null) {
                URI uri = extnRegistery.getInstallRoot(extn);
                VirtualFileSystem fileSystem = VirtualFileSystem.getVirtualFileSystem();
                VirtualFileSystemHelper helper = fileSystem.findHelper("file");
                URI extnsFolderURI = helper.getParent(uri);
                String extnsFolderPath = helper.getPath(extnsFolderURI);
                File xmlFolder = new File(extnsFolderPath);
                xmlFolderPath = xmlFolder.getAbsolutePath() + File.separator + "tutor" + File.separator + "xml";
            }
            return xmlFolderPath;
        }

        public boolean update(IdeAction action, Context context) {
            boolean enabled = action.getCommandId() == IMPORT_CMD_ID && ImportController.getBpmProject(context) != null;
            action.setEnabled(enabled);
            return enabled;
        }

        public void setUserOptions(boolean userCancel, boolean mergePools) {
            this.userCancel = userCancel;
            this.mergePools = mergePools;
        }

        static void showErrors(Exception e) {
            ErrorInfo errorsDlg = new ErrorInfo((Frame)Ide.getMainWindow(), ConverterMsgXlateUtil.msg("ERRORS"), true);
            errorsDlg.setText(e.getMessage());
            errorsDlg.setVisible(true);
        }

        void cancelOutOfImport(MergeSplitDialog dlg) {
            if (dlg.isCancelled()) {
                dlg.dispose();
            }
        }

        boolean callConvert(MergeSplitDialog dlg) {
            if (dlg != null) {
                this.mergePools = dlg.wantToMergePools();
                dlg.dispose();
            }
            final ProgressDialog progressDlg = new ProgressDialog((Frame)Ide.getMainWindow(), ConverterMsgXlateUtil.msg("CONVERT_TO_BPM_PROCESS"), false);
            try {
                ProgressbarUpdater notifier = new ProgressbarUpdater(progressDlg){
                    {
                        super(x0);
                        progressDlg.setLocation(300, 400);
                        progressDlg.setVisible(true);
                    }
                };
                String successfulConversionMsg = convert2bpm.convert((File[])this.inputFiles, (oracle.bpm.project.model.Project)this.bpmProject, (String)this.xmlFolderPath, (ProgressNotifier)notifier, (boolean)this.mergePools);
                progressDlg.dispose();
                this.inputFiles = null;
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), successfulConversionMsg);
                return true;
            }
            catch (ProjectException e) {
                progressDlg.dispose();
                JOptionPane.showMessageDialog(null, ConverterMsgXlateUtil.msg("ERROR_CREATING_PROCESS"), e.getMessage(), 0);
            }
            catch (ConversionExceptions e) {
                progressDlg.dispose();
                ImportController.showErrors((Exception)((Object)e));
            }
            catch (Exception e) {
                progressDlg.dispose();
                ImportController.showErrors(e);
            }
            return false;
        }

        private boolean multiPoolModelsSelected(File[] inputFiles) {
            for (File file : inputFiles) {
                String ext;
                String filename = file.getName();
                String string = ext = filename.lastIndexOf(".") == -1 ? "" : filename.substring(filename.lastIndexOf(".") + 1);
                if (!ext.equalsIgnoreCase("xpdl") && !ext.equalsIgnoreCase("vdx")) continue;
                return true;
            }
            return false;
        }

        static {
            dlg = null;
        }
    }
}

